package com.biz.crm.tpm.business.channel.price.monitor.sdk.event.log;

import com.biz.crm.tpm.business.channel.price.monitor.sdk.dto.log.TpmChannelPriceMonitorLogEventDto;
import com.bizunited.nebula.event.sdk.service.NebulaEvent;

/**
 * @author duyiran
 * @date 2022年10月26日 14:15
 */
public interface TpmChannelPriceMonitorLogEventListener extends NebulaEvent {
    /**
     * 创建预算项目事件
     *
     * @param dto dto
     * @author duyiran
     * @date 2022/10/24 17:10
     **/
    void onCreate(TpmChannelPriceMonitorLogEventDto dto);

    /**
     * 删除预算项目事件
     *
     * @param dto dto
     * @author duyiran
     * @date 2022/10/24 17:10
     **/
    void onDelete(TpmChannelPriceMonitorLogEventDto dto);

    /**
     * 修改预算项目事件
     *
     * @param dto dto
     * @author duyiran
     * @date 2022/10/24 17:10
     **/
    void onUpdate(TpmChannelPriceMonitorLogEventDto dto);

    /**
     * 启用预算项目事件
     *
     * @param dto dto
     * @author duyiran
     * @date 2022/10/24 17:10
     **/
    void onEnable(TpmChannelPriceMonitorLogEventDto dto);

    /**
     * 禁用预算项目事件
     *
     * @param dto dto
     * @author duyiran
     * @date 2022/10/24 17:10
     **/
    void onDisable(TpmChannelPriceMonitorLogEventDto dto);
}
