package com.biz.crm.tpm.business.channel.price.monitor.sdk.vo;

import java.math.*;
import java.util.Date;

import com.biz.crm.business.common.sdk.dto.TenantFlagOpDto;
import com.biz.crm.business.common.sdk.vo.TenantFlagOpVo;
import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import org.springframework.format.annotation.DateTimeFormat;

/**
 * 渠道价格
 *
 * @author zhouyang
 * @date 2023-07-26 18:15:45
 */
@Data
@EqualsAndHashCode(callSuper = false)
@ApiModel(value = "ChannelPriceVo", description = "渠道价格")
public class ChannelPriceVo extends TenantFlagOpVo {

    @ApiModelProperty("年月")
    private String priceYearMonth;

    @ApiModelProperty("货品编号")
    private String goodsCode;

    @ApiModelProperty("货品名称")
    private String goodsName;

    @ApiModelProperty("业务模式")
    private String businessModelCode;

    @ApiModelProperty("业务模式名称")
    private String businessModelName;

    @ApiModelProperty("品牌编码")
    private String productBrandCode;

    @ApiModelProperty("品牌名称")
    private String productBrandName;

    @ApiModelProperty("业态编码")
    private String businessFormatCode;

    @ApiModelProperty("业态名称")
    private String businessFormatName;

    @ApiModelProperty("渠道编码")
    private String channelCode;

    @ApiModelProperty("渠道")
    private String channelName;

    @ApiModelProperty("销售机构编码")
    private String salesInstitutionCode;

    @ApiModelProperty("销售机构名称")
    private String salesInstitutionName;

    @ApiModelProperty("客户编码")
    private String customerCode;

    @ApiModelProperty("客户名称")
    private String customerName;

    @ApiModelProperty("平台编码")
    private String platformCode;

    @ApiModelProperty("平台名称")
    private String platformName;

    @ApiModelProperty("活动形式编码")
    private String activityFormCode;

    @ApiModelProperty("活动形式名称")
    private String activityFormName;

    @ApiModelProperty("电商渠道编码")
    private String estoreChannel;

    @ApiModelProperty("电商渠道名称")
    private String estoreChannelName;

    @ApiModelProperty("标准零售价（元）")
    private BigDecimal suggestedRetailPrice;

    @ApiModelProperty("红线价（元）")
    private BigDecimal redLinePrice;

    @ApiModelProperty("促销选品价（元）")
    private BigDecimal promotionPrice;

    @ApiModelProperty("预估最低价（元）")
    private BigDecimal estimateLowerPrice;

    @ApiModelProperty("活动底价（元）")
    private BigDecimal activityLowerPrice;

    @ApiModelProperty("实际销售价（元）")
    private BigDecimal salePrice;

    @ApiModelProperty("实际销售价VS红线价")
    private BigDecimal saleVsRedLinePrice;

    @ApiModelProperty("实际销售价VS促销选品价")
    private BigDecimal saleVsPromotionPrice;

    @ApiModelProperty("实际销售价VS预估最低价")
    private BigDecimal saleVsEstimateLowerPrice;

    @ApiModelProperty("实际销售价VS活动底价")
    private BigDecimal saleVsActivityLowerPrice;

    @ApiModelProperty("交易日期")
    @JsonFormat(locale = "zh", timezone = "GMT+8", pattern = "yyyy-MM-dd HH:mm:ss")
    @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    private Date tradeDate;
}