package com.biz.crm.tpm.business.channel.price.monitor.sdk.vo;

import com.biz.crm.common.ie.sdk.excel.annotations.CrmExcelColumn;
import com.biz.crm.common.ie.sdk.excel.annotations.CrmExcelImport;
import com.biz.crm.common.ie.sdk.excel.vo.CrmExcelVo;
import lombok.Data;
import lombok.EqualsAndHashCode;
import org.springframework.format.annotation.DateTimeFormat;

import java.math.BigDecimal;
import java.util.Date;


/**
 * 导入Vo
 *
 * @author duyiran
 * @create 2022-10-29 17:25
 */
@Data
@CrmExcelImport
@EqualsAndHashCode(callSuper = true)
public class TpmChannelPriceMonitorImportsVo extends CrmExcelVo {

    /**
     * 客户编码
     */
    @CrmExcelColumn(value = "客户编码")
    private String customerCode;

    /**
     * 客户名称
     */
    @CrmExcelColumn(value = "客户名称")
    private String customerName;

    /**
     * 日期
     */
    @CrmExcelColumn(value = "日期")
    private String promotionDateStr;

    @DateTimeFormat(pattern = "yyyy-MM-dd")
    private Date promotionDate;

    /**
     * 产品编码
     */
    @CrmExcelColumn(value = "产品编码")
    private String productCode;

    /**
     * 产品名称
     */
    @CrmExcelColumn(value = "产品名称")
    private String productName;

    /**
     * 渠道编码
     */
    @CrmExcelColumn(value = "渠道编码")
    private String channelCode;

    /**
     * 渠道名称
     */
    @CrmExcelColumn(value = "渠道名称")
    private String channelName;

    /**
     * 活动形式编码
     */
//    @CrmExcelColumn(value = "活动形式编码")
//    private String activityFormCode;

    /**
     * 活动形式名称
     */
    @CrmExcelColumn(value = "活动形式")
    private String activityFormName;

    /**
     * 建议零售价
     */
    @CrmExcelColumn(value = "建议零售价")
    private String suggestedRetailPriceStr;

    private BigDecimal suggestedRetailPrice;

    /**
     * 促销选品价
     */
    @CrmExcelColumn(value = "促销选品价")
    private String selectionPriceStr;

    private BigDecimal selectionPrice;

    /**
     * 基础面价
     */
    @CrmExcelColumn(value = "基础面价")
    private String baseMarketPriceStr;

    private BigDecimal baseMarketPrice;

    /**
     * 闪秒面价
     */
    @CrmExcelColumn(value = "闪秒面价")
    private String flashMarketPriceStr;

    private BigDecimal flashMarketPrice;

    /**
     * 会员专享价
     */
    @CrmExcelColumn(value = "会员专享价")
    private String exclusivePriceForMembersStr;

    private BigDecimal exclusivePriceForMembers;

    /**
     * 最终面价
     */
    @CrmExcelColumn(value = "最终面价")
    private String finalMarketPriceStr;

    private BigDecimal finalMarketPrice;

    /**
     * 折扣
     */
    @CrmExcelColumn(value = "折扣")
    private String discountStr;

    private BigDecimal discount;

    /**
     * 区域折扣
     */
    @CrmExcelColumn(value = "区域折扣")
    private String areaDiscountStr;

    private BigDecimal areaDiscount;

    /**
     * 优惠券
     */
    @CrmExcelColumn(value = "优惠券")
    private String discountCouponStr;

    private BigDecimal discountCoupon;

    /**
     * 全国会员预估到手价
     */
    @CrmExcelColumn(value = "全国会员预估到手价")
    private String estimatePriceForNationwideMembersStr;

    private BigDecimal estimatePriceForNationwideMembers;

    /**
     * 非会员预估到手价
     */
    @CrmExcelColumn(value = "非会员预估到手价")
    private String estimatePriceForNonmembersStr;

    private BigDecimal estimatePriceForNonmembers;

    /**
     * 区域非会员预估到手价
     */
    @CrmExcelColumn(value = "区域非会员预估到手价")
    private String estimatePriceForAreaNonmembersStr;

    private BigDecimal estimatePriceForAreaNonmembers;

    /**
     * 折扣力度
     */
    @CrmExcelColumn(value = "折扣力度")
    private String discountIntensityStr;

    private BigDecimal discountIntensity;

    /**
     * 预估最低价
     */
    @CrmExcelColumn(value = "预估最低价")
    private String estimateFloorPriceStr;

    private BigDecimal estimateFloorPrice;

    /**
     * 库存最早月份
     */
    @CrmExcelColumn(value = "库存最早月份")
    private String earliestMonthInRepertoryStr;

    @DateTimeFormat(pattern = "yyyy-MM")
    private Date earliestMonthInRepertory;

}
