/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.tpm.business.customer.launch.costs.local.process;

import com.biz.crm.common.ie.sdk.excel.process.ImportProcess;
import com.biz.crm.common.ie.sdk.vo.TaskGlobalParamsVo;
import com.biz.crm.mdm.business.customer.channel.sdk.service.CustomerChannelVoService;
import com.biz.crm.mdm.business.customer.channel.sdk.vo.CustomerChannelVo;
import com.biz.crm.mdm.business.customer.sdk.service.CustomerVoService;
import com.biz.crm.mdm.business.customer.sdk.vo.CustomerVo;
import com.biz.crm.mdm.business.dictionary.sdk.service.DictToolkitService;
import com.biz.crm.mdm.business.sales.org.sdk.service.SalesOrgVoService;
import com.biz.crm.mdm.business.sales.org.sdk.vo.SalesOrgVo;
import com.biz.crm.mn.common.base.util.DateUtil;
import com.biz.crm.tpm.business.customer.launch.costs.sdk.dto.TpmCustomerLaunchCostsDto;
import com.biz.crm.tpm.business.customer.launch.costs.sdk.service.TpmCustomerLaunchCostsService;
import com.biz.crm.tpm.business.customer.launch.costs.sdk.vo.TpmCustomerLaunchCostsImportVo;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class TpmCustomerLaunchCostsImportProcess
implements ImportProcess<TpmCustomerLaunchCostsImportVo> {
    private static final Logger log = LoggerFactory.getLogger(TpmCustomerLaunchCostsImportProcess.class);
    @Autowired(required=false)
    private DictToolkitService dictToolkitService;
    @Autowired(required=false)
    private NebulaToolkitService nebulaToolkitService;
    @Autowired(required=false)
    private TpmCustomerLaunchCostsService tpmCustomerLaunchCostsService;
    @Autowired(required=false)
    private CustomerVoService customerVoService;
    @Autowired(required=false)
    private SalesOrgVoService salesOrgVoService;
    @Autowired(required=false)
    private CustomerChannelVoService customerChannelVoService;

    public Integer getBatchCount() {
        return 1000;
    }

    public Map<Integer, String> execute(LinkedHashMap<Integer, TpmCustomerLaunchCostsImportVo> data, TaskGlobalParamsVo paramsVo, Map<String, Object> params) {
        Validate.notNull(data, (String)"\u5bfc\u5165\u6570\u636e\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.isTrue((data.values().size() <= 1000 ? 1 : 0) != 0, (String)"\u5355\u6b21\u5bfc\u5165\u6570\u636e\u4e0d\u80fd\u8d85\u8fc71000\u6761", (Object[])new Object[0]);
        List<TpmCustomerLaunchCostsDto> importList = this.validate(data);
        this.tpmCustomerLaunchCostsService.importSave(importList);
        return null;
    }

    private List<TpmCustomerLaunchCostsDto> validate(LinkedHashMap<Integer, TpmCustomerLaunchCostsImportVo> data) {
        Collection<TpmCustomerLaunchCostsImportVo> values = data.values();
        HashMap<String, List<CustomerVo>> customerVoMap = new HashMap<String, List<CustomerVo>>();
        HashMap<String, List<SalesOrgVo>> salesInstitutionMap = new HashMap<String, List<SalesOrgVo>>();
        HashMap<String, List<CustomerChannelVo>> customerChannelMap = new HashMap<String, List<CustomerChannelVo>>();
        this.queryMasterData(values, customerVoMap, salesInstitutionMap, customerChannelMap);
        Map formatMap = this.dictToolkitService.findConvertMapByDictTypeCode("mdm_business_format");
        Validate.isTrue((boolean)ObjectUtils.isNotEmpty((Object)formatMap), (String)"\u672a\u67e5\u8be2\u5230\u4e1a\u6001\u6570\u636e\u5b57\u5178!", (Object[])new Object[0]);
        ArrayList<TpmCustomerLaunchCostsDto> customerLaunchCostsDtos = new ArrayList<TpmCustomerLaunchCostsDto>();
        ArrayList list = new ArrayList();
        data.forEach((k, v) -> {
            Integer index = k + 2;
            String businessFormatCode = v.getBusinessFormatCode();
            Validate.notBlank((CharSequence)businessFormatCode, (String)"[\u884c%s]\u4e1a\u6001\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[]{index});
            String salesInstitutionCode = v.getSalesInstitutionCode();
            Validate.notBlank((CharSequence)salesInstitutionCode, (String)"[\u884c%s]\u9500\u552e\u673a\u6784\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[]{index});
            String customerCode = v.getCustomerCode();
            Validate.notBlank((CharSequence)customerCode, (String)"[\u884c%s]\u5ba2\u6237\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[]{index});
            List customerVos = (List)customerVoMap.get(customerCode);
            Validate.isTrue((boolean)CollectionUtils.isNotEmpty((Collection)customerVos), (String)("\u884c\u53f7\uff1a" + index + ",\u5ba2\u6237\u7f16\u7801\u672a\u80fd\u5339\u914d\u5230"), (Object[])new Object[0]);
            BigDecimal customerAmountProvided = v.getCustomerAmountProvided();
            Validate.notNull((Object)customerAmountProvided, (String)"[\u884c%s]\u5ba2\u6237\u63d0\u4f9b\u91d1\u989d\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[]{index});
            Validate.isTrue((boolean)formatMap.containsKey(businessFormatCode), (String)"[\u884c%s]\u4e1a\u6001\u672a\u80fd\u8bc6\u522b", (long)index.intValue());
            List salesInstitutionVos = (List)salesInstitutionMap.get(salesInstitutionCode);
            Validate.isTrue((boolean)CollectionUtils.isNotEmpty((Collection)salesInstitutionVos), (String)("\u884c\u53f7\uff1a" + index + ",\u9500\u552e\u673a\u6784\u7f16\u7801\u672a\u80fd\u5339\u914d\u5230"), (Object[])new Object[0]);
            String distributionCustomerMonthSaleYearMonth = v.getDistributionCustomerMonthSaleYearMonth();
            Validate.notBlank((CharSequence)distributionCustomerMonthSaleYearMonth, (String)"[\u884c%s]\u5e74\u6708\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[]{index});
            Validate.isTrue((distributionCustomerMonthSaleYearMonth.length() == 7 ? 1 : 0) != 0, (String)("[\u884c" + index + "]\u5e74\u6708\u9519\u8bef,\u4f8b\uff1a2023-01"), (Object[])new Object[0]);
            DateUtil.date_yyyy_MM.setLenient(false);
            try {
                Date yearMonth = DateUtil.date_yyyy_MM.parse(distributionCustomerMonthSaleYearMonth);
                this.validateIsTrue(distributionCustomerMonthSaleYearMonth.equals(DateUtil.date_yyyy_MM.format(yearMonth)), "[\u884c" + index + "]\u5e74\u6708\u9519\u8bef,\u4f8b\uff1a2023-01");
            }
            catch (Exception e) {
                this.validateIsTrue(false, "[\u884c" + index + "]\u5e74\u6708\u683c\u5f0f\u9519\u8bef\u3010yyyy-MM\u3011\u6216\u4e0d\u5408\u6cd5");
            }
            String channelCode = v.getChannelCode();
            Validate.notBlank((CharSequence)channelCode, (String)"[\u884c%s]\u6e20\u9053\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[]{index});
            List customerChannelVos = (List)customerChannelMap.get(channelCode);
            Validate.isTrue((!CollectionUtils.isEmpty((Collection)customerChannelVos) && Objects.nonNull(customerChannelVos.get(0)) ? 1 : 0) != 0, (String)("\u884c\u53f7\uff1a" + index + ",\u6e20\u9053" + channelCode + "\u672a\u80fd\u5339\u914d\u5230"), (Object[])new Object[0]);
            String verifyCode = customerCode.concat(distributionCustomerMonthSaleYearMonth);
            Validate.isTrue((!list.contains(verifyCode) ? 1 : 0) != 0, (String)("[\u884c" + index + "]\u5ba2\u6237\u7f16\u7801+\u5e74\u6708\u5b58\u5728\u91cd\u590d\uff01"), (Object[])new Object[0]);
            list.add(verifyCode);
            TpmCustomerLaunchCostsDto dto = (TpmCustomerLaunchCostsDto)this.nebulaToolkitService.copyObjectByWhiteList(v, TpmCustomerLaunchCostsDto.class, LinkedHashSet.class, ArrayList.class, new String[0]);
            dto.setChannelCode(((CustomerChannelVo)customerChannelVos.get(0)).getCustomerChannelCode());
            dto.setSalesInstitutionName(((SalesOrgVo)salesInstitutionVos.get(0)).getSalesOrgName());
            dto.setBusinessFormatCode((String)formatMap.get(businessFormatCode));
            dto.setCustomerName(((CustomerVo)customerVos.get(0)).getCustomerName());
            dto.setVerifyCode(verifyCode);
            List levelList = customerVos.stream().map(CustomerVo::getEstoreCustomerLevel).filter(StringUtils::isNotBlank).collect(Collectors.toList());
            if (CollectionUtils.isNotEmpty(levelList)) {
                dto.setCustomerLevel((String)levelList.get(0));
            }
            customerLaunchCostsDtos.add(dto);
        });
        return customerLaunchCostsDtos;
    }

    private void queryMasterData(Collection<TpmCustomerLaunchCostsImportVo> values, Map<String, List<CustomerVo>> customerVoMap, Map<String, List<SalesOrgVo>> salesInstitutionMap, Map<String, List<CustomerChannelVo>> customerChannelMap) {
        List byCodes;
        List salesInstitutions;
        List salesInstitutionCodes = values.stream().map(TpmCustomerLaunchCostsImportVo::getSalesInstitutionCode).filter(StringUtils::isNotBlank).collect(Collectors.toList());
        List customerCodes = values.stream().map(a -> a.getCustomerCode() + "11712011").collect(Collectors.toList());
        List channelCodes = values.stream().map(TpmCustomerLaunchCostsImportVo::getChannelCode).filter(StringUtils::isNotBlank).collect(Collectors.toList());
        List baseByCustomerCodes = this.customerVoService.findBaseByCustomerCodes(customerCodes);
        if (CollectionUtils.isNotEmpty((Collection)baseByCustomerCodes)) {
            Map<String, List<CustomerVo>> map = baseByCustomerCodes.stream().collect(Collectors.groupingBy(CustomerVo::getErpCode));
            customerVoMap.putAll(map);
        }
        if (CollectionUtils.isNotEmpty((Collection)(salesInstitutions = this.salesOrgVoService.findBySalesOrgCodesPost(salesInstitutionCodes)))) {
            Map<String, List<SalesOrgVo>> map = salesInstitutions.stream().collect(Collectors.groupingBy(SalesOrgVo::getErpCode));
            salesInstitutionMap.putAll(map);
        }
        if (CollectionUtils.isNotEmpty((Collection)(byCodes = this.customerChannelVoService.findByCodes(channelCodes)))) {
            Map<String, List<CustomerChannelVo>> map = byCodes.stream().collect(Collectors.groupingBy(CustomerChannelVo::getCustomerChannelCode));
            customerChannelMap.putAll(map);
        }
    }

    public Class<TpmCustomerLaunchCostsImportVo> findCrmExcelVoClass() {
        return TpmCustomerLaunchCostsImportVo.class;
    }

    public String getBusinessCode() {
        return "TPM_CUSTOMER_LAUNCH_COSTS_IMPORT";
    }

    public String getBusinessName() {
        return "TPM\u5206\u9500\u5ba2\u6237\u6295\u653e\u8d39\u7528\u5bfc\u5165";
    }

    public String getTemplateCode() {
        return "TPM_CUSTOMER_LAUNCH_COSTS_IMPORT";
    }

    public String getTemplateName() {
        return "TPM-\u5206\u9500\u5ba2\u6237\u6295\u653e\u8d39\u7528\u6a21\u677f";
    }
}

