/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.tpm.business.customer.launch.costs.local.process;

import com.alibaba.fastjson.JSONObject;
import com.biz.crm.common.ie.sdk.excel.process.ImportProcess;
import com.biz.crm.common.ie.sdk.vo.TaskGlobalParamsVo;
import com.biz.crm.mdm.business.cost.center.sdk.service.CostCenterVoService;
import com.biz.crm.mdm.business.cost.center.sdk.vo.CostCenterVo;
import com.biz.crm.mdm.business.customer.channel.sdk.service.CustomerChannelVoService;
import com.biz.crm.mdm.business.customer.channel.sdk.vo.CustomerChannelVo;
import com.biz.crm.mdm.business.customer.sdk.service.CustomerVoService;
import com.biz.crm.mdm.business.customer.sdk.vo.CustomerVo;
import com.biz.crm.mdm.business.dictionary.sdk.service.DictDataVoService;
import com.biz.crm.mdm.business.dictionary.sdk.service.DictToolkitService;
import com.biz.crm.mdm.business.dictionary.sdk.vo.DictDataVo;
import com.biz.crm.mdm.business.sales.org.sdk.service.SalesOrgVoService;
import com.biz.crm.mdm.business.sales.org.sdk.vo.SalesOrgVo;
import com.biz.crm.mdm.business.supplier.sdk.service.SupplierVoService;
import com.biz.crm.mdm.business.supplier.sdk.vo.SupplierVo;
import com.biz.crm.mn.common.base.eunm.YesOrNoEnum;
import com.biz.crm.tpm.business.customer.launch.costs.local.service.CustomerServiceFeeService;
import com.biz.crm.tpm.business.customer.launch.costs.sdk.vo.CustomerServiceFeeImportVo;
import com.biz.crm.tpm.business.customer.launch.costs.sdk.vo.CustomerServiceFeeVo;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class TpmCustomerServiceFeeImportProcess
implements ImportProcess<CustomerServiceFeeImportVo> {
    private static final Logger log = LoggerFactory.getLogger(TpmCustomerServiceFeeImportProcess.class);
    private static final String TPM_CUSTOMER_SERVICE_FEES1 = "tpm_customer_service_fees1";
    private static final String TPM_CUSTOMER_SERVICE_FEES2 = "tpm_customer_service_fees2";
    private static final String TPM_CUSTOMER_SERVICE_FEES3 = "tpm_customer_service_fees3";
    private static final String TPM_CUSTOMER_SERVICE_FEES4 = "tpm_customer_service_fees4";
    private static final String TPM_CUSTOMER_SERVICE_FEES5 = "tpm_customer_service_fees5";
    private static final String KFFYJSPD = "kffyjspd";
    @Autowired(required=false)
    private NebulaToolkitService nebulaToolkitService;
    @Autowired(required=false)
    private CustomerVoService customerVoService;
    @Autowired(required=false)
    private SalesOrgVoService salesOrgVoService;
    @Autowired(required=false)
    private CustomerChannelVoService customerChannelVoService;
    @Autowired(required=false)
    private CustomerServiceFeeService customerServiceFeeService;
    @Autowired(required=false)
    private DictDataVoService dictDataVoService;
    @Autowired(required=false)
    private DictToolkitService dictToolkitService;
    @Autowired(required=false)
    private CostCenterVoService costCenterVoService;
    @Autowired(required=false)
    private SupplierVoService supplierVoService;

    public Integer getBatchCount() {
        return Integer.MAX_VALUE;
    }

    public Map<Integer, String> execute(LinkedHashMap<Integer, CustomerServiceFeeImportVo> data, TaskGlobalParamsVo paramsVo, Map<String, Object> params) {
        Validate.notNull(data, (String)"\u5bfc\u5165\u6570\u636e\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.isTrue((data.values().size() <= this.getBatchCount() ? 1 : 0) != 0, (String)"\u5355\u6b21\u5bfc\u5165\u6570\u636e\u4e0d\u80fd\u8d85\u8fc72000\u6761", (Object[])new Object[0]);
        HashMap error = Maps.newHashMap();
        List<CustomerServiceFeeVo> importList = this.validate(data, error);
        if (MapUtils.isNotEmpty((Map)error)) {
            return error;
        }
        this.customerServiceFeeService.createBatch(importList);
        return null;
    }

    private List<CustomerServiceFeeVo> validate(LinkedHashMap<Integer, CustomerServiceFeeImportVo> data, Map<Integer, String> error) {
        List<String> itemKeys;
        List<CustomerServiceFeeVo> vos;
        List supplierCodes;
        List supplierVos;
        Map businessFormMap = this.dictToolkitService.findConvertMapByDictTypeCode("mdm_business_format");
        Map dict = this.dictDataVoService.findByDictTypeCodeList((List)Lists.newArrayList((Object[])new String[]{TPM_CUSTOMER_SERVICE_FEES1, TPM_CUSTOMER_SERVICE_FEES2, TPM_CUSTOMER_SERVICE_FEES3, TPM_CUSTOMER_SERVICE_FEES4, TPM_CUSTOMER_SERVICE_FEES5, KFFYJSPD}));
        log.info("\u5206\u9500\u5ba2\u670d\u8d39\u7528\u5bfc\u5165,dict:{}", (Object)JSONObject.toJSONString((Object)dict));
        HashMap customerVoMap = Maps.newHashMap();
        HashMap salesInstitutionMap = Maps.newHashMap();
        HashMap customerChannelMap = Maps.newHashMap();
        HashMap costCenterMap = Maps.newHashMap();
        HashMap supplierMap = Maps.newHashMap();
        this.queryMasterData(data.values(), customerVoMap, customerChannelMap, costCenterMap);
        data.forEach((k, v) -> {
            StringBuffer sb = new StringBuffer();
            if (StringUtils.isBlank((CharSequence)v.getBusinessFormatCode())) {
                sb.append("\u4e1a\u6001\u4e0d\u80fd\u4e3a\u7a7a;");
            } else if (!businessFormMap.containsKey(v.getBusinessFormatCode())) {
                sb.append("\u4e1a\u6001\u4e0d\u5b58\u5728;");
            } else {
                v.setBusinessFormatCode((String)businessFormMap.get(v.getBusinessFormatCode()));
            }
            if (StringUtils.isBlank((CharSequence)v.getChannelCode())) {
                sb.append("\u6e20\u9053\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a;");
            } else if (!customerChannelMap.containsKey(v.getChannelCode())) {
                sb.append("\u6e20\u9053\u7f16\u7801\u4e0d\u5b58\u5728;");
            } else {
                v.setChannelName(((CustomerChannelVo)((List)customerChannelMap.get(v.getChannelCode())).get(0)).getCustomerChannelName());
            }
            if (StringUtils.isBlank((CharSequence)v.getSalesInstitutionCode())) {
                sb.append("\u9500\u552e\u673a\u6784\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a;");
            }
            if (sb.length() > 0) {
                error.put((Integer)k, sb.toString());
            }
        });
        List salesInstitutionCodes = data.values().stream().filter(e -> StringUtils.isNotBlank((CharSequence)e.getBusinessFormatCode()) && StringUtils.isNotBlank((CharSequence)e.getChannelCode()) && StringUtils.isNotBlank((CharSequence)e.getSalesInstitutionCode())).map(e -> StringUtils.join((Object[])new String[]{e.getChannelCode(), e.getBusinessFormatCode(), e.getSalesInstitutionCode()})).distinct().collect(Collectors.toList());
        List salesInstitutions = this.salesOrgVoService.findBySalesOrgCodesPost(salesInstitutionCodes);
        if (CollectionUtils.isNotEmpty((Collection)salesInstitutions)) {
            Map<String, List<SalesOrgVo>> map = salesInstitutions.stream().collect(Collectors.groupingBy(SalesOrgVo::getErpCode));
            salesInstitutionMap.putAll(map);
        }
        log.info("\u5206\u9500\u5ba2\u670d\u8d39\u7528\u5bfc\u5165,costCenterMap:{}", (Object)JSONObject.toJSONString((Object)costCenterMap));
        data.forEach((k, v) -> {
            StringBuffer sb = new StringBuffer();
            if (!salesInstitutionMap.containsKey(v.getSalesInstitutionCode())) {
                sb.append("\u6e20\u9053+\u4e1a\u6001+\u9500\u552e\u673a\u6784\u7f16\u7801\u4e0d\u5b58\u5728;");
            } else {
                v.setSalesInstitutionName(((SalesOrgVo)((List)salesInstitutionMap.get(v.getSalesInstitutionCode())).get(0)).getSalesOrgName());
            }
            if (StringUtils.isBlank((CharSequence)v.getCostCenterCode())) {
                sb.append("\u6210\u672c\u4e2d\u5fc3\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a;");
            } else if (!costCenterMap.containsKey(v.getCostCenterCode())) {
                sb.append("\u6210\u672c\u4e2d\u5fc3\u7f16\u7801\u4e0d\u5b58\u5728;");
            } else {
                log.info("\u5206\u9500\u5ba2\u670d\u8d39\u7528\u5bfc\u5165,\u5b57\u5178\u8f6c\u6362,costCenterCode:{}", (Object)v.getCostCenterCode());
                v.setCostCenterName(((CostCenterVo)costCenterMap.get(v.getCostCenterCode())).getCostCenterName());
                v.setSupplierCode(this.dictFilter(dict, v.getCostCenterCode(), TPM_CUSTOMER_SERVICE_FEES2, "\u6210\u672c\u4e2d\u5fc3\u672a\u627e\u5230\u4f9b\u5e94\u5546;", sb));
                v.setCustomerCode(this.dictFilter(dict, v.getCostCenterCode(), TPM_CUSTOMER_SERVICE_FEES1, "\u6210\u54c1\u4e2d\u5fc3\u672a\u627e\u5230\u5ba2\u6237;", sb));
                String number = this.dictFilter(dict, v.getCostCenterCode(), TPM_CUSTOMER_SERVICE_FEES5, "\u6210\u672c\u4e2d\u5fc3\u672a\u627e\u5230\u4eba\u6570;", sb);
                v.setNumber(Integer.valueOf(StringUtils.isNotBlank((CharSequence)number) ? Integer.valueOf(number) : 0));
                String customerServicePrice = this.dictFilter(dict, v.getSupplierCode(), TPM_CUSTOMER_SERVICE_FEES3, "\u6210\u672c\u4e2d\u5fc3\u672a\u627e\u5230\u5ba2\u670d\u5355\u4ef7;", sb);
                v.setCustomerServicePrice(StringUtils.isNotBlank((CharSequence)customerServicePrice) ? new BigDecimal(customerServicePrice) : BigDecimal.ZERO);
                String overtimeAmount = this.dictFilter(dict, v.getSupplierCode(), TPM_CUSTOMER_SERVICE_FEES4, "\u6210\u672c\u4e2d\u5fc3\u672a\u627e\u5230\u52a0\u73ed\u8d39;", sb);
                v.setOvertimeAmount(StringUtils.isNotBlank((CharSequence)overtimeAmount) ? new BigDecimal(overtimeAmount) : BigDecimal.ZERO);
            }
            if (sb.length() > 0) {
                if (error.containsKey(k)) {
                    error.put((Integer)k, (String)error.get(k) + sb.toString());
                } else {
                    error.put((Integer)k, sb.toString());
                }
            }
        });
        List customerCodes = data.values().stream().filter(e -> StringUtils.isNotBlank((CharSequence)e.getBusinessFormatCode()) && StringUtils.isNotBlank((CharSequence)e.getChannelCode()) && StringUtils.isNotBlank((CharSequence)e.getSalesInstitutionCode()) && StringUtils.isNotBlank((CharSequence)e.getCustomerCode())).map(e -> StringUtils.join((Object[])new String[]{e.getCustomerCode(), e.getSalesInstitutionCode(), e.getChannelCode(), e.getBusinessFormatCode()})).distinct().collect(Collectors.toList());
        List baseByCustomerCodes = this.customerVoService.findBaseByCustomerCodes(customerCodes);
        if (CollectionUtils.isNotEmpty((Collection)baseByCustomerCodes)) {
            Map<String, List<CustomerVo>> map = baseByCustomerCodes.stream().collect(Collectors.groupingBy(CustomerVo::getErpCode));
            customerVoMap.putAll(map);
        }
        if (CollectionUtils.isNotEmpty((Collection)(supplierVos = this.supplierVoService.findBySupplierCodes(supplierCodes = data.values().stream().filter(e -> StringUtils.isNotBlank((CharSequence)e.getSupplierCode())).map(CustomerServiceFeeImportVo::getSupplierCode).distinct().collect(Collectors.toList()))))) {
            Map map = supplierVos.stream().collect(Collectors.toMap(SupplierVo::getSupplierCode, Function.identity(), (v1, v2) -> v1));
            supplierMap.putAll(map);
        }
        HashMap itemKeyMap = Maps.newHashMap();
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM");
        data.forEach((k, v) -> {
            StringBuffer sb = new StringBuffer();
            if (!supplierMap.containsKey(v.getSupplierCode())) {
                sb.append("\u4f9b\u5e94\u5546\u7f16\u7801\u4e0d\u5b58\u5728;");
            } else {
                v.setSupplierName(((SupplierVo)supplierMap.get(v.getSupplierCode())).getSupplierName());
            }
            if (!customerVoMap.containsKey(v.getCustomerCode())) {
                sb.append("\u4e1a\u6001+\u6e20\u9053+\u9500\u552e\u673a\u6784+\u5ba2\u6237\u7f16\u7801\u4e0d\u5b58\u5728;");
            } else {
                v.setCustomerName(((CustomerVo)((List)customerVoMap.get(v.getCustomerCode())).get(0)).getCustomerName());
            }
            if (StringUtils.isBlank((CharSequence)v.getYearAndMonth())) {
                sb.append("\u5e74\u6708\u4e0d\u80fd\u4e3a\u7a7a;");
            } else {
                try {
                    Date date = simpleDateFormat.parse(v.getYearAndMonth().replace("/", "-"));
                    v.setYearAndMonth(simpleDateFormat.format(date));
                }
                catch (Exception e2) {
                    sb.append("\u5e74\u6708\u683c\u5f0f\u9519\u8bef\u3010yyyy-MM\u3011\u6216\u4e0d\u5408\u6cd5;");
                }
            }
            if (StringUtils.isBlank((CharSequence)v.getKpiGradeStr())) {
                sb.append("KPI\u6210\u7ee9\u4e0d\u80fd\u4e3a\u7a7a;");
            } else {
                try {
                    v.setKpiGrade(new BigDecimal(v.getKpiGradeStr()));
                }
                catch (Exception e3) {
                    sb.append("KPI\u6210\u7ee9\u4e0d\u662f\u7eaf\u6570\u5b57;");
                }
            }
            v.setCustomerServiceAmount(new BigDecimal(v.getNumber()).multiply(v.getCustomerServicePrice()));
            v.setKpiDeduction(BigDecimal.ZERO);
            v.setKpiReward(BigDecimal.ZERO);
            if (sb.length() == 0) {
                if (!dict.containsKey(KFFYJSPD) || dict.containsKey(KFFYJSPD) && ((List)dict.get(KFFYJSPD)).stream().noneMatch(e -> e.getDictCode().equals(v.getCostCenterCode()))) {
                    if (v.getKpiGrade().compareTo(new BigDecimal(95)) >= 0) {
                        v.setKpiDeduction(BigDecimal.ZERO);
                    } else {
                        v.setKpiDeduction(new BigDecimal(95).subtract(v.getKpiGrade()).divide(new BigDecimal(100)).multiply(v.getCustomerServiceAmount()));
                    }
                } else if (v.getKpiGrade().compareTo(new BigDecimal(95)) >= 0) {
                    v.setKpiDeduction(BigDecimal.ZERO);
                } else if (v.getKpiGrade().compareTo(new BigDecimal(95)) < 0 && v.getKpiGrade().compareTo(new BigDecimal(90)) >= 0) {
                    v.setKpiDeduction(v.getCustomerServiceAmount().multiply(new BigDecimal(0.05)));
                } else if (v.getKpiGrade().compareTo(new BigDecimal(90)) < 0 && v.getKpiGrade().compareTo(new BigDecimal(80)) >= 0) {
                    v.setKpiDeduction(v.getCustomerServiceAmount().multiply(new BigDecimal(0.1)));
                } else {
                    v.setKpiDeduction(v.getCustomerServiceAmount().multiply(new BigDecimal(0.2)));
                }
                if (!dict.containsKey(KFFYJSPD) || dict.containsKey(KFFYJSPD) && ((List)dict.get(KFFYJSPD)).stream().noneMatch(e -> e.getDictCode().equals(v.getCostCenterCode()))) {
                    if (v.getKpiGrade().compareTo(new BigDecimal(100)) <= 0) {
                        v.setKpiReward(BigDecimal.ZERO);
                    } else {
                        v.setKpiReward(v.getKpiGrade().subtract(new BigDecimal(100)).divide(new BigDecimal(100)).multiply(v.getCustomerServiceAmount()));
                    }
                } else if (v.getKpiGrade().compareTo(new BigDecimal(100)) < 0) {
                    v.setKpiReward(BigDecimal.ZERO);
                } else if (v.getKpiGrade().compareTo(new BigDecimal(110)) < 0 && v.getKpiGrade().compareTo(new BigDecimal(100)) >= 0) {
                    v.setKpiReward(v.getCustomerServiceAmount().multiply(new BigDecimal(0.05)));
                } else {
                    v.setKpiReward(v.getCustomerServiceAmount().multiply(new BigDecimal(0.1)));
                }
            }
            if (StringUtils.isBlank((CharSequence)v.getMonthManualDeductionStr())) {
                v.setMonthManualDeduction(BigDecimal.ZERO);
            } else {
                try {
                    v.setMonthManualDeduction(new BigDecimal(v.getMonthManualDeductionStr()));
                }
                catch (Exception e4) {
                    sb.append("\u6708\u5ea6\u624b\u52a8\u6263\u6b3e\u4e0d\u662f\u7eaf\u6570\u5b57;");
                }
            }
            v.setMonthDeduction(v.getKpiDeduction().add(v.getMonthManualDeduction()));
            if (StringUtils.isBlank((CharSequence)v.getMonthManualRewardStr())) {
                v.setMonthManualReward(BigDecimal.ZERO);
            } else {
                try {
                    v.setMonthManualReward(new BigDecimal(v.getMonthManualRewardStr()));
                }
                catch (Exception e5) {
                    sb.append("\u6708\u5ea6\u624b\u52a8\u5956\u52b1\u4e0d\u662f\u7eaf\u6570\u5b57;");
                }
            }
            v.setMonthReward(v.getKpiReward().add(v.getMonthManualReward()));
            if (StringUtils.isBlank((CharSequence)v.getOvertimeHourStr())) {
                v.setOvertimeHour(BigDecimal.ZERO);
            } else {
                try {
                    v.setOvertimeHour(new BigDecimal(v.getOvertimeHourStr()));
                }
                catch (Exception e6) {
                    sb.append("\u52a0\u73ed\u65f6\u957f\u4e0d\u662f\u7eaf\u6570\u5b57;");
                }
            }
            if (StringUtils.isBlank((CharSequence)v.getConsumerAfterServiceAmountStr())) {
                v.setConsumerAfterServiceAmount(BigDecimal.ZERO);
            } else {
                try {
                    v.setConsumerAfterServiceAmount(new BigDecimal(v.getConsumerAfterServiceAmountStr()));
                }
                catch (Exception e7) {
                    sb.append("\u6d88\u8d39\u8005\u552e\u540e\u8d39\u7528\u4e0d\u662f\u7eaf\u6570\u5b57;");
                }
            }
            v.setCustomerServiceOvertimeAmount(((BigDecimal)ObjectUtils.defaultIfNull((Object)v.getOvertimeAmount(), (Object)BigDecimal.ZERO)).multiply((BigDecimal)ObjectUtils.defaultIfNull((Object)v.getOvertimeHour(), (Object)BigDecimal.ZERO)));
            v.setRealAmount(((BigDecimal)ObjectUtils.defaultIfNull((Object)v.getCustomerServiceAmount(), (Object)BigDecimal.ZERO)).subtract((BigDecimal)ObjectUtils.defaultIfNull((Object)v.getMonthDeduction(), (Object)BigDecimal.ZERO)).add((BigDecimal)ObjectUtils.defaultIfNull((Object)v.getMonthManualReward(), (Object)BigDecimal.ZERO)).add((BigDecimal)ObjectUtils.defaultIfNull((Object)v.getConsumerAfterServiceAmount(), (Object)BigDecimal.ZERO)).add((BigDecimal)ObjectUtils.defaultIfNull((Object)v.getCustomerServiceOvertimeAmount(), (Object)BigDecimal.ZERO)));
            StringBuffer itemKey = new StringBuffer();
            itemKey.append(v.getBusinessFormatCode());
            itemKey.append(v.getChannelCode());
            itemKey.append(v.getSalesInstitutionCode());
            itemKey.append(v.getCostCenterCode());
            itemKey.append(v.getYearAndMonth());
            if (itemKeyMap.containsKey(itemKey.toString())) {
                sb.append("\u4e0e[" + itemKeyMap.get(itemKey.toString()) + "]\u884c\u6570\u636e\u91cd\u590d;");
            } else {
                itemKeyMap.put(itemKey.toString(), k);
            }
            v.setItemKey(itemKey.toString());
            if (sb.length() > 0) {
                if (error.containsKey(k)) {
                    error.put((Integer)k, (String)error.get(k) + sb.toString());
                } else {
                    error.put((Integer)k, sb.toString());
                }
            }
        });
        if (MapUtils.isEmpty(error) && CollectionUtils.isNotEmpty(vos = this.customerServiceFeeService.findByItemKeys(itemKeys = data.values().stream().map(v -> {
            StringBuffer itemKey = new StringBuffer();
            itemKey.append(v.getBusinessFormatCode());
            itemKey.append(v.getChannelCode());
            itemKey.append(v.getSalesInstitutionCode());
            itemKey.append(v.getCostCenterCode());
            itemKey.append(v.getYearAndMonth());
            return itemKey.toString();
        }).collect(Collectors.toList())))) {
            Map toMap = vos.stream().collect(Collectors.toMap(e -> StringUtils.join((Object[])new String[]{e.getBusinessFormatCode(), e.getChannelCode(), e.getSalesInstitutionCode(), e.getCustomerCode(), e.getYearAndMonth()}), Function.identity(), (v1, v2) -> v1));
            data.forEach((k, v) -> {
                String key = StringUtils.join((Object[])new String[]{v.getBusinessFormatCode(), v.getChannelCode(), v.getSalesInstitutionCode(), v.getCustomerCode(), v.getYearAndMonth()});
                if (toMap.containsKey(key)) {
                    if (error.containsKey(k)) {
                        error.put((Integer)k, (String)error.get(k) + "\u91cd\u590d\u5bfc\u5165;");
                    } else {
                        error.put((Integer)k, "\u91cd\u590d\u5bfc\u5165;");
                    }
                }
            });
        }
        return (List)this.nebulaToolkitService.copyCollectionByWhiteList(data.values(), CustomerServiceFeeImportVo.class, CustomerServiceFeeVo.class, HashSet.class, ArrayList.class, new String[0]);
    }

    private String dictFilter(Map<String, List<DictDataVo>> dict, String costCenterCode, String dictTypeCode, String error, StringBuffer sb) {
        if (dict.containsKey(dictTypeCode)) {
            Optional<DictDataVo> optional = dict.get(dictTypeCode).stream().filter(e -> e.getDictCode().equals(costCenterCode)).findFirst();
            if (optional.isPresent()) {
                return optional.get().getDictValue();
            }
            sb.append(error);
        } else {
            sb.append("\u6570\u636e\u5b57\u5178[" + dictTypeCode + "]\u672a\u7ef4\u62a4;");
        }
        return null;
    }

    private void queryMasterData(Collection<CustomerServiceFeeImportVo> values, Map<String, List<CustomerVo>> customerVoMap, Map<String, List<CustomerChannelVo>> customerChannelMap, Map<String, CostCenterVo> costCenterMap) {
        List costCenterVos;
        List customerCodes = values.stream().map(CustomerServiceFeeImportVo::getCustomerCode).collect(Collectors.toList());
        List channelCodes = values.stream().map(CustomerServiceFeeImportVo::getChannelCode).filter(StringUtils::isNotBlank).collect(Collectors.toList());
        List costCenterCodes = values.stream().map(CustomerServiceFeeImportVo::getCostCenterCode).filter(StringUtils::isNotBlank).collect(Collectors.toList());
        List byCodes = this.customerChannelVoService.findByCodes(channelCodes);
        if (CollectionUtils.isNotEmpty((Collection)byCodes)) {
            Map<String, List<CustomerChannelVo>> map = byCodes.stream().collect(Collectors.groupingBy(CustomerChannelVo::getCustomerChannelCode));
            customerChannelMap.putAll(map);
        }
        if (CollectionUtils.isNotEmpty((Collection)(costCenterVos = this.costCenterVoService.findByCodes(costCenterCodes, YesOrNoEnum.YES.getCode())))) {
            costCenterMap.putAll(costCenterVos.stream().collect(Collectors.toMap(CostCenterVo::getCostCenterCode, Function.identity(), (v1, v2) -> v1)));
        }
    }

    public Class<CustomerServiceFeeImportVo> findCrmExcelVoClass() {
        return CustomerServiceFeeImportVo.class;
    }

    public String getBusinessCode() {
        return "TPM_CUSTOMER_SERVICE_FEE_IMPORT";
    }

    public String getBusinessName() {
        return "TPM\u5206\u9500\u5ba2\u670d\u8d39\u7528\u5bfc\u5165";
    }

    public String getTemplateCode() {
        return "TPM_CUSTOMER_SERVICE_FEE_IMPORT";
    }

    public String getTemplateName() {
        return "TPM-\u5206\u9500\u5ba2\u670d\u8d39\u7528\u5bfc\u5165";
    }
}

