/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.tpm.business.customer.launch.costs.local.service.internal;

import com.biz.crm.tpm.business.customer.launch.costs.local.service.CustomerServiceFeeService;
import com.biz.crm.tpm.business.customer.launch.costs.sdk.dto.CustomerServiceFeeDto;
import com.biz.crm.tpm.business.variable.sdk.dto.CalculateDto;
import com.biz.crm.tpm.business.variable.sdk.enums.VariableFunctionEnum;
import com.biz.crm.tpm.business.variable.sdk.register.FormulaVariableRegister;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class CustomerServiceFeeFormulaVariableRegister
implements FormulaVariableRegister {
    @Autowired(required=false)
    private CustomerServiceFeeService customerServiceFeeService;

    public String getVariableCode() {
        return "customerServiceFee";
    }

    public String getVariableName() {
        return "\u5ba2\u670d\u8d39\u7528";
    }

    public Integer getSort() {
        return 1;
    }

    public List<VariableFunctionEnum> getFunctionEnumList() {
        ArrayList list = Lists.newArrayList();
        list.add(VariableFunctionEnum.AUDIT);
        return list;
    }

    public Map<String, BigDecimal> calculateVariable(CalculateDto calculateDto) {
        Validate.notBlank((CharSequence)calculateDto.getCustomerErpCode(), (String)"\u5ba2\u6237MDG\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)calculateDto.getYearMonthLy(), (String)"\u5e74\u6708\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)calculateDto.getChannel(), (String)"\u6e20\u9053\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)calculateDto.getBusinessFormatCode(), (String)"\u4e1a\u6001\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)calculateDto.getSalesOrganizationErpCode(), (String)"\u9500\u552e\u673a\u6784\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        CustomerServiceFeeDto dto = new CustomerServiceFeeDto();
        dto.setCustomerCode(calculateDto.getCustomerErpCode());
        dto.setYearAndMonth(calculateDto.getYearMonthLy());
        dto.setBusinessFormatCode(calculateDto.getBusinessFormatCode());
        dto.setChannelCode(calculateDto.getChannel());
        dto.setSalesInstitutionCode(calculateDto.getSalesOrganizationErpCode());
        BigDecimal total = this.customerServiceFeeService.findForFormulaVariable(dto);
        HashMap resultMap = Maps.newHashMap();
        resultMap.put(this.getVariableCode(), Objects.nonNull(total) ? total : BigDecimal.ZERO);
        return resultMap;
    }
}

