/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.tpm.business.customer.launch.costs.local.service.internal;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.business.common.sdk.enums.DelFlagStatusEnum;
import com.biz.crm.mdm.business.customer.sdk.service.CustomerVoService;
import com.biz.crm.mdm.business.customer.sdk.vo.CustomerVo;
import com.biz.crm.mn.common.base.util.DateUtil;
import com.biz.crm.tpm.business.customer.launch.costs.local.entity.TpmCustomerLaunchCosts;
import com.biz.crm.tpm.business.customer.launch.costs.local.repository.TpmCustomerLaunchCostsRepository;
import com.biz.crm.tpm.business.customer.launch.costs.sdk.dto.TpmCustomerLaunchCostsDto;
import com.biz.crm.tpm.business.customer.launch.costs.sdk.dto.log.CustomerLaunchCostsLogEventDto;
import com.biz.crm.tpm.business.customer.launch.costs.sdk.event.log.CustomerLaunchCostsEventListener;
import com.biz.crm.tpm.business.customer.launch.costs.sdk.service.TpmCustomerLaunchCostsService;
import com.biz.crm.tpm.business.customer.launch.costs.sdk.vo.TpmCustomerLaunchCostsVo;
import com.biz.crm.tpm.business.distrib.close.policy.sdk.dto.TpmDistribClosePolicyDto;
import com.biz.crm.tpm.business.distrib.close.policy.sdk.service.TpmDistribClosePolicyService;
import com.biz.crm.tpm.business.distrib.close.policy.sdk.vo.TpmDistribClosePolicyVo;
import com.biz.crm.tpm.business.distribution.customer.month.sale.sdk.dto.TpmDistributionCustomerMonthSaleDto;
import com.biz.crm.tpm.business.distribution.customer.month.sale.sdk.service.TpmDistributionCustomerMonthSaleService;
import com.biz.crm.tpm.business.distribution.customer.month.sale.sdk.vo.TpmDistributionCustomerMonthSaleRespVo;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import com.bizunited.nebula.event.sdk.function.SerializableBiConsumer;
import com.bizunited.nebula.event.sdk.service.NebulaEventDto;
import com.bizunited.nebula.event.sdk.service.NebulaNetEventClient;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.TreeSet;
import java.util.UUID;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.compress.utils.Lists;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service(value="tpmCustomerLaunchCostsService")
public class TpmCustomerLaunchCostsServiceImpl
implements TpmCustomerLaunchCostsService {
    private static final Logger log = LoggerFactory.getLogger(TpmCustomerLaunchCostsServiceImpl.class);
    @Autowired(required=false)
    private TpmCustomerLaunchCostsRepository tpmCustomerLaunchCostsRepository;
    @Autowired(required=false)
    private NebulaToolkitService nebulaToolkitService;
    @Autowired(required=false)
    private NebulaNetEventClient nebulaNetEventClient;
    @Autowired(required=false)
    private TpmDistributionCustomerMonthSaleService distributionCustomerMonthSaleService;
    @Autowired(required=false)
    private TpmDistribClosePolicyService tpmDistribClosePolicyService;
    @Autowired(required=false)
    private CustomerVoService customerVoService;

    public TpmCustomerLaunchCostsVo findById(String id) {
        if (StringUtils.isBlank((CharSequence)id)) {
            return null;
        }
        TpmCustomerLaunchCosts activityContractConfig = (TpmCustomerLaunchCosts)((Object)this.tpmCustomerLaunchCostsRepository.getById((Serializable)((Object)id)));
        if (ObjectUtils.isEmpty((Object)((Object)activityContractConfig))) {
            return null;
        }
        return (TpmCustomerLaunchCostsVo)this.nebulaToolkitService.copyObjectByWhiteList((Object)activityContractConfig, TpmCustomerLaunchCostsVo.class, LinkedHashSet.class, ArrayList.class, new String[0]);
    }

    @Transactional(rollbackFor={Exception.class})
    public void delete(List<String> idList) {
        Validate.isTrue((!CollectionUtils.isEmpty(idList) ? 1 : 0) != 0, (String)"\u5220\u9664\u6570\u636e\u65f6\uff0c\u4e3b\u952e\u96c6\u5408\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        List customerLaunchCosts = this.tpmCustomerLaunchCostsRepository.listByIds(idList);
        Validate.isTrue((!CollectionUtils.isEmpty((Collection)customerLaunchCosts) ? 1 : 0) != 0, (String)"\u8981\u5220\u9664\u7684\u6570\u636e\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        this.tpmCustomerLaunchCostsRepository.removeByIds(idList);
        customerLaunchCosts.forEach(item -> {
            CustomerLaunchCostsLogEventDto logEventDto = new CustomerLaunchCostsLogEventDto();
            TpmCustomerLaunchCostsVo oldVo = (TpmCustomerLaunchCostsVo)this.nebulaToolkitService.copyObjectByWhiteList((Object)item, TpmCustomerLaunchCostsVo.class, LinkedHashSet.class, ArrayList.class, new String[0]);
            logEventDto.setOriginal(oldVo);
            logEventDto.setNewest(null);
            SerializableBiConsumer & Serializable onDelete = CustomerLaunchCostsEventListener::onDelete;
            this.nebulaNetEventClient.publish((NebulaEventDto)logEventDto, CustomerLaunchCostsEventListener.class, (SerializableBiConsumer)onDelete);
        });
    }

    @Transactional(rollbackFor={Exception.class})
    public void createSalesData(TpmCustomerLaunchCostsDto dto) {
        List monthSaleRespVos;
        this.createValidate(dto);
        String distributionCustomerMonthSaleYearMonth = dto.getDistributionCustomerMonthSaleYearMonth();
        List distributionCustomerMonthSaleRespVos = this.distributionCustomerMonthSaleService.findAllByYearMonth(distributionCustomerMonthSaleYearMonth);
        if (CollectionUtils.isNotEmpty((Collection)distributionCustomerMonthSaleRespVos) && CollectionUtils.isNotEmpty((Collection)(monthSaleRespVos = (List)distributionCustomerMonthSaleRespVos.stream().filter(a -> StringUtils.isNotBlank((CharSequence)a.getCustomerCode())).collect(Collectors.collectingAndThen(Collectors.toCollection(() -> new TreeSet<TpmDistributionCustomerMonthSaleRespVo>(Comparator.comparing(TpmDistributionCustomerMonthSaleRespVo::getCustomerCode))), ArrayList::new))))) {
            HashMap<String, List<CustomerVo>> customerVoMap = new HashMap<String, List<CustomerVo>>();
            List customerCodeList = monthSaleRespVos.stream().map(a -> a.getCustomerCode() + "11712011").collect(Collectors.toList());
            List baseByCustomerCodes = this.customerVoService.findBaseByCustomerCodes(customerCodeList);
            if (CollectionUtils.isNotEmpty((Collection)baseByCustomerCodes)) {
                Map<String, List<CustomerVo>> map = baseByCustomerCodes.stream().collect(Collectors.groupingBy(CustomerVo::getErpCode));
                customerVoMap.putAll(map);
            }
            List customerLaunchCostsDtos = (List)this.nebulaToolkitService.copyCollectionByWhiteList((Iterable)monthSaleRespVos, TpmDistributionCustomerMonthSaleRespVo.class, TpmCustomerLaunchCostsDto.class, LinkedHashSet.class, ArrayList.class, new String[0]);
            customerLaunchCostsDtos.forEach(a -> {
                List levelList;
                List customerVos;
                a.setId(UUID.randomUUID().toString().replace("-", ""));
                a.setVerifyCode(a.getCustomerCode().concat(a.getDistributionCustomerMonthSaleYearMonth()));
                a.setCustomerAmountProvided(BigDecimal.ZERO);
                if (StringUtils.isBlank((CharSequence)a.getCustomerLevel()) && CollectionUtils.isNotEmpty((Collection)(customerVos = (List)customerVoMap.get(a.getCustomerCode()))) && CollectionUtils.isNotEmpty(levelList = customerVos.stream().map(CustomerVo::getEstoreCustomerLevel).filter(StringUtils::isNotBlank).collect(Collectors.toList()))) {
                    a.setCustomerLevel((String)levelList.get(0));
                }
            });
            this.tpmCustomerLaunchCostsRepository.saveOrUpdateBatchData(customerLaunchCostsDtos);
            this.creatLog(customerLaunchCostsDtos);
        }
    }

    public Page<TpmCustomerLaunchCostsVo> findByConditions(Pageable pageable, TpmCustomerLaunchCostsDto dto) {
        pageable = (Pageable)ObjectUtils.defaultIfNull((Object)pageable, (Object)PageRequest.of((int)0, (int)50));
        if (Objects.isNull(dto)) {
            dto = new TpmCustomerLaunchCostsDto();
        }
        return this.tpmCustomerLaunchCostsRepository.findByConditions(pageable, dto);
    }

    @Transactional(rollbackFor={Exception.class})
    public void updateCostPlacement(TpmCustomerLaunchCostsDto dto) {
        this.createValidate(dto);
        String distributionCustomerMonthSaleYearMonth = dto.getDistributionCustomerMonthSaleYearMonth();
        List<TpmCustomerLaunchCostsDto> customerLaunchCostsDtos = this.tpmCustomerLaunchCostsRepository.findAllByYearMonth(distributionCustomerMonthSaleYearMonth);
        this.costCalculation(customerLaunchCostsDtos);
        this.tpmCustomerLaunchCostsRepository.saveOrUpdateBatchData(customerLaunchCostsDtos);
    }

    private void costCalculation(List<TpmCustomerLaunchCostsDto> customerLaunchCostsDtos) {
        if (CollectionUtils.isNotEmpty(customerLaunchCostsDtos)) {
            log.info("\u5206\u9500\u5ba2\u6237\u6295\u653e\u8d39\u7528\u8ba1\u7b97 \u67e5\u6708\u9500\u552e\u53c2\u6570{}", (Object)customerLaunchCostsDtos.toString());
            Collection customerMonthSaleDtos = this.nebulaToolkitService.copyCollectionByWhiteList(customerLaunchCostsDtos, TpmCustomerLaunchCostsDto.class, TpmDistributionCustomerMonthSaleDto.class, LinkedHashSet.class, ArrayList.class, new String[0]);
            List distributionCustomerMonthSaleRespVos = this.distributionCustomerMonthSaleService.findByCustomer(customerMonthSaleDtos);
            if (CollectionUtils.isNotEmpty((Collection)distributionCustomerMonthSaleRespVos)) {
                log.info("\u5206\u9500\u5ba2\u6237\u6295\u653e\u8d39\u7528\u8ba1\u7b97 \u67e5\u6708\u9500\u552e\u6570\u636e\u7ed3\u679c{}", (Object)distributionCustomerMonthSaleRespVos.toString());
                Collection closePolicyDtos = this.nebulaToolkitService.copyCollectionByWhiteList((Iterable)distributionCustomerMonthSaleRespVos, TpmDistributionCustomerMonthSaleRespVo.class, TpmDistribClosePolicyDto.class, LinkedHashSet.class, ArrayList.class, new String[0]);
                closePolicyDtos.forEach(c -> c.setSalesInstitutionCode(c.getChannelCode() + c.getBusinessFormatCode() + c.getSalesInstitutionCode()));
                log.info("\u5206\u9500\u5ba2\u6237\u6295\u653e\u8d39\u7528\u8ba1\u7b97 \u67e5\u7ed3\u6848\u653f\u7b56\u53c2\u6570{}", (Object)customerLaunchCostsDtos.toString());
                List closePolicyVos = this.tpmDistribClosePolicyService.findCostOfPlacement(closePolicyDtos);
                if (CollectionUtils.isNotEmpty((Collection)closePolicyVos)) {
                    log.info("\u5206\u9500\u5ba2\u6237\u6295\u653e\u8d39\u7528\u8ba1\u7b97 \u67e5\u7ed3\u6848\u653f\u7b56\u7ed3\u679c{}", (Object)closePolicyVos.toString());
                    Map<String, List<TpmDistributionCustomerMonthSaleRespVo>> customerMonthSaleMap = distributionCustomerMonthSaleRespVos.stream().collect(Collectors.groupingBy(a -> a.getCustomerCode().concat(a.getDistributionCustomerMonthSaleYearMonth())));
                    Map<String, List<TpmDistribClosePolicyVo>> closeMap = closePolicyVos.stream().collect(Collectors.groupingBy(a -> a.getEstoreCustomerLevel() + a.getProductCode() + a.getStartDate().substring(0, 7)));
                    Map<String, List<TpmDistribClosePolicyVo>> closeOneMap = closePolicyVos.stream().collect(Collectors.groupingBy(a -> a.getCustomerCode() + a.getProductCode() + a.getSalesInstitutionCode() + a.getStartDate().substring(0, 7)));
                    if (Objects.nonNull(customerMonthSaleMap)) {
                        for (TpmCustomerLaunchCostsDto costsDto : customerLaunchCostsDtos) {
                            Map<String, List<TpmDistributionCustomerMonthSaleRespVo>> saleMap;
                            BigDecimal countAmount = BigDecimal.ZERO;
                            String verifyCode = costsDto.getVerifyCode();
                            List<TpmDistributionCustomerMonthSaleRespVo> customerMonthSaleRespVoList = customerMonthSaleMap.get(verifyCode);
                            if (CollectionUtils.isNotEmpty(customerMonthSaleRespVoList) && Objects.nonNull(saleMap = customerMonthSaleRespVoList.stream().collect(Collectors.groupingBy(a -> a.getCustomerCode() + a.getProductCode() + a.getDistributionCustomerMonthSaleYearMonth()))) && Objects.nonNull(closeMap) && Objects.nonNull(closeOneMap)) {
                                Set<Map.Entry<String, List<TpmDistributionCustomerMonthSaleRespVo>>> entries = saleMap.entrySet();
                                for (Map.Entry<String, List<TpmDistributionCustomerMonthSaleRespVo>> entry : entries) {
                                    List<TpmDistributionCustomerMonthSaleRespVo> value = entry.getValue();
                                    if (!CollectionUtils.isNotEmpty(value)) continue;
                                    TpmDistributionCustomerMonthSaleRespVo saleRespVo = value.get(0);
                                    BigDecimal amount = saleRespVo.getCountAmount();
                                    String s = saleRespVo.getCustomerCode() + saleRespVo.getProductCode() + saleRespVo.getChannelCode() + saleRespVo.getBusinessFormatCode() + saleRespVo.getSalesInstitutionCode() + saleRespVo.getDistributionCustomerMonthSaleYearMonth();
                                    List<TpmDistribClosePolicyVo> policyVos = closeOneMap.get(s);
                                    if (CollectionUtils.isNotEmpty(policyVos)) {
                                        BigDecimal costOfPlacement = policyVos.get(0).getCostOfPlacement();
                                        if (Objects.isNull(costOfPlacement)) {
                                            countAmount = this.getCostOfPlacement(closeMap, countAmount, saleRespVo, amount);
                                            continue;
                                        }
                                        countAmount = countAmount.add(Optional.ofNullable(amount).orElse(BigDecimal.ZERO).multiply(costOfPlacement).setScale(6, 4));
                                        continue;
                                    }
                                    countAmount = this.getCostOfPlacement(closeMap, countAmount, saleRespVo, amount);
                                }
                            }
                            costsDto.setMonthlyPolicyTotal(countAmount);
                            String saleYearMonth = costsDto.getDistributionCustomerMonthSaleYearMonth();
                            Date date = new Date();
                            try {
                                date = DateUtil.date_yyyy_MM.parse(saleYearMonth);
                            }
                            catch (Exception e) {
                                e.printStackTrace();
                            }
                            Calendar c2 = Calendar.getInstance();
                            c2.setTime(date);
                            c2.add(2, -1);
                            String time = DateUtil.date_yyyy_MM.format(c2.getTime());
                            String customerCode = costsDto.getCustomerCode();
                            TpmCustomerLaunchCosts launchCosts = this.tpmCustomerLaunchCostsRepository.findByVerifyCode(customerCode.concat(time));
                            BigDecimal aggregatePolicyAmount = countAmount;
                            if (Objects.nonNull((Object)launchCosts)) {
                                BigDecimal rollingAmount = launchCosts.getCumulativeRollingAmount();
                                aggregatePolicyAmount = aggregatePolicyAmount.add(Optional.ofNullable(rollingAmount).orElse(BigDecimal.ZERO));
                            }
                            costsDto.setAggregatePolicyAmount(aggregatePolicyAmount);
                            BigDecimal customerAmountProvided = Optional.ofNullable(costsDto.getCustomerAmountProvided()).orElse(BigDecimal.ZERO);
                            BigDecimal actualTotalAmount = customerAmountProvided.compareTo(aggregatePolicyAmount) < 0 ? customerAmountProvided : aggregatePolicyAmount;
                            costsDto.setActualTotalAmount(actualTotalAmount);
                            BigDecimal decimal = aggregatePolicyAmount.subtract(customerAmountProvided).setScale(6, 4);
                            costsDto.setCumulativeRollingAmount(decimal.compareTo(BigDecimal.ZERO) > 0 ? decimal : BigDecimal.ZERO);
                            if (customerAmountProvided.compareTo(BigDecimal.ZERO) != 0 || actualTotalAmount.compareTo(BigDecimal.ZERO) == 0) continue;
                            costsDto.setClosingMark("\u624b\u5de5\u7ed3\u7b97");
                        }
                    }
                }
            }
        }
    }

    private BigDecimal getCostOfPlacement(Map<String, List<TpmDistribClosePolicyVo>> closeMap, BigDecimal countAmount, TpmDistributionCustomerMonthSaleRespVo saleRespVo, BigDecimal amount) {
        BigDecimal costOfPlacementTwo;
        String s1 = saleRespVo.getCustomerLevel() + saleRespVo.getProductCode() + saleRespVo.getDistributionCustomerMonthSaleYearMonth();
        List<TpmDistribClosePolicyVo> policyVoList = closeMap.get(s1);
        if (CollectionUtils.isNotEmpty(policyVoList) && Objects.nonNull(costOfPlacementTwo = policyVoList.get(0).getCostOfPlacement())) {
            countAmount = countAmount.add(Optional.ofNullable(amount).orElse(BigDecimal.ZERO).multiply(costOfPlacementTwo).setScale(6, 4));
        }
        return countAmount;
    }

    @Transactional(rollbackFor={Exception.class})
    public void importSave(List<TpmCustomerLaunchCostsDto> importList) {
        if (CollectionUtils.isEmpty(importList)) {
            return;
        }
        String tenantCode = TenantUtils.getTenantCode();
        String code = DelFlagStatusEnum.NORMAL.getCode();
        importList.forEach(a -> {
            a.setTenantCode(tenantCode);
            a.setDelFlag(code);
            a.setId(UUID.randomUUID().toString().replace("-", ""));
        });
        this.costCalculation(importList);
        this.tpmCustomerLaunchCostsRepository.saveOrUpdateBatchData(importList);
        this.creatLog(importList);
    }

    public List<TpmCustomerLaunchCostsVo> listForVariable(TpmCustomerLaunchCostsDto dto) {
        if (Objects.isNull(dto)) {
            return Lists.newArrayList();
        }
        List<TpmCustomerLaunchCosts> list = this.tpmCustomerLaunchCostsRepository.listForVariable(dto);
        if (CollectionUtils.isEmpty(list)) {
            return Lists.newArrayList();
        }
        return (List)this.nebulaToolkitService.copyCollectionByWhiteList(list, TpmCustomerLaunchCosts.class, TpmCustomerLaunchCostsVo.class, HashSet.class, ArrayList.class, new String[0]);
    }

    private void creatLog(List<TpmCustomerLaunchCostsDto> importList) {
        importList.forEach(dto -> {
            CustomerLaunchCostsLogEventDto logEventDto = new CustomerLaunchCostsLogEventDto();
            logEventDto.setOriginal(null);
            logEventDto.setNewest(dto);
            SerializableBiConsumer & Serializable onCreate = CustomerLaunchCostsEventListener::onCreate;
            this.nebulaNetEventClient.publish((NebulaEventDto)logEventDto, CustomerLaunchCostsEventListener.class, (SerializableBiConsumer)onCreate);
        });
    }

    private void createValidate(TpmCustomerLaunchCostsDto dto) {
        Validate.notNull((Object)dto, (String)"\u8bf7\u6c42\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        String distributionCustomerMonthSaleYearMonth = dto.getDistributionCustomerMonthSaleYearMonth();
        Validate.notBlank((CharSequence)distributionCustomerMonthSaleYearMonth, (String)"\u5e74\u6708\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.isTrue((distributionCustomerMonthSaleYearMonth.length() == 7 ? 1 : 0) != 0, (String)"\u5e74\u6708\u9519\u8bef,\u4f8b\uff1a2023-01", (Object[])new Object[0]);
        DateUtil.date_yyyy_MM.setLenient(false);
        try {
            DateUtil.date_yyyy_MM.parse(distributionCustomerMonthSaleYearMonth);
        }
        catch (Exception e) {
            throw new IllegalArgumentException("\u5e74\u6708\u683c\u5f0f\u9519\u8bef\u3010yyyy-MM\u3011\u6216\u4e0d\u5408\u6cd5");
        }
    }
}

