package com.biz.crm.tpm.business.daily.sales.data.local.controller;

import com.biz.crm.business.common.sdk.model.Result;
import com.biz.crm.tpm.business.daily.sales.data.sdk.dto.TpmDailySalesDataDto;
import com.biz.crm.tpm.business.daily.sales.data.sdk.service.TpmDailySalesDataService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;


/**
 * 日销售数据(TpmDailySalesData)表相关的接口
 *
 * @author hd
 * @create 2023-02-06 15:01:38
 */
@RestController
@RequestMapping("/v1/tpmDailySalesData")
@Slf4j
@Api(tags = "TMP-日销售数据")
public class TpmDailySalesDataController {

    @Autowired(required = false)
    private TpmDailySalesDataService tpmDailySalesDataService;

    /**
     * 通过时间分区拉取数据
     *
     * @param ds 时间分区
     * @return 数据
     */
    @ApiOperation(value = "通过时间分区拉取数据")
    @PostMapping()
    public Result<?> pullDataList(@RequestParam @ApiParam(name = "ds", value = "ds(例：20230206)") String ds) {
        try {
            tpmDailySalesDataService.pullDataList(ds);
            return Result.ok();
        } catch (Exception e) {
            log.error(e.getMessage(), e);
            return Result.error(e.getMessage());
        }
    }

    /**
     * 根据条件拉取数据
     *
     * @param dto 条件对象
     * @return
     */
    @ApiOperation(value = "根据条件拉取数据")
    @PostMapping("/byCondition")
    public Result<?> pullByCondition(@RequestBody TpmDailySalesDataDto dto) {
        try {
            tpmDailySalesDataService.pullByCondition(dto);
            return Result.ok();
        } catch (Exception e) {
            log.error(e.getMessage(), e);
            return Result.error(e.getMessage());
        }
    }
}
