package com.biz.crm.tpm.business.daily.sales.data.local.mapper;

import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.biz.crm.tpm.business.daily.sales.data.local.entity.TpmDailySalesDataEntity;
import com.biz.crm.tpm.business.daily.sales.data.sdk.dto.TpmDailySalesDataDto;
import com.biz.crm.tpm.business.daily.sales.data.sdk.dto.TpmDailySalesDataTotalDto;
import com.biz.crm.tpm.business.daily.sales.data.sdk.vo.TpmDailySalesDataTotalVo;
import com.biz.crm.tpm.business.daily.sales.data.sdk.vo.TpmDailySalesDataVo;
import org.apache.ibatis.annotations.Param;

import java.util.Collection;
import java.util.List;

/**
 * 日销售数据(TpmDailySalesData)表mybatis访问层
 *
 * @author hd
 * @create 2023-02-06 15:01:38
 */
public interface TpmDailySalesDataMapper extends BaseMapper<TpmDailySalesDataEntity> {
    /**
     * 关键指标-赠品数量/金额查询
     * @param dto
     * @return
     */
    TpmDailySalesDataVo findGiftSum(@Param("dto") TpmDailySalesDataDto dto);

    /**
     * 批量存储数据
     *
     * @param saveList
     */
    void saveBatchData(@Param("saveList") Collection<TpmDailySalesDataEntity> saveList);

    /**
     * 根据条件统计 订单数量，单价*订单数量
     *
     * @param dto 参数
     * @return TpmDailySalesDataTotalVo
     */
    TpmDailySalesDataTotalVo statisticsByCondition(@Param("dto") TpmDailySalesDataTotalDto dto, @Param("tenantCode") String tenantCode);
    List<TpmDailySalesDataVo> statisticsListByCondition(@Param("dto") TpmDailySalesDataTotalDto dto, @Param("tenantCode") String tenantCode);
    List<TpmDailySalesDataVo> afterDiscountAmtByCondition(@Param("dto") TpmDailySalesDataTotalDto dto, @Param("tenantCode") String tenantCode);

    List<TpmDailySalesDataVo> findByCondition(@Param("dto") TpmDailySalesDataTotalDto dto, @Param("tenantCode") String tenantCode);
}
