package com.biz.crm.tpm.business.daily.sales.data.local.register;

import com.biz.crm.business.common.sdk.enums.DelFlagStatusEnum;
import com.bizunited.nebula.europa.database.register.sdk.service.DataviewRegister;
import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Component;

/**
 * @author hd
 */
@Component
@Slf4j
public class TpmSapDaySalesRegister implements DataviewRegister {
    @Override
    public String code() {
        return "tpm_sap_day_sales_data_view";
    }

    @Override
    public String desc() {
        return "TPM-分子公司日销售报表";
    }

    @Override
    public String buildSql() {
        return "select t.* from tpm_sap_day_sales t " +
                "where t.tenant_code = :tenantCode " +
                "and t.del_flag = '"+ DelFlagStatusEnum.NORMAL.getCode()+"'";
    }
}
