package com.biz.crm.tpm.business.daily.sales.data.local.service.internal;

import com.biz.crm.tpm.business.daily.sales.data.local.entity.TpmSapDaySalesEntity;
import com.biz.crm.tpm.business.daily.sales.data.local.repository.TpmSapDaySalesRepository;
import com.biz.crm.tpm.business.daily.sales.data.local.service.TpmSapDaySalesTransService;
import org.apache.commons.collections4.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;

import java.util.Collection;

/**
 * 批量处理数据
 *
 * @author hd
 */
@Service("tpmSapDaySalesTransService")
public class TpmSapDaySalesTransServiceImpl implements TpmSapDaySalesTransService {
    @Autowired(required = false)
    private TpmSapDaySalesRepository tpmSapDaySalesRepository;

    /**
     * 批量保存日销售数据
     *
     * @param sapEntities
     */
    @Override
    @Transactional(propagation = Propagation.NOT_SUPPORTED, rollbackFor = Exception.class)
    public void saveBatchData(Collection<TpmSapDaySalesEntity> sapEntities) {
        if (CollectionUtils.isEmpty(sapEntities) || sapEntities.size() == 0) {
            return;
        }
        tpmSapDaySalesRepository.saveBatchData(sapEntities);
    }
}
