package com.biz.crm.tpm.business.daily.sales.data.sdk.dto;

import com.biz.crm.business.common.sdk.dto.TenantFlagOpDto;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;

import java.util.List;

/**
 * @author hd
 * @create 2023-02-06 15:01:38
 */
@Data
@EqualsAndHashCode(callSuper = true)
@ApiModel(value = "TpmDailySalesDataDto", description = "日销售数据dto")
public class TpmDailySalesDataDto extends TenantFlagOpDto {

    @ApiModelProperty("销售机构编码")
    private String salesInstitutionCode;

    @ApiModelProperty("所属销售机构")
    private String salesInstitutionName;
    /**
     * 客户编码编码
     */
    @ApiModelProperty("客户编码编码")
    private String customerCode;

    /**
     * 开始时间
     */
    @ApiModelProperty("开始时间")
    private String startTimeStr;

    /**
     * 结束时间
     */
    @ApiModelProperty("结束时间")
    private String endTimeStr;

    /**
     * 物料编码
     */
    @ApiModelProperty("物料编码")
    private String materialCode;
    private List<String> materialCodeList;

    @ApiModelProperty("销售大区ERP编码")
    private String saleOfficeCode;

    @ApiModelProperty("销售大区编码")
    private String tpmSalesOrgCode;

    @ApiModelProperty("销售大区名称")
    private String saleOfficeName;

    @ApiModelProperty("销售组ERP代码")
    private String salesCode;

    @ApiModelProperty("销售组编码")
    private String salesGroupCode;

    @ApiModelProperty("销售组名称")
    private String salesGroupName;

    @ApiModelProperty("时间分区 yyyyMMdd")
    private String ds;

    @ApiModelProperty("时间分区 集合")
    private List<String> dsList;

    @ApiModelProperty("年月")
    private String yearMonthLy;


}