package com.biz.crm.tpm.business.daily.sales.data.sdk.dto;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.util.List;

/**
 * @author chenlong
 * @create 2023-02-06 15:01:38
 */
@Data
@ApiModel(value = "TpmDailySalesDataTotalDto", description = "日销售数据统计dto")
public class TpmDailySalesDataTotalDto {

    /**
     * 年月
     */
    @ApiModelProperty(value = "年月", notes = "")
    private String yearMonthLy;

    /**
     * 开始年月
     */
    @ApiModelProperty("开始年月")
    private String yearMonthBegin;

    /**
     * 结束年月
     */
    @ApiModelProperty("结束年月")
    private String yearMonthEnd;

    /**
     * 业态[数据字典:mdm_business_format]
     */
    @ApiModelProperty(value = "业态[数据字典:mdm_business_format]", notes = "")
    private String businessFormatCode;

    /**
     * 业务单元
     */
    @ApiModelProperty(value = "业务单元", notes = "")
    private String businessUnitCode;

    @ApiModelProperty("销售机构编码")
    private String salesInstitutionCode;

    /**
     * 非包含客户编码
     */
    private List<String> excludeCustomerCodeList;

    /**
     * 非包含终端编码
     */
    private List<String> excludeTerminalCodeList;

    /**
     * 非包含产品编码
     */
    private List<String> excludeProductCodeList;

    /**
     * 销售组织编码(大区)
     */
    @ApiModelProperty("销售组织编码(大区)")
    private List<String> salesOrgRegionCodeList;

    /**
     * 年月
     */
    @ApiModelProperty("年月")
    private List<String> yearMonthLyList;

    @ApiModelProperty("品牌描述")
    private String brand;

    /**
     * 客户编码（列表）
     */
    @ApiModelProperty(value = "客户编码（列表）", notes = "")
    private List<String> customerCodeList;
    private List<String> soldPartyCodeList;//售达方编码
    private List<String> serviceCodeList;//送达方编码

    /**
     * 包含销售产品
     */
    private List<String> salesProductCodeList;

}