package com.biz.crm.tpm.business.daily.sales.data.sdk.dto;

import com.biz.crm.business.common.sdk.dto.TenantFlagOpDto;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;

import java.math.BigDecimal;
import java.util.List;

/**
 * @Description: 分子日销售数据
 * @Author: dengwei
 * @Date: 2023/2/24 19:33
 * @Version: 1.0
 */
@Data
@EqualsAndHashCode(callSuper = true)
@ApiModel(value = "TpmSapDaySalesDto", description = "分子日销售数据")
public class TpmSapDaySalesDto extends TenantFlagOpDto {

    @ApiModelProperty(value = "年月", notes = "")
    private String yearMonthLy;

    @ApiModelProperty("业态")
    private String spartCode;

    /**
     * 销售机构编码
     */
    @ApiModelProperty("销售机构编码")
    private String salesOrgCode;

    /**
     * 销售机构名称
     */
    @ApiModelProperty("销售机构名称")
    private String salesOrg;
    /**
     * 分销渠道编码
     */
    @ApiModelProperty("分销渠道编码")
    private String channelCode;
    /**
     * 分销渠道名称
     */
    @ApiModelProperty("分销渠道名称")
    private String channelName;

    /**
     * 售达方编码
     */
    @ApiModelProperty("售达方编码")
    private String dealerCode;
    private List<String> dealerCodes;

    /**
     * 售达方名称
     */
    @ApiModelProperty("售达方名称")
    private String dealerName;

    /**
     * 送达方编码
     */
    @ApiModelProperty("送达方编码")
    private String serviceCode;
    private List<String> serviceCodes;
    /**
     * 送达方名称
     */
    @ApiModelProperty("送达方名称")
    private String serviceName;
    /**
     * 品牌
     */
    @ApiModelProperty(name = "品牌编码")
    private String brand;
    private List<String> brandList;
    /**
     * 品牌名称
     */
    @ApiModelProperty(name = "品牌名称")
    private String brandTxt;
    /**
     * 品类
     */
    @ApiModelProperty(name = "品类编码")
    private String categoryCode;
    private List<String> categoryCodeList;
    /**
     * 品类名称
     */
    @ApiModelProperty(name = "品类名称")
    private String category;
    /**
     * 品项
     */
    @ApiModelProperty(name = "品项编码")
    private String itemCode;
    private List<String> itemCodes;
    /**
     * 品项名称
     */
    @ApiModelProperty(name = "品项名称")
    private String item;
    /**
     * 物料编码
     * (产品编码(37码))
     */
    @ApiModelProperty("产品编码")
    private String materialCode;

    private List<String> productCodes;

    /**
     * 物料描述
     * (产品名称)
     */
    @ApiModelProperty("产品名称")
    private String materialName;

    /**
     * 标准供货价
     */
    @ApiModelProperty("标准供货价")
    private BigDecimal orderRebateRegularPrice;
    /**
     * 订单类型
     */
    @ApiModelProperty("订单类型")
    private String saleVouType;

    /**
     * 发货过账日期
     */
    @ApiModelProperty("发货过账日期")
    private String shippingAccountDate;

    /**
     * 交货单数量
     */
    @ApiModelProperty("交货单数量")
    private Integer deliveryOrderNum;
    /**
     * 基本单位
     */
    @ApiModelProperty("基本单位")
    private String basicUnit;

    /**
     * 理论收入(折前含税)
     */
    @ApiModelProperty("理论收入(折前含税)")
    private BigDecimal incomeTaxIncluded;

    /**
     * 税率
     */
    @ApiModelProperty("税率")
    private BigDecimal taxRate;

    /**
     * 理论收入(折前未税)
     */
    @ApiModelProperty("理论收入(折前未税)")
    private BigDecimal incomeUntaxed;

    /**
     * 到岸价
     */
    @ApiModelProperty("到岸价")
    private BigDecimal costAndFreight;
    /**
     * 理论成本(折前含税)
     */
    @ApiModelProperty("理论成本(折前含税)")
    private BigDecimal costTaxIncluded;

    /**
     * 实际收入(折后含税)
     */
    @ApiModelProperty("实际收入(折后含税)")
    private BigDecimal invoiceAmt;

    /**
     * 发票税金额
     */
    @ApiModelProperty("发票税金额")
    private BigDecimal invoiceTaxAmt;
    /**
     * 实际收入(折后不含税)
     */
    @ApiModelProperty("实际收入(折后不含税)")
    private BigDecimal invoiceAfterTax;
    /**
     * 交货单发出重量(毛重)
     */
    @ApiModelProperty("交货单发出重量(毛重)")
    private BigDecimal deliveryOrderWeight;
    /**
     * 重量单位
     */
    @ApiModelProperty("重量单位")
    private String weight;
    /**
     * 时间分区
     */
    @ApiModelProperty("时间分区")
    private String ds;
    /**
     * 发票状态
     */
    private String invoiceStatus;

    private String activityBeginTime;

    private String activityEndTime;


    /**
     * 组织编码
     */
    @ApiModelProperty(value = "组织编码", notes = "")
    private String orgCode;

    /**
     * 组织名称
     */
    @ApiModelProperty(value = "组织名称", notes = "")
    private String orgName;

    @ApiModelProperty("客户编码")
    private String customerCode;

    @ApiModelProperty("所属销售机构编码")
    private String salesInstitutionCode;

    @ApiModelProperty("所属销售机构编码")
    private String salesInstitutionErpCode;

    @ApiModelProperty("所属销售机构")
    private String salesInstitutionName;

    @ApiModelProperty(value = "salesRegionCode", name = "销售部门编码", notes = "销售部门编码")
    private String salesRegionCode;

    @ApiModelProperty(value = "salesRegionName", name = "销售部门名称", notes = "销售部门名称")
    private String salesRegionName;

    @ApiModelProperty(value = "salesRegionErpCode", name = "销售部门erp编码", notes = "销售部门erp编码")
    private String salesRegionErpCode;

    @ApiModelProperty(name = "销售组织编码", notes = "销售组织编码")
    private String tpmSalesOrgCode;

    @ApiModelProperty(name = "销售组织名称", notes = "销售组织名称")
    private String salesOrgName;

    @ApiModelProperty("销售组织erp编码")
    private String salesOrgErpCode;

}
