package com.biz.crm.tpm.business.daily.sales.data.sdk.service;


import com.biz.crm.tpm.business.daily.sales.data.sdk.dto.TpmDailySalesDataDto;
import com.biz.crm.tpm.business.daily.sales.data.sdk.dto.TpmDailySalesDataTotalDto;
import com.biz.crm.tpm.business.daily.sales.data.sdk.vo.TpmDailySalesDataTotalVo;
import com.biz.crm.tpm.business.daily.sales.data.sdk.vo.TpmDailySalesDataVo;

import java.util.List;

/**
 * 日销售数据(TpmDailySalesData)表服务接口
 *
 * @author hd
 * @create 2023-02-06 15:01:38
 */
public interface TpmDailySalesDataService {
    /**
     * 定时拉取
     */
    void pullDataList();

    /**
     * 手动拉取
     *
     * @param ds
     */
    void pullDataList(String ds);

    /**
     * 关键指标-赠品数量查询
     * @param tpmDailySalesDataDto
     * @return
     */
    TpmDailySalesDataVo findGift(TpmDailySalesDataDto tpmDailySalesDataDto);

    /**
     * 根据条件拉取数据
     *
     * @param dto 条件对象
     * @return
     */
    void pullByCondition(TpmDailySalesDataDto dto);

    /**
     * 根据条件统计 订单数量，单价*订单数量 只统计(订单类型为ZOR5+ZOR8)的数据
     *
     * @param dto 参数
     * @return TpmDailySalesDataTotalVo
     */
    TpmDailySalesDataTotalVo statisticsByCondition(TpmDailySalesDataTotalDto dto);
    List<TpmDailySalesDataVo> statisticsListByCondition(TpmDailySalesDataTotalDto dto);
    List<TpmDailySalesDataVo> afterDiscountAmtByCondition(TpmDailySalesDataTotalDto dto);

    /**
     * 按条件查询
     *
     * @param dto
     * @return
     */
    List<TpmDailySalesDataVo> findByCondition(TpmDailySalesDataTotalDto dto);
}
