package com.biz.crm.tpm.business.daily.sales.data.sdk.service;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.tpm.business.daily.sales.data.sdk.dto.TpmSapDaySalesDto;
import com.biz.crm.tpm.business.daily.sales.data.sdk.dto.TpmSapDaySalesExamineCircularSearchDto;
import com.biz.crm.tpm.business.daily.sales.data.sdk.vo.TpmSapDaySalesExamineCircularSearchVo;
import com.biz.crm.tpm.business.daily.sales.data.sdk.vo.TpmSapDaySalesVo;
import org.springframework.data.domain.Pageable;

import java.util.List;

/**
 * 分子公司日销售报表
 * @author hd
 */
public interface TpmSapDaySalesService {

    /**
     * 同步105数据
     * @param ds
     */
    void synchronizationSap(String ds);

    /**
     * 考核通报管理查询分摊数据
     *
     * @param dto
     * @return
     */
    List<TpmSapDaySalesExamineCircularSearchVo> findExamineCircularDataList(TpmSapDaySalesExamineCircularSearchDto dto, String cacheKey);

    /**
     * 分页查询
     * @param dto
     * @return
     */
    List<TpmSapDaySalesVo> findListByCondition(TpmSapDaySalesDto dto);

    /**
     * 查询total
     * @param dto
     * @return
     */
    long findTotalByCondition(TpmSapDaySalesDto dto);

    /**
     * 分页查询
     * @param page
     * @param dto
     * @return
     */
    Page<TpmSapDaySalesVo> findPageByCondition(Page<TpmSapDaySalesVo> page, TpmSapDaySalesDto dto);

    /**
     * 变量计算查询
     * @param dto
     * @return
     */
    List<TpmSapDaySalesVo> listForVariable(TpmSapDaySalesDto dto);

    List<TpmSapDaySalesVo> findListByCondition2(List<TpmSapDaySalesDto> tpmSapDaySalesDto);

    List<TpmSapDaySalesVo> findListForSubSaleMonitor(List<TpmSapDaySalesDto> dtos);

    List<TpmSapDaySalesVo> findListForSaleAndFeeMonitoring(List<TpmSapDaySalesDto> dtos);

    Page<TpmSapDaySalesVo> findPageItemForSonCompanyBudgetWarn(Pageable pageable, List<String> yearMonthList, String orgCode, String saleCompanyCode, String channelCode, String saleGroupCode, String customerCode, String budgetItemCode);
}
