package com.biz.crm.tpm.business.daily.sales.data.sdk.vo;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.math.BigDecimal;

/**
 * @author chenlong
 * @create 2023-02-06 15:01:38
 */
@Data
@ApiModel(value = "TpmDailySalesDataTotalVo", description = "日销售数据统计vo")
public class TpmDailySalesDataTotalVo {

    /**
     * 订单数量
     */
    @ApiModelProperty(name = "orderQuantity", value = "订单数量", notes = "订单数量")
    private BigDecimal orderQuantity;

    /**
     * 订单金额 单价*订单数量
     */
    @ApiModelProperty(name = "orderAmount", value = "订单金额", notes = "订单金额")
    private BigDecimal orderAmount;

    /**
     * 折后总金额
     */
    @ApiModelProperty(name = "afterDiscountAmt", value = "折后总金额", notes = "折后总金额")
    private BigDecimal afterDiscountAmt;
}