package com.biz.crm.tpm.business.daily.sales.data.sdk.vo;

import com.biz.crm.business.common.sdk.vo.TenantFlagOpVo;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;

import javax.persistence.Column;
import java.math.BigDecimal;

/**
 * @author hd
 * @create 2023-02-06 15:01:38
 */
@EqualsAndHashCode(callSuper = true)
@Data
@ApiModel(value = "TpmDailySalesDataVo", description = "TPM-日销售数据")
public class TpmDailySalesDataVo extends TenantFlagOpVo {

    @ApiModelProperty("客户端")
    private String client;

    @ApiModelProperty("发票号")
    private String invoiceNumber;

    @ApiModelProperty("发票行项目号")
    private String invoicingItems;

    @ApiModelProperty("售达方代码")
    private String dealerCode;

    @ApiModelProperty("售达方名称")
    private String dealerName;

    @ApiModelProperty("售达方简称")
    private String dealerShortName;

    @ApiModelProperty("送达方代码")
    private String serviceCode;

    @ApiModelProperty("送达方名称")
    private String serviceName;

    @ApiModelProperty("销售组织代码")
    private String salesOrgCode;

    @ApiModelProperty("发票类型")
    private String invoiceType;

    @ApiModelProperty("产品组代码")
    private String spartCode;

    @ApiModelProperty("分销渠道代码")
    private String channelCode;

    @ApiModelProperty("物料代码")
    private String materialCode;

    @ApiModelProperty("物料描述")
    private String material;

    @ApiModelProperty("客户ABC等级")
    private String dealerLevel;

    @ApiModelProperty("客户组代码")
    private String dealersCode;

    @ApiModelProperty("销售凭证")
    private String saleVoucher;

    @ApiModelProperty("凭证日期")
    private String voucherDate;

    @ApiModelProperty("创建日期")
    private String createdDataDate;

    @ApiModelProperty("品牌描述")
    private String brand;

    @ApiModelProperty("城市")
    private String city;

    @ApiModelProperty("发货工厂代码")
    private String shippingFactoryCode;
    @ApiModelProperty("发货工厂描述")
    private String deliveryFactory;
    @ApiModelProperty("运输方式描述")
    private String transportMode;
    @ApiModelProperty("生产工厂代码")
    private String prodFactoryCode;
    @ApiModelProperty("生产工厂名称")
    private String prodFactoryName;

    @ApiModelProperty("单价")
    private String price;

    @ApiModelProperty("固定折扣率")
    private String fixDiscountRate;

    @ApiModelProperty("折扣单价")
    private String discountPrice;

    @ApiModelProperty("浮动折扣率")
    private String floatDiscountRate;

    @ApiModelProperty("订单数量")
    private BigDecimal orderNum;
    private BigDecimal orderAmount;

    @ApiModelProperty("买/赠品率")
    private String giftRate;

    @ApiModelProperty("折扣金额")
    private BigDecimal discountAmt;

    @ApiModelProperty("折后总金额")
    private BigDecimal afterDiscountAmt;
    @ApiModelProperty("物料总净重量")
    private String materialNetWeight;

    @ApiModelProperty("销售订单总净重量")
    private BigDecimal orderNetWeight;
    @ApiModelProperty("重量单位")
    private String weight;

    @ApiModelProperty("折前总金额")
    private BigDecimal beforeDiscountAmt;
    @ApiModelProperty("货损数量")
    private BigDecimal damageNum;

    @ApiModelProperty("货损金额")
    private BigDecimal damageAmt;
    @ApiModelProperty("赠品数量")
    private BigDecimal giftNum;
    @ApiModelProperty("赠品金额")
    private BigDecimal giftAmt;
    @ApiModelProperty("税率")
    private BigDecimal taxRate;

    @ApiModelProperty("浮动搭赠比")
    private String floatMatchGiftRatio;
    @ApiModelProperty("仓储地点描述")
    private String goods;
    @ApiModelProperty("物料定价组代码")
    private String materialPriceCode;
    @ApiModelProperty("物料定价组描述")
    private String materialPrice;
    @ApiModelProperty("地区代码")
    private String areaCode;
    @ApiModelProperty("地区描述")
    private String area;
    @ApiModelProperty("创建人代码")
    private String creatorCode;
    @ApiModelProperty("创建人姓名")
    private String creator;
    @ApiModelProperty("销售凭证类型代码")
    private String saleVouTypeCode;
    @ApiModelProperty("销售凭证类型描述")
    private String saleVouType;
    @ApiModelProperty("分类1")
    private String sort1;
    @ApiModelProperty("分类2")
    private String sort2;
    @ApiModelProperty("分类3")
    private String sort3;
    @ApiModelProperty("分类4")
    private String sort4;
    @ApiModelProperty("分类5")
    private String sort5;
    @ApiModelProperty("分类6")
    private String sort6;
    @ApiModelProperty("分类7")
    private String sort7;
    @ApiModelProperty("分类8")
    private String sort8;
    @ApiModelProperty("分类9")
    private String sort9;
    @ApiModelProperty("分类10")
    private String sort10;

    @ApiModelProperty("费用池折扣金额")
    private BigDecimal expensePoolDiscountAmt;
    @ApiModelProperty("非费用池折扣金额")
    private BigDecimal noexpensePoolDiscountAmt;
    @ApiModelProperty("结算单价")
    private BigDecimal accountsPrice;
    @ApiModelProperty("结算金额")
    private BigDecimal accountsAmt;

    @ApiModelProperty("记录日期")
    private String recordDate;
    @ApiModelProperty("时间分区")
    private String ds;

    /**
     * 年月
     */
    @ApiModelProperty("年月")
    private String yearMonthLy;

    /**
     * 销售组织编码(大区)
     */
    @ApiModelProperty("销售组织编码(大区)")
    private String salesOrgRegionCode;

    /**
     * 校验字段
     */
    private String verifyCode;

    @ApiModelProperty("客户编码")
    private String customerCode;

    @ApiModelProperty("销售机构编码")
    private String salesInstitutionCode;

    @ApiModelProperty("所属销售机构")
    private String salesInstitutionName;

    @ApiModelProperty("销售大区ERP编码")
    private String saleOfficeCode;

    @ApiModelProperty("销售大区编码")
    private String tpmSalesOrgCode;

    @ApiModelProperty("销售大区名称")
    private String saleOfficeName;

    @ApiModelProperty("销售组ERP代码")
    private String salesCode;

    @ApiModelProperty("销售组编码")
    private String salesGroupCode;

    @ApiModelProperty("销售组名称")
    private String salesGroupName;

}