package com.biz.crm.tpm.business.day.price.monitor.local.controller;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.business.common.sdk.model.Result;
import com.biz.crm.tpm.business.day.price.monitor.sdk.dto.DayPriceMonitorDto;
import com.biz.crm.tpm.business.day.price.monitor.sdk.service.DayPriceMonitorService;
import com.biz.crm.tpm.business.day.price.monitor.sdk.vo.DayPriceMonitorVo;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Pageable;
import org.springframework.data.web.PageableDefault;
import org.springframework.web.bind.annotation.*;

import java.util.List;

/**
 * 日价格监控表(tpm_day_price_monitor) 控制层
 *
 * @author : qiancheng
 * @date : 2022-11-11
 */
@RestController
@RequestMapping("/v1/dayPriceMonitor")
@Slf4j
@Api(tags = "日价格监控表")
public class DayPriceMonitorController {

    @Autowired
    private DayPriceMonitorService dayPriceMonitorService;


    /**
     * 分页查询数据
     *
     * @param pageable 分页对象
     * @param dayPriceMonitor 实体对象
     * @return 分页数据
     */
    @ApiOperation(value = "分页查询所有数据")
    @GetMapping("/findByConditions")
    public Result<Page<DayPriceMonitorVo>> findByConditions(@ApiParam(name = "pageable", value = "分页对象") @PageableDefault(20) Pageable pageable,
                                                            @ApiParam(name = "dayPriceMonitor", value = "日价格监控表信息") DayPriceMonitorDto dayPriceMonitor) {
        try {
            Page<DayPriceMonitorVo> page = this.dayPriceMonitorService.findByConditions(pageable, dayPriceMonitor);
            return Result.ok(page);
        } catch (Exception e) {
            log.error(e.getMessage(), e);
            return Result.error(e.getMessage());
        }
    }


    /**
     * 通过主键 查询单条数据
     *
     * @param id 主键
     * @return 单条数据
     */
    @ApiOperation(value = "通过主键查询单条数据")
    @GetMapping("/findById")
    public Result<DayPriceMonitorVo> findById(@RequestParam("id") @ApiParam(name = "id", value = "主键") String id) {
        try {
            DayPriceMonitorVo dayPriceMonitorVO = dayPriceMonitorService.findById(id);
            return Result.ok(dayPriceMonitorVO);
        } catch (Exception e) {
            log.error(e.getMessage(), e);
            return Result.error(e.getMessage());
        }
    }

    /**
     * 生成日价格监控数据
     */
    @ApiOperation(value = "生成日价格监控数据", httpMethod = "POST")
    @PostMapping("/dayPriceMonitorData")
    public Result dayPriceMonitorData(@ApiParam(name = "dayPriceMonitor", value = "日价格监控表信息") DayPriceMonitorDto dayPriceMonitor) {
        try {
            this.dayPriceMonitorService.getDataFromPromotionPlan(dayPriceMonitor);
            return Result.ok();
        } catch (Exception e) {
            log.error(e.getMessage(), e);
            return Result.error(e.getMessage());
        }
    }

    /**
     * 删除监控数据
     * @param ids 日价格监控ids
     */
    @ApiOperation(value = "删除监控数据")
    @DeleteMapping(value = "delete")
    public Result delete(@ApiParam(value = "策略id集合")@RequestParam List<String> ids){
        try {
            this.dayPriceMonitorService.delete(ids);
            return Result.ok();
        } catch (Exception e) {
            log.error(e.getMessage(), e);
            return Result.error(e.getMessage());
        }
    }

}
