package com.biz.crm.tpm.business.day.price.monitor.local.dataview;

import com.biz.crm.business.common.sdk.enums.EnableStatusEnum;
import com.bizunited.nebula.europa.database.register.sdk.service.DataviewRegister;
import org.springframework.stereotype.Component;

/**
 *  日价格监控表 DataView
 *  * @author miaoqiancheng
 *  * @since 2022-11-15
 */
@Component
public class DayPriceMonitorDataViewRegister implements DataviewRegister {

    @Override
    public String code() {
        return "tpm_day_price_monitor";
    }

    @Override
    public String desc() {
        return "TPM-日价格监控表";
    }

    @Override
    public String buildSql() {
        return "SELECT t.* FROM tpm_day_price_monitor t" +
                "  WHERE t.del_flag = '" + EnableStatusEnum.ENABLE.getCode() + "' "+
                "  AND t.tenant_code = :tenantCode ";
    }
}
