package com.biz.crm.tpm.business.day.price.monitor.local.entity;

import com.baomidou.mybatisplus.annotation.TableName;
import com.biz.crm.business.common.local.entity.TenantFlagOpEntity;
import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import org.springframework.format.annotation.DateTimeFormat;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Index;
import javax.persistence.Table;
import java.math.BigDecimal;
import java.util.Date;

@ApiModel(value = "DayPriceMonitor", description = "日价格监控表")
@TableName("tpm_day_price_monitor")
@EqualsAndHashCode(callSuper = false)
@Data
@Entity(name = "tpm_day_price_monitor")
@org.hibernate.annotations.Table(appliesTo = "tpm_day_price_monitor", comment = "日价格监控表")
@Table(name = "tpm_day_price_monitor", indexes = {@Index(name = "tpm_day_price_monitor_inx1", columnList = "product_code")})
public class DayPriceMonitor extends TenantFlagOpEntity {

    /**
     * 业态
     */
    @ApiModelProperty("业态 数据字典：mdm_business_format")
    @Column(name = "business_format_code", nullable = true, length = 32, columnDefinition = "varchar(32) COMMENT '业态'")
    private String businessFormatCode;

    @ApiModelProperty("分销渠道编码")
    @Column(name = "channel_code", length = 32, columnDefinition = "varchar(32) COMMENT '分销渠道编码'")
    private String channelCode;

    @ApiModelProperty("分销渠道名称")
    @Column(name = "channel_name", length = 32, columnDefinition = "varchar(32) COMMENT '分销渠道名称'")
    private String channelName;

    @ApiModelProperty(name = "salesOrgCode", value = "销售组织编码", notes = "销售组织编码")
    @Column(name = "sales_org_code", nullable = true,length = 32, columnDefinition = "VARCHAR(32) COMMENT '销售组织编码'")
    private String salesOrgCode;

    @ApiModelProperty(name = "salesOrgName", value = "销售组织名称", notes = "销售组织名称")
    @Column(name = "sales_org_name", nullable = true,length = 255, columnDefinition = "VARCHAR(255) COMMENT '销售组织名称'")
    private String salesOrgName;

    @ApiModelProperty(name = "customerCode", value = "客户编码", notes = "客户编码")
    @Column(name = "customer_code", nullable = true, length = 32, columnDefinition = "VARCHAR(32) COMMENT '客户编码'")
    private String customerCode;

    @ApiModelProperty(name = "customerErpCode", value = "客户ERP编码", notes = "客户ERP编码")
    @Column(name = "customer_erp_code", nullable = true, length = 32, columnDefinition = "VARCHAR(32) COMMENT '客户ERP编码'")
    private String customerErpCode;

    @ApiModelProperty(name = "customerName", value = "客户名称", notes = "客户名称")
    @Column(name = "customer_name", nullable = true, length = 255, columnDefinition = "VARCHAR(255) COMMENT '客户名称'")
    private String customerName;

    @ApiModelProperty(name = "productBrandCode", value = "品牌编码", notes = "品牌编码")
    @Column(name = "product_brand_code", nullable = true, length = 32, columnDefinition = "VARCHAR(32) COMMENT '品牌编码'")
    private String productBrandCode;

    @ApiModelProperty(name = "productBrandName", value = "品牌名称", notes = "品牌名称")
    @Column(name = "product_brand_name", nullable = true, length = 255, columnDefinition = "VARCHAR(255) COMMENT '品牌名称'")
    private String productBrandName;

    @ApiModelProperty(name = "productCode", value = "产品编码", notes = "产品编码")
    @Column(name = "product_code", nullable = true, length = 32, columnDefinition = "VARCHAR(32) COMMENT '产品编码'")
    private String productCode;

    @ApiModelProperty(name = "productName", value = "产品名称", notes = "产品名称")
    @Column(name = "product_name", nullable = true, length = 255, columnDefinition = "VARCHAR(255) COMMENT '产品名称'")
    private String productName;

    @ApiModelProperty(name = "monitorDate", value = "日期", notes = "日期")
    @JsonFormat(locale = "zh", timezone = "GMT+8", pattern = "yyyy-MM-dd")
    @DateTimeFormat(pattern = "yyyy-MM-dd")
    @Column(name = "monitor_date", nullable = true,length = 20, columnDefinition = "datetime COMMENT '日期'")
    private Date monitorDate;

    @ApiModelProperty(name = "businessModel", value = "业务模式", notes = "业务模式")
    @Column(name = "business_model", nullable = true,length = 32, columnDefinition = "VARCHAR(32) COMMENT '业务模式'")
    private String businessModel;

    @ApiModelProperty(name = "platformCode", value = "平台编码", notes = "平台编码")
    @Column(name = "platform_code", nullable = true,length = 32, columnDefinition = "VARCHAR(32) COMMENT '平台编码'")
    private String platformCode;

    @ApiModelProperty(name = "platformName", value = "平台名称", notes = "平台名称")
    @Column(name = "platform_name", nullable = true,length = 255, columnDefinition = "VARCHAR(255) COMMENT '平台名称'")
    private String platformName;

    @ApiModelProperty(name = "suggestedRetailPrice", value = "标准零售价", notes = "标准零售价")
    @Column(name = "suggested_retail_price", nullable = true,length = 20, columnDefinition = "DECIMAL(20,6) COMMENT '标准零售价'")
    private BigDecimal suggestedRetailPrice;

    @ApiModelProperty(name = "redLinePrice", value = "红线价", notes = "红线价")
    @Column(name = "red_line_price", nullable = true, length = 20, columnDefinition = "DECIMAL(20,6) COMMENT '红线价'")
    private BigDecimal redLinePrice;

    @ApiModelProperty(name = "promotionPrice", value = "促销选品价", notes = "促销选品价")
    @Column(name = "promotion_price", nullable = true,length = 20, columnDefinition = "DECIMAL(20,6) COMMENT '促销选品价'")
    private BigDecimal promotionPrice;

    @ApiModelProperty(name = "estimateLowerPrice", value = "预估最低价", notes = "预估最低价")
    @Column(name = "estimate_lower_price", nullable = true,length = 20, columnDefinition = "DECIMAL(20,6) COMMENT '预估最低价'")
    private BigDecimal estimateLowerPrice;

    @ApiModelProperty(name = "activityLowerPrice", value = "活动底价", notes = "活动底价")
    @Column(name = "activity_lower_price", nullable = true,length = 20, columnDefinition = "DECIMAL(20,6) COMMENT '活动底价'")
    private BigDecimal activityLowerPrice;

    @ApiModelProperty(name = "promotionPlanPrice", value = "促销规划价格", notes = "促销规划价格")
    @Column(name = "promotion_plan_price", nullable = true,length = 20, columnDefinition = "DECIMAL(20,6) COMMENT '促销规划价格'")
    private BigDecimal promotionPlanPrice;

    @ApiModelProperty("商品数量（箱）")
    @Column(name = "quantity", length = 10, nullable = true, columnDefinition = "int(10) COMMENT '商品数量（箱）'")
    private BigDecimal quantity;
    @ApiModelProperty(name = "amount", value = "总金额", notes = "总金额")
    @Column(name = "amount", nullable = true,length = 20, columnDefinition = "DECIMAL(20,6) COMMENT '总金额'")
    private BigDecimal amount;

    @ApiModelProperty(name = "salePrice", value = "实际销售价", notes = "实际销售价")
    @Column(name = "sale_price", nullable = true,length = 20, columnDefinition = "DECIMAL(20,6) COMMENT '实际销售价'")
    private BigDecimal salePrice;

    @ApiModelProperty(name = "saleVsRedPrice", value = "实际销售价VS红线价", notes = "实际销售价VS红线价")
    @Column(name = "sale_vs_red_price", nullable = true,length = 20, columnDefinition = "DECIMAL(20,6) COMMENT '实际销售价VS红线价'")
    private BigDecimal saleVsRedPrice;

    @ApiModelProperty(name = "saleVsPromotionPrice", value = "实际销售价VS促销选品价", notes = "实际销售价VS促销选品价")
    @Column(name = "sale_vs_promotion_price", nullable = true,length = 20, columnDefinition = "DECIMAL(20,6) COMMENT '实际销售价VS促销选品价'")
    private BigDecimal saleVsPromotionPrice;

    @ApiModelProperty(name = "saleVsEslowerPrice", value = "实际销售价VS预估最低价", notes = "实际销售价VS预估最低价")
    @Column(name = "sale_vs_eslower_price", nullable = true,length = 20, columnDefinition = "DECIMAL(20,6) COMMENT '实际销售价VS预估最低价'")
    private BigDecimal saleVsEslowerPrice;

    @ApiModelProperty(name = "saleVsLowerPrice", value = "实际销售价VS活动低价", notes = "实际销售价VS活动低价")
    @Column(name = "sale_vs_lower_price", nullable = true,length = 20, columnDefinition = "DECIMAL(20,6) COMMENT '实际销售价VS活动低价'")
    private BigDecimal saleVsLowerPrice;

}
