package com.biz.crm.tpm.business.day.price.monitor.local.mapper;

import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.tpm.business.day.price.monitor.local.entity.DayPriceMonitor;
import com.biz.crm.tpm.business.day.price.monitor.sdk.dto.DayPriceMonitorDto;
import com.biz.crm.tpm.business.day.price.monitor.sdk.vo.DayPriceMonitorVo;
import org.apache.ibatis.annotations.Param;

/**
 * 日价格监控表(tpm_day_price_monitor)表数据库访问层
 *
 * @author : qiancheng
 * @date : 2022-11-11
 */
public interface DayPriceMonitorMapper extends BaseMapper<DayPriceMonitor> {
    /**
     * 分页查询数据
     *
     * @param page 分页对象
     * @param dayPriceMonitor 实体对象
     * @return 分页对象列表
     */
    Page<DayPriceMonitorVo> findByConditions(@Param("page") Page<DayPriceMonitorVo> page, @Param("dto") DayPriceMonitorDto dayPriceMonitor);

}
