package com.biz.crm.tpm.business.day.price.monitor.local.repository;

import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.business.common.sdk.enums.DelFlagStatusEnum;
import com.biz.crm.tpm.business.day.price.monitor.local.entity.DayPriceMonitor;
import com.biz.crm.tpm.business.day.price.monitor.local.mapper.DayPriceMonitorMapper;
import com.biz.crm.tpm.business.day.price.monitor.sdk.dto.DayPriceMonitorDto;
import com.biz.crm.tpm.business.day.price.monitor.sdk.vo.DayPriceMonitorVo;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Component;

import javax.annotation.Resource;
import java.util.List;

/**
 * 日价格监控表(tpm_day_price_monitor)数据库访问层
 *
 * @author : qiancheng
 * @date : 2022-11-11
 */
@Component
public class DayPriceMonitorRepository extends ServiceImpl<DayPriceMonitorMapper, DayPriceMonitor> {

    @Resource
    private DayPriceMonitorMapper dayPriceMonitorMapper;

    /**
     * 分页查询数据
     * @param pageable 分页对象
     * @param dayPriceMonitor 实体对象
     */
    public Page<DayPriceMonitorVo> findByConditions(Pageable pageable, DayPriceMonitorDto dayPriceMonitor){
        if(pageable == null){
            pageable = PageRequest.of(1,50);
        }
        Page<DayPriceMonitorVo> page = new Page<>(pageable.getPageNumber(), pageable.getPageSize());
        return this.dayPriceMonitorMapper.findByConditions(page,dayPriceMonitor);
    }

    public void deleteByIds(List<String> ids){
        this.update(Wrappers.lambdaUpdate(DayPriceMonitor.class)
                        .set(DayPriceMonitor::getDelFlag, DelFlagStatusEnum.DELETE.getCode())
                .in(DayPriceMonitor::getId, ids)
        );
    }

    public void deleteByDate(String monitorDate){
        this.update(Wrappers.lambdaUpdate(DayPriceMonitor.class)
                        .set(DayPriceMonitor::getDelFlag, DelFlagStatusEnum.DELETE.getCode())
                .likeRight(DayPriceMonitor::getMonitorDate, monitorDate)
        );
    }

}
