/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.tpm.business.day.price.monitor.local.service.internal;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.business.common.sdk.enums.DelFlagStatusEnum;
import com.biz.crm.mdm.business.customer.sdk.service.CustomerVoService;
import com.biz.crm.mdm.business.customer.sdk.vo.CustomerVo;
import com.biz.crm.mdm.business.price.sdk.service.PriceVoService;
import com.biz.crm.mdm.business.price.sdk.vo.PriceFeeVo;
import com.biz.crm.mn.common.base.util.DateUtil;
import com.biz.crm.tpm.business.day.price.monitor.local.entity.DayPriceMonitor;
import com.biz.crm.tpm.business.day.price.monitor.local.repository.DayPriceMonitorRepository;
import com.biz.crm.tpm.business.day.price.monitor.sdk.dto.DayPriceMonitorDto;
import com.biz.crm.tpm.business.day.price.monitor.sdk.service.DayPriceMonitorService;
import com.biz.crm.tpm.business.day.price.monitor.sdk.vo.DayPriceMonitorVo;
import com.biz.crm.tpm.business.day.sales.sdk.dto.TpmDaySalesSearchDto;
import com.biz.crm.tpm.business.day.sales.sdk.service.TpmDaySalesService;
import com.biz.crm.tpm.business.day.sales.sdk.vo.TpmDaySalesVo;
import com.biz.crm.tpm.business.promotion.plan.sdk.dto.CurrentMonthSaleDto;
import com.biz.crm.tpm.business.promotion.plan.sdk.service.PromotionPlanService;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import com.google.common.collect.Maps;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;

@Service(value="dayPriceMonitorService")
public class DayPriceMonitorServiceImpl
implements DayPriceMonitorService {
    private static final Logger log = LoggerFactory.getLogger(DayPriceMonitorServiceImpl.class);
    @Autowired(required=false)
    private DayPriceMonitorRepository dayPriceMonitorRepository;
    @Autowired(required=false)
    private NebulaToolkitService nebulaToolkitService;
    @Autowired(required=false)
    private TpmDaySalesService tpmDaySalesService;
    @Autowired(required=false)
    private CustomerVoService customerVoService;
    @Autowired(required=false)
    private PriceVoService priceVoService;
    @Autowired(required=false)
    private PromotionPlanService promotionPlanService;

    public Page<DayPriceMonitorVo> findByConditions(Pageable pageable, DayPriceMonitorDto dayPriceMonitor) {
        if (pageable == null) {
            pageable = PageRequest.of((int)1, (int)20);
        }
        if (dayPriceMonitor == null) {
            dayPriceMonitor = new DayPriceMonitorDto();
        }
        if (StringUtils.isBlank((CharSequence)dayPriceMonitor.getDelFlag())) {
            dayPriceMonitor.setDelFlag(DelFlagStatusEnum.NORMAL.getCode());
        }
        if (StringUtils.isBlank((CharSequence)dayPriceMonitor.getTenantCode())) {
            dayPriceMonitor.setTenantCode(TenantUtils.getTenantCode());
        }
        return this.dayPriceMonitorRepository.findByConditions(pageable, dayPriceMonitor);
    }

    public DayPriceMonitorVo findById(String id) {
        Validate.notBlank((CharSequence)id, (String)"\u4e3b\u952e\u4e0d\u80fd\u591f\u4e3a\u7a7a", (Object[])new Object[0]);
        DayPriceMonitor dayPriceMonitorEntity = (DayPriceMonitor)((Object)this.dayPriceMonitorRepository.getById((Serializable)((Object)id)));
        return (DayPriceMonitorVo)this.nebulaToolkitService.copyObjectByWhiteList((Object)dayPriceMonitorEntity, DayPriceMonitorVo.class, HashSet.class, ArrayList.class, new String[0]);
    }

    @Transactional(rollbackFor={Exception.class})
    public void getDataFromPromotionPlan(DayPriceMonitorDto dto) {
        List customerList;
        Validate.notBlank((CharSequence)dto.getMonitorDateStr(), (String)"\u65e5\u671f\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Date startDate = DateUtil.getDateByFormat((String)dto.getMonitorDateStr(), (String)"yyyy-MM-dd");
        this.dayPriceMonitorRepository.deleteByDate(dto.getMonitorDateStr());
        TpmDaySalesSearchDto tpmDaySalesSearchDto = new TpmDaySalesSearchDto();
        tpmDaySalesSearchDto.setStartDate(startDate);
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(startDate);
        calendar.add(5, 1);
        tpmDaySalesSearchDto.setEndDate(calendar.getTime());
        List dataFromPromotionPlan = this.tpmDaySalesService.getDataFromPromotionPlan(tpmDaySalesSearchDto);
        if (CollectionUtils.isEmpty((Collection)dataFromPromotionPlan)) {
            return;
        }
        List customerCodeList = dataFromPromotionPlan.stream().filter(item -> StringUtils.isNotEmpty((CharSequence)item.getSalesInstitutionCode())).filter(item -> StringUtils.isNotEmpty((CharSequence)item.getCustomer())).map(item -> item.getCustomer() + item.getSalesInstitutionCode() + item.getChannelCode() + item.getBusinessFormatCode()).distinct().collect(Collectors.toList());
        Map<Object, Object> customerVoMap = Maps.newHashMap();
        if (!CollectionUtils.isEmpty(customerCodeList) && !CollectionUtils.isEmpty((Collection)(customerList = this.customerVoService.findBaseByCustomerCodes(customerCodeList)))) {
            customerVoMap = customerList.stream().collect(Collectors.toMap(CustomerVo::getCustomerCode, Function.identity(), (o, n) -> n));
        }
        ArrayList<DayPriceMonitor> dayPriceMonitorList = new ArrayList<DayPriceMonitor>();
        for (TpmDaySalesVo tpmDaySalesVo : dataFromPromotionPlan) {
            CustomerVo customerVo;
            DayPriceMonitor dayPriceMonitor = new DayPriceMonitor();
            dayPriceMonitor.setBusinessFormatCode(tpmDaySalesVo.getBusinessFormatCode());
            dayPriceMonitor.setChannelCode(tpmDaySalesVo.getChannelCode());
            dayPriceMonitor.setChannelName(tpmDaySalesVo.getChannelName());
            dayPriceMonitor.setSalesOrgCode(tpmDaySalesVo.getSalesInstitutionCode());
            dayPriceMonitor.setSalesOrgName(tpmDaySalesVo.getSalesInstitutionName());
            dayPriceMonitor.setCustomerErpCode(tpmDaySalesVo.getCustomer());
            String customerCode = dayPriceMonitor.getCustomerErpCode() + dayPriceMonitor.getSalesOrgCode() + dayPriceMonitor.getChannelCode() + dayPriceMonitor.getBusinessFormatCode();
            dayPriceMonitor.setCustomerCode(customerCode);
            dayPriceMonitor.setCustomerName(tpmDaySalesVo.getCustomerName());
            dayPriceMonitor.setProductCode(tpmDaySalesVo.getGoodsCode());
            dayPriceMonitor.setProductName(tpmDaySalesVo.getGoodsName());
            dayPriceMonitor.setQuantity(tpmDaySalesVo.getNum());
            dayPriceMonitor.setAmount(tpmDaySalesVo.getAmount());
            if (null != dayPriceMonitor.getQuantity() && dayPriceMonitor.getQuantity().compareTo(BigDecimal.ZERO) != 0) {
                dayPriceMonitor.setSalePrice(Optional.ofNullable(dayPriceMonitor.getAmount()).orElse(BigDecimal.ZERO).divide(dayPriceMonitor.getQuantity(), 6, 1));
            }
            dayPriceMonitor.setMonitorDate(startDate);
            if (StringUtils.isNotEmpty((CharSequence)dayPriceMonitor.getCustomerCode()) && null != (customerVo = (CustomerVo)customerVoMap.get(dayPriceMonitor.getCustomerCode()))) {
                dayPriceMonitor.setBusinessModel(customerVo.getBusinessModelCode());
                dayPriceMonitor.setPlatformCode(customerVo.getEstorePlatform());
            }
            try {
                PriceFeeVo priceFeeVo = this.priceVoService.findByGoodsCode(dayPriceMonitor.getProductCode(), dayPriceMonitor.getCustomerErpCode(), dayPriceMonitor.getBusinessModel(), dto.getMonitorDateStr());
                if (null != priceFeeVo) {
                    dayPriceMonitor.setSuggestedRetailPrice(priceFeeVo.getStandardRetailPrice());
                    dayPriceMonitor.setRedLinePrice(priceFeeVo.getRedLinePrice());
                    dayPriceMonitor.setPromotionPrice(priceFeeVo.getPromotionalSelectionPrice());
                }
            }
            catch (Exception e) {
                log.error("\u65e5\u4ef7\u683c\u76d1\u63a7\u4ef7\u683c\u67e5\u8be2\u5931\u8d25\uff1a" + e.getMessage(), (Throwable)e);
            }
            CurrentMonthSaleDto currentMonthSaleDto = new CurrentMonthSaleDto();
            currentMonthSaleDto.setCustomerCode(dayPriceMonitor.getCustomerCode());
            currentMonthSaleDto.setProductCode(dayPriceMonitor.getProductCode());
            currentMonthSaleDto.setMonitorDateStr(dto.getMonitorDateStr());
            BigDecimal activityBasePrice = this.promotionPlanService.getMinActivityBasePrice(currentMonthSaleDto);
            dayPriceMonitor.setActivityLowerPrice(activityBasePrice);
            if (null != dayPriceMonitor.getSalePrice()) {
                dayPriceMonitor.setSaleVsRedPrice(dayPriceMonitor.getSalePrice().subtract(Optional.ofNullable(dayPriceMonitor.getRedLinePrice()).orElse(BigDecimal.ZERO)));
                dayPriceMonitor.setSaleVsPromotionPrice(dayPriceMonitor.getSalePrice().subtract(Optional.ofNullable(dayPriceMonitor.getPromotionPrice()).orElse(BigDecimal.ZERO)));
                dayPriceMonitor.setSaleVsEslowerPrice(dayPriceMonitor.getSalePrice().subtract(Optional.ofNullable(dayPriceMonitor.getEstimateLowerPrice()).orElse(BigDecimal.ZERO)));
                dayPriceMonitor.setSaleVsLowerPrice(dayPriceMonitor.getSalePrice().subtract(Optional.ofNullable(dayPriceMonitor.getActivityLowerPrice()).orElse(BigDecimal.ZERO)));
            }
            dayPriceMonitor.setTenantCode(TenantUtils.getTenantCode());
            dayPriceMonitorList.add(dayPriceMonitor);
        }
        if (dayPriceMonitorList.size() > 0) {
            this.dayPriceMonitorRepository.saveOrUpdateBatch(dayPriceMonitorList);
        }
    }

    public void delete(List<String> ids) {
        this.dayPriceMonitorRepository.deleteByIds(ids);
    }
}

