package com.biz.crm.tpm.business.day.price.monitor.sdk.dto;

import com.biz.crm.business.common.sdk.dto.TenantFlagOpDto;
import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import org.springframework.format.annotation.DateTimeFormat;

import java.math.BigDecimal;
import java.util.Date;

@Data
@EqualsAndHashCode(callSuper = true)
@ApiModel(value = "DayPriceMonitorDto", description = "日价格监控表Dto")
public class DayPriceMonitorDto extends TenantFlagOpDto {

    /**
     * 业态
     */
    @ApiModelProperty("业态 数据字典：mdm_business_format")
    private String businessFormatCode;

    @ApiModelProperty("分销渠道编码")
    private String channelCode;

    @ApiModelProperty("分销渠道名称")
    private String channelName;

    @ApiModelProperty(name = "salesOrgCode", value = "销售组织编码", notes = "销售组织编码")
    private String salesOrgCode;

    @ApiModelProperty(name = "salesOrgName", value = "销售组织名称", notes = "销售组织名称")
    private String salesOrgName;

    @ApiModelProperty(name = "customerCode", value = "客户编码", notes = "客户编码")
    private String customerCode;

    @ApiModelProperty(name = "customerErpCode", value = "客户ERP编码", notes = "客户ERP编码")
    private String customerErpCode;

    @ApiModelProperty(name = "customerName", value = "客户名称", notes = "客户名称")
    private String customerName;

    @ApiModelProperty(name = "productBrandCode", value = "品牌编码", notes = "品牌编码")
    private String productBrandCode;

    @ApiModelProperty(name = "productBrandName", value = "品牌名称", notes = "品牌名称")
    private String productBrandName;

    @ApiModelProperty(name = "productCode", value = "产品编码", notes = "产品编码")
    private String productCode;

    @ApiModelProperty(name = "productName", value = "产品名称", notes = "产品名称")
    private String productName;

    @ApiModelProperty(name = "monitorDate", value = "日期", notes = "日期")
    @JsonFormat(locale = "zh", timezone = "GMT+8", pattern = "yyyy-MM-dd")
    @DateTimeFormat(pattern = "yyyy-MM-dd")
    private Date monitorDate;

    @ApiModelProperty(name = "monitorDateStr", value = "日期字符串", notes = "日期字符串")
    private String monitorDateStr;

    @ApiModelProperty(name = "businessModel", value = "业务模式", notes = "业务模式")
    private String businessModel;

    @ApiModelProperty(name = "platformCode", value = "平台编码", notes = "平台编码")
    private String platformCode;

    @ApiModelProperty(name = "platformName", value = "平台名称", notes = "平台名称")
    private String platformName;

    @ApiModelProperty(name = "suggestedRetailPrice", value = "标准零售价", notes = "标准零售价")
    private BigDecimal suggestedRetailPrice;

    @ApiModelProperty(name = "redLinePrice", value = "红线价", notes = "红线价")
    private BigDecimal redLinePrice;

    @ApiModelProperty(name = "promotionPrice", value = "促销选品价", notes = "促销选品价")
    private BigDecimal promotionPrice;

    @ApiModelProperty(name = "estimateLowerPrice", value = "预估最低价", notes = "预估最低价")
    private BigDecimal estimateLowerPrice;

    @ApiModelProperty(name = "activityLowerPrice", value = "活动底价", notes = "活动底价")
    private BigDecimal activityLowerPrice;

    @ApiModelProperty(name = "promotionPlanPrice", value = "促销规划价格", notes = "促销规划价格")
    private BigDecimal promotionPlanPrice;

    @ApiModelProperty("商品数量（箱）")
    private BigDecimal quantity;

    @ApiModelProperty(name = "amount", value = "总金额", notes = "总金额")
    private BigDecimal amount;

    @ApiModelProperty(name = "salePrice", value = "实际销售价", notes = "实际销售价")
    private BigDecimal salePrice;

    @ApiModelProperty(name = "saleVsRedPrice", value = "实际销售价VS红线价", notes = "实际销售价VS红线价")
    private BigDecimal saleVsRedPrice;

    @ApiModelProperty(name = "saleVsPromotionPrice", value = "实际销售价VS促销选品价", notes = "实际销售价VS促销选品价")
    private BigDecimal saleVsPromotionPrice;

    @ApiModelProperty(name = "saleVsEslowerPrice", value = "实际销售价VS预估最低价", notes = "实际销售价VS预估最低价")
    private BigDecimal saleVsEslowerPrice;

    @ApiModelProperty(name = "saleVsLowerPrice", value = "实际销售价VS活动低价", notes = "实际销售价VS活动低价")
    private BigDecimal saleVsLowerPrice;

}
