package com.biz.crm.tpm.business.day.price.monitor.sdk.service;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.tpm.business.day.price.monitor.sdk.dto.DayPriceMonitorDto;
import com.biz.crm.tpm.business.day.price.monitor.sdk.vo.DayPriceMonitorVo;
import org.springframework.data.domain.Pageable;

import java.util.List;

/**
 *
 * @author : qiancheng
 * @date : 2022-11-11
 */
public interface DayPriceMonitorService {

    /**
     * 分页查询数据
     * @param pageable        分页对象
     * @param dayPriceMonitor 实体对象
     * @return 分页对象
     */
    Page<DayPriceMonitorVo> findByConditions(Pageable pageable, DayPriceMonitorDto dayPriceMonitor);

    /**
     * 通过主键查询单条数据
     * @param id 主键
     * @return 单条数据
     */
    DayPriceMonitorVo findById(String id);


    /**
     * 从促销规划中获取数据
     */
    void getDataFromPromotionPlan(DayPriceMonitorDto dayPriceMonitor);

    void delete(List<String> ids);

}
