package com.biz.crm.tpm.business.day.sales.local.controller;


import com.biz.crm.tpm.business.day.sales.sdk.dto.TpmDaySalesSpliceSearchDto;
import com.biz.crm.tpm.business.day.sales.sdk.service.TpmDaySalesSpliceService;
import com.biz.crm.business.common.sdk.model.Result;
import com.biz.crm.tpm.business.day.sales.sdk.vo.TpmDaySalesSpliceVo;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;
import org.springframework.data.domain.Pageable;
import org.springframework.data.web.PageableDefault;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;

import java.math.BigDecimal;
import java.util.List;

/**
 * 日销售数据管理（拆分明细）
 *
 * @author yaoyongming
 * @since 2022-10-27 16:50:59
 */
@RestController
@RequestMapping("/v1/tpmDaySalesSplice")
@Slf4j
@Api(tags = "日销售数据管理（拆分明细）")
public class TpmDaySalesSpliceController {
    /**
     * 服务对象
     */
    @Autowired
    private TpmDaySalesSpliceService tpmDaySalesSpliceService;

    /**
     * 分页查询所有数据
     *
     * @param pageable          分页对象
     * @param tpmDaySalesSplice 查询DTO
     * @return 所有数据
     */
    @ApiOperation(value = "分页查询所有数据")
    @GetMapping("findByConditions")
    public Result<Page<TpmDaySalesSpliceVo>> findByConditions(@ApiParam(name = "pageable", value = "分页对象") @PageableDefault(50) Pageable pageable,
                                                            @ApiParam(name = "tpmDaySalesSplice", value = "日销售数据拆分明细DTO") TpmDaySalesSpliceSearchDto tpmDaySalesSplice) {
        try {
            Page<TpmDaySalesSpliceVo> page = this.tpmDaySalesSpliceService.findByConditions(pageable, tpmDaySalesSplice);
            return Result.ok(page);
        } catch (Exception e) {
            log.error(e.getMessage(), e);
            return Result.error(e.getMessage());
        }
    }

    /**
     * 新增数据
     *
     * @param tpmDaySalesVo VO对象
     * @return 新增结果
     */
    @ApiOperation(value = "新增数据")
    @PostMapping
    public Result<?> create(@ApiParam(name = "tpmDaySalesVo", value = "日销售数据管理（拆分明细）") @RequestBody TpmDaySalesSpliceVo tpmDaySalesVo) {
        try {
            this.tpmDaySalesSpliceService.create(tpmDaySalesVo);
            return Result.ok();
        } catch (Exception e) {
            log.error(e.getMessage(), e);
            return Result.error(e.getMessage());
        }
    }

    /**
     * 获取GMV
     *
     * @param tpmDaySalesVo VO对象
     * @return 新增结果
     */
    @ApiOperation(value = "获取GMV")
    @PostMapping("getGmv")
    public Result<?> getGmv(@ApiParam(name = "tpmDaySalesVo", value = "日销售数据管理（拆分明细）") @RequestBody TpmDaySalesSpliceVo tpmDaySalesVo) {
        try {
            BigDecimal gmv = this.tpmDaySalesSpliceService.getGmv(tpmDaySalesVo);
            return Result.ok(gmv);
        } catch (Exception e) {
            log.error(e.getMessage(), e);
            return Result.error(e.getMessage());
        }
    }

    /**
     * 删除数据
     *
     * @param ids 主键集合
     * @return 删除结果
     */
    @ApiOperation(value = "删除数据")
    @DeleteMapping
    public Result<?> delete(@ApiParam(name = "ids", value = "主键集合") @RequestParam("ids") List<String> ids) {
        try {
            this.tpmDaySalesSpliceService.delete(ids);
            return Result.ok();
        } catch (Exception e) {
            log.error(e.getMessage(), e);
            return Result.error(e.getMessage());
        }
    }
}
