package com.biz.crm.tpm.business.day.sales.local.entity;

import com.baomidou.mybatisplus.annotation.FieldFill;
import com.baomidou.mybatisplus.annotation.FieldStrategy;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.biz.crm.business.common.local.entity.TenantFlagOpEntity;
import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.EqualsAndHashCode;
import lombok.Getter;
import lombok.Setter;
import org.springframework.format.annotation.DateTimeFormat;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Index;
import javax.persistence.Table;
import java.math.BigDecimal;
import java.util.Date;

/**
 * 日销售数据
 *
 * @author: yaoyongming
 * @date: 2022/10/27 15:39
 */
@Getter
@Setter
@EqualsAndHashCode(callSuper = false)
@ApiModel(value = "TpmDaySales", description = "日销售数据实体类")
@Entity
@org.hibernate.annotations.Table(appliesTo = "tpm_day_sales", comment = "日销售数据实体类")
@TableName("tpm_day_sales")
@Table(name = "tpm_day_sales",
        indexes = {
                @Index(name = "uk_day_sales", columnList = "customer,trade_date,goods_code,sales_institution_code,channel_code,business_format_code", unique = true),
                @Index(name = "tpm_day_sales_index1", columnList = "year_month_ly", unique = false),
        })
public class TpmDaySales extends TenantFlagOpEntity {

    @ApiModelProperty(value = "年月", notes = "")
    @Column(name = "year_month_ly", length = 10, columnDefinition = "VARCHAR(10) COMMENT '年月 '")
    private String yearMonthLy;

    /**
     * 客户
     */
    @ApiModelProperty("客户")
    @Column(name = "customer", nullable = false, length = 128, columnDefinition = "VARCHAR(128) COMMENT '客户'")
    private String customer;

    /**
     * 客户名称
     */
    @ApiModelProperty("客户名称")
    @Column(name = "customer_name", nullable = false, length = 128, columnDefinition = "VARCHAR(128) COMMENT '客户名称'")
    private String customerName;

    /**
     * 交易日期
     */
    @ApiModelProperty("交易日期")
    @TableField(fill = FieldFill.INSERT, updateStrategy = FieldStrategy.NOT_EMPTY)
    @JsonFormat(locale = "zh", timezone = "GMT+8", pattern = "yyyy-MM-dd")
    @DateTimeFormat(pattern = "yyyy-MM-dd")
    @Column(name = "trade_date", length = 10, nullable = false, columnDefinition = "datetime COMMENT '交易日期'")
    private Date tradeDate;

    /**
     * 货品编号
     */
    @ApiModelProperty("货品编号")
    @Column(name = "goods_code", nullable = false, length = 64, columnDefinition = "VARCHAR(64) COMMENT '货品编号'")
    private String goodsCode;

    /**
     * 货品名称
     */
    @ApiModelProperty("货品名称")
    @Column(name = "goods_name", nullable = false, length = 128, columnDefinition = "VARCHAR(128) COMMENT '货品名称'")
    private String goodsName;

    /**
     * 金额
     */
    @ApiModelProperty("金额")
    @Column(name = "amount", nullable = false, columnDefinition = "decimal(20,6) COMMENT '金额'")
    private BigDecimal amount;

    /**
     * 数量
     */
    @ApiModelProperty("数量")
    @Column(name = "num", nullable = false, columnDefinition = "decimal(20,6) COMMENT '数量'")
    private BigDecimal num;

    /**
     * 可拆分金额
     */
    @ApiModelProperty("可拆分金额")
    @Column(name = "amount_enable", nullable = false, columnDefinition = "decimal(20,6) COMMENT '可拆分金额'")
    private BigDecimal amountEnable;

    /**
     * 可拆分数量
     */
    @ApiModelProperty("可拆分数量")
    @Column(name = "num_enable", nullable = false, columnDefinition = "INT COMMENT '可拆分数量'")
    private Integer numEnable;

    /**
     * 销售机构编码
     */
    @ApiModelProperty("销售机构编码")
    @Column(name = "sales_institution_code", length = 32, columnDefinition = "VARCHAR(32) COMMENT '销售机构编码'")
    private String salesInstitutionCode;

    /**
     * 销售机构名称
     */
    @ApiModelProperty("销售机构名称")
    @Column(name = "sales_institution_name", columnDefinition = "VARCHAR(255) COMMENT '销售机构名称'")
    private String salesInstitutionName;

    /**
     * 渠道编码
     */
    @ApiModelProperty("渠道编码")
    @Column(name = "channel_code", length = 32, columnDefinition = "varchar(32) COMMENT '渠道编码'")
    private String channelCode;

    /**
     * 渠道名称
     */
    @ApiModelProperty("渠道名称")
    @Column(name = "channel_name", columnDefinition = "varchar(255) COMMENT '渠道名称'")
    private String channelName;

    /**
     * 业态
     */
    @ApiModelProperty("业态 数据字典：mdm_business_format")
    @Column(name = "business_format_code", length = 32, columnDefinition = "varchar(32) COMMENT '业态'")
    private String businessFormatCode;

    @Column(name = "verify_code", length = 256, columnDefinition = "VARCHAR(256) COMMENT '验证唯一'")
    private String verifyCode;
}
