package com.biz.crm.tpm.business.day.sales.local.mapper;


import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.biz.crm.tpm.business.day.sales.sdk.dto.TpmDaySalesSearchDto;
import com.biz.crm.tpm.business.day.sales.local.entity.TpmDaySales;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.tpm.business.day.sales.sdk.vo.TpmDaySalesVo;
import org.apache.ibatis.annotations.Param;

import java.math.BigDecimal;
import java.util.List;

/**
 * 日销售数据实体类(TpmDaySales)表mybatis访问层
 *
 * @author yaoyongming
 * @since 2022-10-27 16:50:59
 */
public interface TpmDaySalesMapper extends BaseMapper<TpmDaySales> {

    /**
     * 分页查询所有数据
     *
     * @param page        分页对象
     * @param tpmDaySales 查询DTO
     * @return 所有数据
     */
    Page<TpmDaySalesVo> findByConditions(@Param("page") Page<TpmDaySalesVo> page, @Param("dto") TpmDaySalesSearchDto tpmDaySales);

    /**
     * 查询所有数据
     *
     * @param tpmDaySales 查询DTO
     * @return 所有数据
     */
    List<TpmDaySalesVo> findByConditionsNoPage(@Param("dto") TpmDaySalesSearchDto tpmDaySales);

    /**
     * 查询所有数据
     *
     * @param tpmDaySales 查询DTO
     * @return 所有数据
     */
    List<TpmDaySalesVo> findByConditionsNoPage2(@Param("dto") TpmDaySalesSearchDto tpmDaySales);

    /**
     * 获取总金额
     * @param tpmDaySalesSearch
     * @return
     */
    BigDecimal getDaySalesTotalAmount(@Param("daySalesSearch") TpmDaySalesSearchDto tpmDaySalesSearch);

    List<TpmDaySalesVo> getDataFromPromotionPlan(@Param("dto") TpmDaySalesSearchDto dto);

}

