package com.biz.crm.tpm.business.day.sales.local.mapper;


import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.biz.crm.tpm.business.day.sales.sdk.dto.TpmDaySalesSpliceDto;
import com.biz.crm.tpm.business.day.sales.sdk.dto.TpmDaySalesSpliceSearchDto;
import com.biz.crm.tpm.business.day.sales.local.entity.TpmDaySalesSplice;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.tpm.business.day.sales.sdk.vo.TpmDaySalesSpliceVo;
import org.apache.ibatis.annotations.Param;

import java.util.List;

/**
 * 日销售数据拆分明细实体类(TpmDaySalesSplice)表mybatis访问层
 *
 * @author yaoyongming
 * @since 2022-10-27 16:51:00
 */
public interface TpmDaySalesSpliceMapper extends BaseMapper<TpmDaySalesSplice> {

    /**
     * 分页查询所有数据
     *
     * @param page              分页对象
     * @param tpmDaySalesSplice 查询DTO
     * @return 所有数据
     */
    Page<TpmDaySalesSpliceVo> findByConditions(@Param("page") Page<TpmDaySalesSpliceVo> page, @Param("dto") TpmDaySalesSpliceSearchDto tpmDaySalesSplice);

    /**
     * 根据年月查询
     *
     * @param page
     * @param dto
     * @return
     */
    Page<TpmDaySalesSpliceVo> findByYearAndMonth(Page<TpmDaySalesSpliceVo> page, @Param("dto") TpmDaySalesSpliceDto dto);

    List<TpmDaySalesSpliceVo> getByCustomerAndProduct(@Param("yearMonthLy")String yearMonthLy,@Param("customer") String customer,
                                                      @Param("goodsCode")String goodsCode,@Param("tenantCode") String tenantCode);
}

