package com.biz.crm.tpm.business.day.sales.local.notifier.log;

import com.biz.crm.common.log.sdk.dto.CrmBusinessLogDto;
import com.biz.crm.common.log.sdk.enums.OperationTypeEunm;
import com.biz.crm.common.log.sdk.service.CrmBusinessLogVoService;
import com.biz.crm.tpm.business.day.sales.sdk.dto.log.DaySalesLogEventDto;
import com.biz.crm.tpm.business.day.sales.sdk.event.log.DaySalesLogEventListener;
import com.biz.crm.tpm.business.day.sales.sdk.vo.TpmDaySalesVo;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.stereotype.Service;

import javax.transaction.Transactional;

/**
 * 日销售数据 业务日志监听实现
 *
 * @author: yaoyongming
 * @date: 2022/10/31 13:37
 */
@Component
public class DaySalesLogEventListenerImpl implements DaySalesLogEventListener {

    @Autowired
    private CrmBusinessLogVoService crmBusinessLogVoService;

    @Override
    public void onCreate(DaySalesLogEventDto eventDto) {
        TpmDaySalesVo newest = eventDto.getNewest();
        TpmDaySalesVo original = eventDto.getOriginal();
        String onlyKey = newest.getId();
        CrmBusinessLogDto crmBusinessLogDto = new CrmBusinessLogDto();
        crmBusinessLogDto.setOperationType(OperationTypeEunm.CREATE.getDictCode());
        crmBusinessLogDto.setOnlyKey(onlyKey);
        crmBusinessLogDto.setAppCode(TenantUtils.getTenantCode());
        crmBusinessLogDto.setTenantCode(TenantUtils.getTenantCode());
        crmBusinessLogDto.setOldObject(original);
        crmBusinessLogDto.setNewObject(newest);
        crmBusinessLogVoService.handleSave(crmBusinessLogDto);
    }

    @Override
    public void onDelete(DaySalesLogEventDto eventDto) {

    }

    @Override
    public void onUpdate(DaySalesLogEventDto eventDto) {

    }

    @Override
    public void onEnable(DaySalesLogEventDto eventDto) {

    }

    @Override
    public void onDisable(DaySalesLogEventDto eventDto) {

    }

}
