package com.biz.crm.tpm.business.day.sales.local.repository;


import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.biz.crm.tpm.business.day.sales.sdk.dto.TpmDaySalesSearchDto;
import com.biz.crm.tpm.business.day.sales.local.entity.TpmDaySales;
import com.biz.crm.tpm.business.day.sales.local.mapper.TpmDaySalesMapper;
import com.biz.crm.tpm.business.day.sales.sdk.vo.TpmDaySalesVo;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import org.springframework.stereotype.Component;
import org.springframework.data.domain.Pageable;

import java.math.BigDecimal;
import java.util.List;


/**
 * 日销售数据实体类(TpmDaySales)表数据库访问层
 *
 * @author yaoyongming
 * @since 2022-10-27 16:50:58
 */
@Component
public class TpmDaySalesRepository extends ServiceImpl<TpmDaySalesMapper, TpmDaySales> {

    @Autowired
    private TpmDaySalesMapper tpmDaySalesMapper;

    /**
     * 分页查询数据
     *
     * @param pageable    分页对象
     * @param tpmDaySales DTO对象
     * @return
     */
    public Page<TpmDaySalesVo> findByConditions(Pageable pageable, TpmDaySalesSearchDto tpmDaySales) {
        Page<TpmDaySalesVo> page = new Page<>(pageable.getPageNumber(), pageable.getPageSize());
        Page<TpmDaySalesVo> pageList = this.tpmDaySalesMapper.findByConditions(page, tpmDaySales);
        return pageList;
    }

    /**
     * 查询数据
     *
     * @param tpmDaySales DTO对象
     * @return
     */
    public List<TpmDaySalesVo> findByConditionsNoPage(TpmDaySalesSearchDto tpmDaySales) {
        return this.tpmDaySalesMapper.findByConditionsNoPage(tpmDaySales);
    }

    /**
     * 查询数据
     *
     * @param tpmDaySales DTO对象
     * @return
     */
    public List<TpmDaySalesVo> findByConditionsNoPage2(TpmDaySalesSearchDto tpmDaySales) {
        return this.tpmDaySalesMapper.findByConditionsNoPage2(tpmDaySales);
    }

    /**
     * 通过主键列表查询多条数据
     *
     * @param idList 主键列表
     * @return 多条数据
     */
    public List<TpmDaySales> findByIdList(List<String> idList) {
        return this.lambdaQuery().in(TpmDaySales::getId, idList).list();
    }

    /**
     * 查询是否存在数据并返回存在数据的id
     *
     * @param vo
     * @return
     */
    public List<TpmDaySales> findOnCreate(TpmDaySalesVo vo) {
        return this.lambdaQuery().eq(TpmDaySales::getCustomer, vo.getCustomer())
                .eq(TpmDaySales::getGoodsCode, vo.getGoodsCode())
                .eq(TpmDaySales::getTradeDate, vo.getTradeDate())
                .eq(TpmDaySales::getBusinessFormatCode, vo.getBusinessFormatCode())
                .eq(TpmDaySales::getChannelCode, vo.getChannelCode())
                .eq(TpmDaySales::getSalesInstitutionCode, vo.getSalesInstitutionCode())
                .select(TpmDaySales::getId).list();
    }

    public BigDecimal getDaySalesTotalAmount(TpmDaySalesSearchDto daySalesSearch) {

        BigDecimal daySalesTotalAmount = this.baseMapper.getDaySalesTotalAmount(daySalesSearch);

        return daySalesTotalAmount != null ? daySalesTotalAmount : BigDecimal.ZERO;
    }

    public void deleteByVerifyCode(List<String> verifyCodes) {
        this.baseMapper.delete(Wrappers.lambdaQuery(TpmDaySales.class).in(TpmDaySales::getVerifyCode, verifyCodes));
    }

    public List<TpmDaySalesVo> getDataFromPromotionPlan(TpmDaySalesSearchDto dto) {
        return baseMapper.getDataFromPromotionPlan(dto);
    }

    public void removeByYearMonth(String yearMonth) {
        if (StringUtils.isEmpty(yearMonth)) {
            return;
        }
        this.lambdaUpdate()
                .eq(TpmDaySales::getYearMonthLy, yearMonth)
                .remove();
    }
}

