package com.biz.crm.tpm.business.day.sales.local.repository;


import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.biz.crm.business.common.sdk.enums.DelFlagStatusEnum;
import com.biz.crm.tpm.business.day.sales.local.entity.TpmDaySalesSplice;
import com.biz.crm.tpm.business.day.sales.sdk.dto.TpmDaySalesSpliceDto;
import com.biz.crm.tpm.business.day.sales.sdk.dto.TpmDaySalesSpliceSearchDto;
import com.biz.crm.tpm.business.day.sales.local.mapper.TpmDaySalesSpliceMapper;
import com.biz.crm.tpm.business.day.sales.sdk.vo.TpmDaySalesSpliceVo;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import jodd.util.StringUtil;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import org.springframework.data.domain.PageRequest;
import org.springframework.stereotype.Component;
import org.springframework.data.domain.Pageable;

import java.math.BigDecimal;
import java.util.*;


/**
 * 日销售数据拆分明细实体类(TpmDaySalesSplice)表数据库访问层
 *
 * @author yaoyongming
 * @since 2022-10-27 16:51:00
 */
@Component
public class TpmDaySalesSpliceRepository extends ServiceImpl<TpmDaySalesSpliceMapper, TpmDaySalesSplice> {

    @Autowired
    private TpmDaySalesSpliceMapper tpmDaySalesSpliceMapper;

    /**
     * 分页查询数据
     *
     * @param pageable          分页对象
     * @param tpmDaySalesSplice DTO对象
     * @return
     */
    public Page<TpmDaySalesSpliceVo> findByConditions(Pageable pageable, TpmDaySalesSpliceSearchDto tpmDaySalesSplice) {
        Page<TpmDaySalesSpliceVo> page = new Page<>(pageable.getPageNumber(), pageable.getPageSize());
        Page<TpmDaySalesSpliceVo> pageList = this.tpmDaySalesSpliceMapper.findByConditions(page, tpmDaySalesSplice);
        return pageList;
    }

    /**
     * 查询是否存在数据并返回存在数据的id
     *
     * @param vo
     * @return
     */
    public List<TpmDaySalesSplice> findOnCreate(TpmDaySalesSpliceVo vo) {
        return this.lambdaQuery().eq(TpmDaySalesSplice::getCustomer, vo.getCustomer())
                .eq(TpmDaySalesSplice::getGoodsCode, vo.getGoodsCode())
                .eq(TpmDaySalesSplice::getGoodsName, vo.getGoodsName())
                .eq(TpmDaySalesSplice::getTradeDate, vo.getTradeDate())
                .eq(TpmDaySalesSplice::getActivityForm, vo.getActivityForm())
                .eq(TpmDaySalesSplice::getChannel, vo.getChannel())
                .select(TpmDaySalesSplice::getId).list();
    }

    /**
     * 获取GMV
     *
     * @param vo
     * @return
     */
    public BigDecimal getGmv(TpmDaySalesSpliceVo vo) {
        QueryWrapper<TpmDaySalesSplice> queryWrapper = new QueryWrapper<>();
        Calendar calendar = new GregorianCalendar();
        calendar.setTime(vo.getEndDate());
        calendar.add(Calendar.DATE, 1);
        queryWrapper.eq("del_flag", DelFlagStatusEnum.NORMAL.getCode())
                .eq("customer", vo.getCustomer())
                .eq(StringUtils.isNotEmpty(vo.getGoodsCode()), "goods_code", vo.getGoodsCode())
                .eq("activity_form", vo.getActivityForm())
                .eq("channel", vo.getChannel())
                .ge("trade_date", vo.getStartDate())
                .lt("trade_date", calendar.getTime())
                .select("IFNULL(sum(amount),0) as total");
        Map<String, Object> map = this.getMap(queryWrapper);
        return (BigDecimal) map.get("total");
    }

    /**
     * 根据年月查询
     *
     * @param pageable
     * @return
     */
    public Page<TpmDaySalesSpliceVo> findByYearAndMonth(Pageable pageable, TpmDaySalesSpliceDto dto) {
        pageable = Optional.ofNullable(pageable).orElse(PageRequest.of(1, 200));
        dto = Optional.ofNullable(dto).orElse(new TpmDaySalesSpliceDto());
        if (StringUtil.isEmpty(dto.getTenantCode())) {
            dto.setTenantCode(TenantUtils.getTenantCode());
        }
        Page<TpmDaySalesSpliceVo> page = new Page<>(pageable.getPageNumber(), pageable.getPageSize());
        return this.tpmDaySalesSpliceMapper.findByYearAndMonth(page, dto);
    }

    public List<TpmDaySalesSpliceVo> getByCustomerAndProduct(String yearMonthLy, String customer, String goodsCode) {
        if (StringUtil.isEmpty(yearMonthLy)
                || StringUtil.isEmpty(customer)
                || StringUtil.isEmpty(goodsCode)) {
            return Collections.emptyList();
        }
        return this.tpmDaySalesSpliceMapper.getByCustomerAndProduct(yearMonthLy, customer, goodsCode, TenantUtils.getTenantCode());
    }
}

