package com.biz.crm.tpm.business.day.sales.local.service.internal;


import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.text.CharSequenceUtil;
import cn.hutool.core.util.ObjectUtil;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.mdm.business.customer.sdk.service.CustomerVoService;
import com.biz.crm.mdm.business.customer.sdk.vo.CustomerVo;
import com.biz.crm.mdm.business.product.sdk.service.ProductVoService;
import com.biz.crm.mdm.business.product.sdk.vo.ProductVo;
import com.biz.crm.mn.common.base.service.RedisLockService;
import com.biz.crm.tpm.business.day.sales.local.service.CeSalesDataService;
import com.biz.crm.tpm.business.day.sales.sdk.constants.DaySalesConstants;
import com.biz.crm.tpm.business.day.sales.sdk.service.TpmDaySalesService;
import com.biz.crm.tpm.business.day.sales.sdk.vo.TpmDaySalesVo;
import com.biz.crm.tpm.business.third.system.sdk.service.Ce1MnjtSdkService;
import com.biz.crm.tpm.business.third.system.sdk.vo.Ce1MnjtFullVo2;
import com.google.common.collect.Maps;
import liquibase.util.StringUtil;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.compress.utils.Lists;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.scheduling.annotation.Async;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.Assert;

import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;

/**
 * 平台销售数据接受到日销售数据
 *
 * @author: huxmld
 * @version: v1.0.0
 * @date: 2023-12-19 13:58
 */
@Slf4j
@Service
public class CeSalesDataServiceImpl implements CeSalesDataService {

    @Autowired(required = false)
    private Ce1MnjtSdkService ce1MnjtSdkService;

    @Autowired(required = false)
    private TpmDaySalesService daySalesService;

    @Autowired(required = false)
    private CustomerVoService customerVoService;

    @Autowired(required = false)
    private ProductVoService productVoService;

    @Autowired(required = false)
    private RedisLockService redisLockService;

    private static final String BUSINESS_MODEL_CODE = "self_operated_mode";


    /**
     * 平台销售数据接受到日销售数据
     *
     * @param ds yyyy-MM
     * @return void
     * @author: huxmld
     * @version: v1.0.0
     * @date: 2023-12-19 13:55
     */
    @Override
    @Async
    @Transactional(propagation = Propagation.NOT_SUPPORTED, rollbackFor = Exception.class)
    public void syncSalesData(String ds) {
        log.info("=====>    平台销售数据接受到日销售数据[{}] start    <=====", ds);
        if (StringUtils.isEmpty(ds)) {
            return;
        }
        String daySaleLock = DaySalesConstants.TPM_DAY_SALES_LOCK + ds;
        boolean lockSuccess = redisLockService.tryLock(daySaleLock, TimeUnit.HOURS, 2);
        if (!lockSuccess) {
            log.error("=====>    平台销售数据接受到日销售数据[{}] 上次同步未完成本次不更新!    <=====", ds);
        }
        Assert.isTrue(lockSuccess, "平台销售数据接受到日销售数据消费中!");
        SimpleDateFormat sdf = new SimpleDateFormat("yyyyMMdd");
        Pageable pageable = PageRequest.of(1, 600);
        //查询日销售数据
        Page<Ce1MnjtFullVo2> resultPage = null;
        List<String> verifyCodeList = Lists.newArrayList();
        List<Ce1MnjtFullVo2> resultList = null;
        try {
            do {
                resultPage = this.ce1MnjtSdkService.findDataPage(pageable, ds);
                log.info("=====>    平台销售数据接受到日销售数据[{}] [{}/{}]  每页[{}]  <=====", ds,
                        resultPage.getCurrent(), resultPage.getPages(), resultPage.getSize());
                pageable = pageable.next();
                if (CollectionUtil.isEmpty(resultPage.getRecords())) {
                    return;
                }
                resultList = resultPage.getRecords();
                Set<String> customerCodeSet = resultList.stream().filter(k -> StringUtil.isNotEmpty(k.getTpmCustomerCode()))
                        .map(Ce1MnjtFullVo2::getTpmCustomerCode).collect(Collectors.toSet());
                Map<String, CustomerVo> customerVoMap = Maps.newHashMap();
                if (CollectionUtils.isNotEmpty(customerCodeSet)) {
                    List<CustomerVo> customerVos = customerVoService.findCustomerAndContactByCustomerCodes(new ArrayList<>(customerCodeSet));
                    if (CollectionUtil.isNotEmpty(customerVos)) {
                        customerVoMap.putAll(customerVos.stream().collect(Collectors.toMap(CustomerVo::getCustomerCode, v -> v, (n, o) -> n)));
                    }
                }
                Set<String> productCodeSet = resultList.stream().filter(k -> StringUtil.isNotEmpty(k.getProductCode()))
                        .map(Ce1MnjtFullVo2::getProductCode).collect(Collectors.toSet());
                Map<String, ProductVo> productVoMap = Maps.newHashMap();
                if (CollectionUtils.isNotEmpty(productCodeSet)) {
                    List<ProductVo> productVoList = productVoService.findByProductCodes(new ArrayList<>(productCodeSet));
                    if (CollectionUtil.isNotEmpty(productVoList)) {
                        productVoMap.putAll(productVoList.stream().collect(Collectors.toMap(ProductVo::getProductCode, v -> v, (n, o) -> n)));
                    }
                }
                List<TpmDaySalesVo> daySalesVos = new ArrayList<>();
                for (Ce1MnjtFullVo2 ce1MnjtFullVo2 : resultList) {
                    CustomerVo customerVo = customerVoMap.get(ce1MnjtFullVo2.getTpmCustomerCode());
                    if (ObjectUtil.isNull(customerVo)) {
                        continue;
                    }
                    if (!CharSequenceUtil.equals(BUSINESS_MODEL_CODE, customerVo.getBusinessModelCode())) {
                        continue;
                    }
                    TpmDaySalesVo tpmDaySalesVo = new TpmDaySalesVo();
                    tpmDaySalesVo.setCustomer(ce1MnjtFullVo2.getCustomerCode());
                    tpmDaySalesVo.setTradeDate(sdf.parse(ce1MnjtFullVo2.getPostDate()));
                    tpmDaySalesVo.setGoodsCode(ce1MnjtFullVo2.getProductCode());
                    ProductVo productVo = productVoMap.get(ce1MnjtFullVo2.getProductCode());
                    tpmDaySalesVo.setGoodsName(ObjectUtil.isNotNull(productVo) ? productVo.getProductName() : "");
                    tpmDaySalesVo.setAmount(ce1MnjtFullVo2.getSalesVolumes());
                    tpmDaySalesVo.setNum(new BigDecimal(ce1MnjtFullVo2.getSalesIncludingTaxNet()));

                    String verifyCode = ce1MnjtFullVo2.getSaleOrgCode() +
                            ce1MnjtFullVo2.getDistributionChannelCode() +
                            ce1MnjtFullVo2.getProductTeamCode() +
                            ce1MnjtFullVo2.getCustomerCode() +
                            ce1MnjtFullVo2.getProductCode() +
                            ce1MnjtFullVo2.getPostDate() +
                            tpmDaySalesVo.getTradeDate();

                    tpmDaySalesVo.setVerifyCode(verifyCode);
                    verifyCodeList.add(verifyCode);
                    daySalesVos.add(tpmDaySalesVo);
                }
                //先去除重复的，再新增
                this.daySalesService.deleteByVerifyCodes(verifyCodeList);
                daySalesService.batchSave(daySalesVos);
                verifyCodeList.clear();
            } while (resultPage.hasNext());
        } catch (Exception e) {
            log.error("=====>    平台销售数据接受到日销售数据异常[{}]     <=====", ds);
            log.error("", e);
        } finally {
            log.info("=====>    平台销售数据接受到日销售数据[{}] end    <=====", ds);
            redisLockService.unlock(daySaleLock);
        }
    }
}

