/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.tpm.business.day.sales.local.controller;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.business.common.sdk.model.Result;
import com.biz.crm.business.common.sdk.service.LoginUserService;
import com.biz.crm.mn.common.base.service.RedisLockService;
import com.biz.crm.mn.common.base.util.DateUtil;
import com.biz.crm.tpm.business.day.sales.sdk.dto.TpmDaySalesSearchDto;
import com.biz.crm.tpm.business.day.sales.sdk.dto.TpmDaySalesSpliceDto;
import com.biz.crm.tpm.business.day.sales.sdk.service.TpmDaySalesService;
import com.biz.crm.tpm.business.day.sales.sdk.vo.TpmDaySalesVo;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import java.util.Date;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Pageable;
import org.springframework.data.web.PageableDefault;
import org.springframework.util.Assert;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PatchMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/v1/tpmDaySales"})
@Api(tags={"\u65e5\u9500\u552e\u6570\u636e\u7ba1\u7406"})
public class TpmDaySalesController {
    private static final Logger log = LoggerFactory.getLogger(TpmDaySalesController.class);
    @Autowired(required=false)
    private TpmDaySalesService tpmDaySalesService;
    @Autowired(required=false)
    private LoginUserService loginUserService;
    @Autowired(required=false)
    private RedisLockService redisLockService;

    @ApiOperation(value="\u5206\u9875\u67e5\u8be2\u6240\u6709\u6570\u636e")
    @GetMapping(value={"findByConditions"})
    public Result<Page<TpmDaySalesVo>> findByConditions(@ApiParam(name="pageable", value="\u5206\u9875\u5bf9\u8c61") @PageableDefault(value=50) Pageable pageable, @ApiParam(name="tpmDaySales", value="\u65e5\u9500\u552e\u6570\u636eDTO") TpmDaySalesSearchDto tpmDaySales) {
        try {
            Page page = this.tpmDaySalesService.findByConditions(pageable, tpmDaySales);
            return Result.ok((Object)page);
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    @ApiOperation(value="\u67e5\u8be2\u6240\u6709\u6570\u636e")
    @PostMapping(value={"findByConditionsNoPage"})
    public Result<List<TpmDaySalesVo>> findByConditionsNoPage(@ApiParam(name="tpmDaySales", value="\u65e5\u9500\u552e\u6570\u636eDTO") @RequestBody TpmDaySalesSearchDto tpmDaySales) {
        try {
            return Result.ok((Object)this.tpmDaySalesService.findByConditionsNoPage(tpmDaySales));
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    @ApiOperation(value="\u901a\u8fc7\u4e3b\u952e\u5217\u8868\u67e5\u8be2\u591a\u6761\u6570\u636e")
    @PatchMapping(value={"findByIdList"})
    public Result<?> findByIdList(@ApiParam(name="idList", value="\u4e3b\u952e\u5217\u8868") @RequestBody List<String> idList) {
        try {
            List tpmDaySales = this.tpmDaySalesService.findByIdList(idList);
            return Result.ok((Object)tpmDaySales);
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    @ApiOperation(value="\u62c6\u5206")
    @PostMapping(value={"splice"})
    public Result<?> splice(@ApiParam(name="dto", value="\u65e5\u9500\u552e\u62c6\u5206DTO") @RequestBody TpmDaySalesSpliceDto dto) {
        try {
            this.tpmDaySalesService.splice(dto);
            return Result.ok();
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    @ApiOperation(value="\u6279\u91cf\u62c6\u5206")
    @PostMapping(value={"spliceBatch"})
    public Result<?> spliceBatch(@ApiParam(name="dtoList", value="\u65e5\u9500\u552e\u62c6\u5206DTO\u5217\u8868") @RequestBody List<TpmDaySalesSpliceDto> dtoList) {
        try {
            this.tpmDaySalesService.spliceBatch(dtoList);
            return Result.ok();
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    @ApiOperation(value="\u65b0\u589e\u6570\u636e")
    @PostMapping
    public Result<?> create(@ApiParam(name="tpmDaySalesVo", value="\u65e5\u9500\u552e\u6570\u636e") @RequestBody TpmDaySalesVo tpmDaySalesVo) {
        try {
            this.tpmDaySalesService.create(tpmDaySalesVo);
            return Result.ok();
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    @ApiOperation(value="\u540c\u6b65\u6307\u5b9a\u6708\u4efd\u9500\u552e\u6570\u636e")
    @GetMapping(value={"/getSalesData"})
    public Result<?> getSalesData(@RequestParam(value="yearMonth") String yearMonth) {
        try {
            Assert.hasLength((String)yearMonth, (String)"\u5e74\u6708\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a!");
            try {
                Date date = DateUtil.date_yyyy_MM.parse(yearMonth);
                Assert.isTrue((boolean)yearMonth.equals(DateUtil.date_yyyy_MM.format(date)), (String)"\u5e74\u6708\u683c\u5f0f\u9519\u8bef\u3010yyyy-MM\u3011");
            }
            catch (Exception e) {
                throw new IllegalArgumentException("\u5e74\u6708\u683c\u5f0f\u9519\u8bef\u3010yyyy-MM\u3011");
            }
            boolean isLock = this.redisLockService.isLock("tpm:sales_data:lock:");
            Assert.isTrue((!isLock ? 1 : 0) != 0, (String)"\u5176\u4ed6\u4eba\u6b63\u5728\u64cd\u4f5c\u6570\u636e,\u52a0\u9501\u5931\u8d25,\u8bf7\u7a0d\u540e\u91cd\u8bd5!");
            this.tpmDaySalesService.getSalesData(yearMonth, this.loginUserService.getAbstractLoginUser());
            return Result.ok();
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    @ApiOperation(value="\u5220\u9664\u6570\u636e")
    @DeleteMapping
    public Result<?> delete(@ApiParam(name="ids", value="\u4e3b\u952e\u96c6\u5408") @RequestParam(value="ids") List<String> ids) {
        try {
            this.tpmDaySalesService.delete(ids);
            return Result.ok();
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }
}

