/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.tpm.business.day.sales.local.controller;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.business.common.sdk.model.Result;
import com.biz.crm.tpm.business.day.sales.sdk.dto.TpmDaySalesSpliceSearchDto;
import com.biz.crm.tpm.business.day.sales.sdk.service.TpmDaySalesSpliceService;
import com.biz.crm.tpm.business.day.sales.sdk.vo.TpmDaySalesSpliceVo;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import java.math.BigDecimal;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Pageable;
import org.springframework.data.web.PageableDefault;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/v1/tpmDaySalesSplice"})
@Api(tags={"\u65e5\u9500\u552e\u6570\u636e\u7ba1\u7406\uff08\u62c6\u5206\u660e\u7ec6\uff09"})
public class TpmDaySalesSpliceController {
    private static final Logger log = LoggerFactory.getLogger(TpmDaySalesSpliceController.class);
    @Autowired
    private TpmDaySalesSpliceService tpmDaySalesSpliceService;

    @ApiOperation(value="\u5206\u9875\u67e5\u8be2\u6240\u6709\u6570\u636e")
    @GetMapping(value={"findByConditions"})
    public Result<Page<TpmDaySalesSpliceVo>> findByConditions(@ApiParam(name="pageable", value="\u5206\u9875\u5bf9\u8c61") @PageableDefault(value=50) Pageable pageable, @ApiParam(name="tpmDaySalesSplice", value="\u65e5\u9500\u552e\u6570\u636e\u62c6\u5206\u660e\u7ec6DTO") TpmDaySalesSpliceSearchDto tpmDaySalesSplice) {
        try {
            Page page = this.tpmDaySalesSpliceService.findByConditions(pageable, tpmDaySalesSplice);
            return Result.ok((Object)page);
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    @ApiOperation(value="\u65b0\u589e\u6570\u636e")
    @PostMapping
    public Result<?> create(@ApiParam(name="tpmDaySalesVo", value="\u65e5\u9500\u552e\u6570\u636e\u7ba1\u7406\uff08\u62c6\u5206\u660e\u7ec6\uff09") @RequestBody TpmDaySalesSpliceVo tpmDaySalesVo) {
        try {
            this.tpmDaySalesSpliceService.create(tpmDaySalesVo);
            return Result.ok();
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    @ApiOperation(value="\u83b7\u53d6GMV")
    @PostMapping(value={"getGmv"})
    public Result<?> getGmv(@ApiParam(name="tpmDaySalesVo", value="\u65e5\u9500\u552e\u6570\u636e\u7ba1\u7406\uff08\u62c6\u5206\u660e\u7ec6\uff09") @RequestBody TpmDaySalesSpliceVo tpmDaySalesVo) {
        try {
            BigDecimal gmv = this.tpmDaySalesSpliceService.getGmv(tpmDaySalesVo);
            return Result.ok((Object)gmv);
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    @ApiOperation(value="\u5220\u9664\u6570\u636e")
    @DeleteMapping
    public Result<?> delete(@ApiParam(name="ids", value="\u4e3b\u952e\u96c6\u5408") @RequestParam(value="ids") List<String> ids) {
        try {
            this.tpmDaySalesSpliceService.delete(ids);
            return Result.ok();
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }
}

