/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.tpm.business.day.sales.local.repository;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.core.toolkit.support.SFunction;
import com.baomidou.mybatisplus.extension.conditions.query.LambdaQueryChainWrapper;
import com.baomidou.mybatisplus.extension.conditions.update.LambdaUpdateChainWrapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.business.common.local.entity.UuidEntity;
import com.biz.crm.tpm.business.day.sales.local.entity.TpmDaySales;
import com.biz.crm.tpm.business.day.sales.local.mapper.TpmDaySalesMapper;
import com.biz.crm.tpm.business.day.sales.sdk.dto.TpmDaySalesSearchDto;
import com.biz.crm.tpm.business.day.sales.sdk.vo.TpmDaySalesVo;
import java.math.BigDecimal;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Component;

@Component
public class TpmDaySalesRepository
extends ServiceImpl<TpmDaySalesMapper, TpmDaySales> {
    @Autowired
    private TpmDaySalesMapper tpmDaySalesMapper;

    public Page<TpmDaySalesVo> findByConditions(Pageable pageable, TpmDaySalesSearchDto tpmDaySales) {
        Page page = new Page((long)pageable.getPageNumber(), (long)pageable.getPageSize());
        Page<TpmDaySalesVo> pageList = this.tpmDaySalesMapper.findByConditions((Page<TpmDaySalesVo>)page, tpmDaySales);
        return pageList;
    }

    public List<TpmDaySalesVo> findByConditionsNoPage(TpmDaySalesSearchDto tpmDaySales) {
        return this.tpmDaySalesMapper.findByConditionsNoPage(tpmDaySales);
    }

    public List<TpmDaySalesVo> findByConditionsNoPage2(TpmDaySalesSearchDto tpmDaySales) {
        return this.tpmDaySalesMapper.findByConditionsNoPage2(tpmDaySales);
    }

    public List<TpmDaySales> findByIdList(List<String> idList) {
        return ((LambdaQueryChainWrapper)this.lambdaQuery().in(UuidEntity::getId, idList)).list();
    }

    public List<TpmDaySales> findOnCreate(TpmDaySalesVo vo) {
        return ((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.lambdaQuery().eq(TpmDaySales::getCustomer, (Object)vo.getCustomer())).eq(TpmDaySales::getGoodsCode, (Object)vo.getGoodsCode())).eq(TpmDaySales::getTradeDate, (Object)vo.getTradeDate())).eq(TpmDaySales::getBusinessFormatCode, (Object)vo.getBusinessFormatCode())).eq(TpmDaySales::getChannelCode, (Object)vo.getChannelCode())).eq(TpmDaySales::getSalesInstitutionCode, (Object)vo.getSalesInstitutionCode())).select(new SFunction[]{UuidEntity::getId}).list();
    }

    public BigDecimal getDaySalesTotalAmount(TpmDaySalesSearchDto daySalesSearch) {
        BigDecimal daySalesTotalAmount = ((TpmDaySalesMapper)this.baseMapper).getDaySalesTotalAmount(daySalesSearch);
        return daySalesTotalAmount != null ? daySalesTotalAmount : BigDecimal.ZERO;
    }

    public void deleteByVerifyCode(List<String> verifyCodes) {
        ((TpmDaySalesMapper)this.baseMapper).delete((Wrapper)Wrappers.lambdaQuery(TpmDaySales.class).in(TpmDaySales::getVerifyCode, verifyCodes));
    }

    public List<TpmDaySalesVo> getDataFromPromotionPlan(TpmDaySalesSearchDto dto) {
        return ((TpmDaySalesMapper)this.baseMapper).getDataFromPromotionPlan(dto);
    }

    public void removeByYearMonth(String yearMonth) {
        if (StringUtils.isEmpty((CharSequence)yearMonth)) {
            return;
        }
        ((LambdaUpdateChainWrapper)this.lambdaUpdate().eq(TpmDaySales::getYearMonthLy, (Object)yearMonth)).remove();
    }
}

