/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.tpm.business.day.sales.local.repository;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.support.SFunction;
import com.baomidou.mybatisplus.extension.conditions.query.LambdaQueryChainWrapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.business.common.local.entity.UuidEntity;
import com.biz.crm.business.common.sdk.enums.DelFlagStatusEnum;
import com.biz.crm.tpm.business.day.sales.local.entity.TpmDaySalesSplice;
import com.biz.crm.tpm.business.day.sales.local.mapper.TpmDaySalesSpliceMapper;
import com.biz.crm.tpm.business.day.sales.sdk.dto.TpmDaySalesSpliceDto;
import com.biz.crm.tpm.business.day.sales.sdk.dto.TpmDaySalesSpliceSearchDto;
import com.biz.crm.tpm.business.day.sales.sdk.vo.TpmDaySalesSpliceVo;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import java.math.BigDecimal;
import java.util.Calendar;
import java.util.Collections;
import java.util.GregorianCalendar;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import jodd.util.StringUtil;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Component;

@Component
public class TpmDaySalesSpliceRepository
extends ServiceImpl<TpmDaySalesSpliceMapper, TpmDaySalesSplice> {
    @Autowired
    private TpmDaySalesSpliceMapper tpmDaySalesSpliceMapper;

    public Page<TpmDaySalesSpliceVo> findByConditions(Pageable pageable, TpmDaySalesSpliceSearchDto tpmDaySalesSplice) {
        Page page = new Page((long)pageable.getPageNumber(), (long)pageable.getPageSize());
        Page<TpmDaySalesSpliceVo> pageList = this.tpmDaySalesSpliceMapper.findByConditions((Page<TpmDaySalesSpliceVo>)page, tpmDaySalesSplice);
        return pageList;
    }

    public List<TpmDaySalesSplice> findOnCreate(TpmDaySalesSpliceVo vo) {
        return ((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.lambdaQuery().eq(TpmDaySalesSplice::getCustomer, (Object)vo.getCustomer())).eq(TpmDaySalesSplice::getGoodsCode, (Object)vo.getGoodsCode())).eq(TpmDaySalesSplice::getGoodsName, (Object)vo.getGoodsName())).eq(TpmDaySalesSplice::getTradeDate, (Object)vo.getTradeDate())).eq(TpmDaySalesSplice::getActivityForm, (Object)vo.getActivityForm())).eq(TpmDaySalesSplice::getChannel, (Object)vo.getChannel())).select(new SFunction[]{UuidEntity::getId}).list();
    }

    public BigDecimal getGmv(TpmDaySalesSpliceVo vo) {
        QueryWrapper queryWrapper = new QueryWrapper();
        GregorianCalendar calendar = new GregorianCalendar();
        calendar.setTime(vo.getEndDate());
        ((Calendar)calendar).add(5, 1);
        ((QueryWrapper)((QueryWrapper)((QueryWrapper)((QueryWrapper)((QueryWrapper)((QueryWrapper)((QueryWrapper)queryWrapper.eq((Object)"del_flag", (Object)DelFlagStatusEnum.NORMAL.getCode())).eq((Object)"customer", (Object)vo.getCustomer())).eq(StringUtils.isNotEmpty((CharSequence)vo.getGoodsCode()), (Object)"goods_code", (Object)vo.getGoodsCode())).eq((Object)"activity_form", (Object)vo.getActivityForm())).eq((Object)"channel", (Object)vo.getChannel())).ge((Object)"trade_date", (Object)vo.getStartDate())).lt((Object)"trade_date", (Object)calendar.getTime())).select(new String[]{"IFNULL(sum(amount),0) as total"});
        Map map = this.getMap((Wrapper)queryWrapper);
        return (BigDecimal)map.get("total");
    }

    public Page<TpmDaySalesSpliceVo> findByYearAndMonth(Pageable pageable, TpmDaySalesSpliceDto dto) {
        pageable = Optional.ofNullable(pageable).orElse((Pageable)PageRequest.of((int)1, (int)200));
        if (StringUtil.isEmpty((CharSequence)(dto = Optional.ofNullable(dto).orElse(new TpmDaySalesSpliceDto())).getTenantCode())) {
            dto.setTenantCode(TenantUtils.getTenantCode());
        }
        Page page = new Page((long)pageable.getPageNumber(), (long)pageable.getPageSize());
        return this.tpmDaySalesSpliceMapper.findByYearAndMonth((Page<TpmDaySalesSpliceVo>)page, dto);
    }

    public List<TpmDaySalesSpliceVo> getByCustomerAndProduct(String yearMonthLy, String customer, String goodsCode) {
        if (StringUtil.isEmpty((CharSequence)yearMonthLy) || StringUtil.isEmpty((CharSequence)customer) || StringUtil.isEmpty((CharSequence)goodsCode)) {
            return Collections.emptyList();
        }
        return this.tpmDaySalesSpliceMapper.getByCustomerAndProduct(yearMonthLy, customer, goodsCode, TenantUtils.getTenantCode());
    }
}

