/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.tpm.business.day.sales.local.service.internal;

import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.text.CharSequenceUtil;
import cn.hutool.core.util.ObjectUtil;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.mdm.business.customer.sdk.service.CustomerVoService;
import com.biz.crm.mdm.business.customer.sdk.vo.CustomerVo;
import com.biz.crm.mdm.business.product.sdk.service.ProductVoService;
import com.biz.crm.mdm.business.product.sdk.vo.ProductVo;
import com.biz.crm.mn.common.base.service.RedisLockService;
import com.biz.crm.tpm.business.day.sales.local.service.CeSalesDataService;
import com.biz.crm.tpm.business.day.sales.sdk.service.TpmDaySalesService;
import com.biz.crm.tpm.business.day.sales.sdk.vo.TpmDaySalesVo;
import com.biz.crm.tpm.business.third.system.sdk.service.Ce1MnjtSdkService;
import com.biz.crm.tpm.business.third.system.sdk.vo.Ce1MnjtFullVo2;
import com.google.common.collect.Maps;
import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import liquibase.util.StringUtil;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.compress.utils.Lists;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.scheduling.annotation.Async;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.Assert;

@Service
public class CeSalesDataServiceImpl
implements CeSalesDataService {
    private static final Logger log = LoggerFactory.getLogger(CeSalesDataServiceImpl.class);
    @Autowired(required=false)
    private Ce1MnjtSdkService ce1MnjtSdkService;
    @Autowired(required=false)
    private TpmDaySalesService daySalesService;
    @Autowired(required=false)
    private CustomerVoService customerVoService;
    @Autowired(required=false)
    private ProductVoService productVoService;
    @Autowired(required=false)
    private RedisLockService redisLockService;
    private static final String BUSINESS_MODEL_CODE = "self_operated_mode";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Async
    @Transactional(propagation=Propagation.NOT_SUPPORTED, rollbackFor={Exception.class})
    public void syncSalesData(String ds) {
        log.info("=====>    \u5e73\u53f0\u9500\u552e\u6570\u636e\u63a5\u53d7\u5230\u65e5\u9500\u552e\u6570\u636e[{}] start    <=====", (Object)ds);
        if (StringUtils.isEmpty((CharSequence)ds)) {
            return;
        }
        String daySaleLock = "tpm:day_sales:lock:" + ds;
        boolean lockSuccess = this.redisLockService.tryLock(daySaleLock, TimeUnit.HOURS, 2L);
        if (!lockSuccess) {
            log.error("=====>    \u5e73\u53f0\u9500\u552e\u6570\u636e\u63a5\u53d7\u5230\u65e5\u9500\u552e\u6570\u636e[{}] \u4e0a\u6b21\u540c\u6b65\u672a\u5b8c\u6210\u672c\u6b21\u4e0d\u66f4\u65b0!    <=====", (Object)ds);
        }
        Assert.isTrue((boolean)lockSuccess, (String)"\u5e73\u53f0\u9500\u552e\u6570\u636e\u63a5\u53d7\u5230\u65e5\u9500\u552e\u6570\u636e\u6d88\u8d39\u4e2d!");
        SimpleDateFormat sdf = new SimpleDateFormat("yyyyMMdd");
        PageRequest pageable = PageRequest.of((int)1, (int)600);
        Page resultPage = null;
        ArrayList verifyCodeList = Lists.newArrayList();
        List resultList = null;
        try {
            do {
                List productVoList;
                List customerVos;
                resultPage = this.ce1MnjtSdkService.findDataPage((Pageable)pageable, ds);
                log.info("=====>    \u5e73\u53f0\u9500\u552e\u6570\u636e\u63a5\u53d7\u5230\u65e5\u9500\u552e\u6570\u636e[{}] [{}/{}]  \u6bcf\u9875[{}]  <=====", new Object[]{ds, resultPage.getCurrent(), resultPage.getPages(), resultPage.getSize()});
                pageable = pageable.next();
                if (CollectionUtil.isEmpty((Collection)resultPage.getRecords())) {
                    return;
                }
                resultList = resultPage.getRecords();
                Set customerCodeSet = resultList.stream().filter(k -> StringUtil.isNotEmpty((String)k.getTpmCustomerCode())).map(Ce1MnjtFullVo2::getTpmCustomerCode).collect(Collectors.toSet());
                HashMap customerVoMap = Maps.newHashMap();
                if (CollectionUtils.isNotEmpty(customerCodeSet) && CollectionUtil.isNotEmpty((Collection)(customerVos = this.customerVoService.findCustomerAndContactByCustomerCodes(new ArrayList(customerCodeSet))))) {
                    customerVoMap.putAll(customerVos.stream().collect(Collectors.toMap(CustomerVo::getCustomerCode, v -> v, (n, o) -> n)));
                }
                Set productCodeSet = resultList.stream().filter(k -> StringUtil.isNotEmpty((String)k.getProductCode())).map(Ce1MnjtFullVo2::getProductCode).collect(Collectors.toSet());
                HashMap productVoMap = Maps.newHashMap();
                if (CollectionUtils.isNotEmpty(productCodeSet) && CollectionUtil.isNotEmpty((Collection)(productVoList = this.productVoService.findByProductCodes(new ArrayList(productCodeSet))))) {
                    productVoMap.putAll(productVoList.stream().collect(Collectors.toMap(ProductVo::getProductCode, v -> v, (n, o) -> n)));
                }
                ArrayList<TpmDaySalesVo> daySalesVos = new ArrayList<TpmDaySalesVo>();
                for (Ce1MnjtFullVo2 ce1MnjtFullVo2 : resultList) {
                    CustomerVo customerVo = (CustomerVo)customerVoMap.get(ce1MnjtFullVo2.getTpmCustomerCode());
                    if (ObjectUtil.isNull((Object)customerVo) || !CharSequenceUtil.equals((CharSequence)BUSINESS_MODEL_CODE, (CharSequence)customerVo.getBusinessModelCode())) continue;
                    TpmDaySalesVo tpmDaySalesVo = new TpmDaySalesVo();
                    tpmDaySalesVo.setCustomer(ce1MnjtFullVo2.getCustomerCode());
                    tpmDaySalesVo.setTradeDate(sdf.parse(ce1MnjtFullVo2.getPostDate()));
                    tpmDaySalesVo.setGoodsCode(ce1MnjtFullVo2.getProductCode());
                    ProductVo productVo = (ProductVo)productVoMap.get(ce1MnjtFullVo2.getProductCode());
                    tpmDaySalesVo.setGoodsName(ObjectUtil.isNotNull((Object)productVo) ? productVo.getProductName() : "");
                    tpmDaySalesVo.setAmount(ce1MnjtFullVo2.getSalesVolumes());
                    tpmDaySalesVo.setNum(new BigDecimal(ce1MnjtFullVo2.getSalesIncludingTaxNet()));
                    String verifyCode = ce1MnjtFullVo2.getSaleOrgCode() + ce1MnjtFullVo2.getDistributionChannelCode() + ce1MnjtFullVo2.getProductTeamCode() + ce1MnjtFullVo2.getCustomerCode() + ce1MnjtFullVo2.getProductCode() + ce1MnjtFullVo2.getPostDate() + tpmDaySalesVo.getTradeDate();
                    tpmDaySalesVo.setVerifyCode(verifyCode);
                    verifyCodeList.add(verifyCode);
                    daySalesVos.add(tpmDaySalesVo);
                }
                this.daySalesService.deleteByVerifyCodes((List)verifyCodeList);
                this.daySalesService.batchSave(daySalesVos);
                verifyCodeList.clear();
            } while (resultPage.hasNext());
        }
        catch (Exception e) {
            log.error("=====>    \u5e73\u53f0\u9500\u552e\u6570\u636e\u63a5\u53d7\u5230\u65e5\u9500\u552e\u6570\u636e\u5f02\u5e38[{}]     <=====", (Object)ds);
            log.error("", (Throwable)e);
        }
        finally {
            log.info("=====>    \u5e73\u53f0\u9500\u552e\u6570\u636e\u63a5\u53d7\u5230\u65e5\u9500\u552e\u6570\u636e[{}] end    <=====", (Object)ds);
            this.redisLockService.unlock(daySaleLock);
        }
    }
}

