/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.tpm.business.day.sales.local.service.internal;

import com.biz.crm.common.ie.sdk.excel.process.ImportProcess;
import com.biz.crm.common.ie.sdk.vo.TaskGlobalParamsVo;
import com.biz.crm.mdm.business.customer.channel.sdk.service.CustomerChannelVoService;
import com.biz.crm.mdm.business.customer.channel.sdk.vo.CustomerChannelVo;
import com.biz.crm.mdm.business.customer.sdk.service.CustomerVoService;
import com.biz.crm.mdm.business.customer.sdk.vo.CustomerVo;
import com.biz.crm.mdm.business.dictionary.sdk.service.DictDataVoService;
import com.biz.crm.mdm.business.dictionary.sdk.vo.DictDataVo;
import com.biz.crm.mdm.business.product.sdk.service.ProductVoService;
import com.biz.crm.mdm.business.product.sdk.vo.ProductVo;
import com.biz.crm.mdm.business.sales.org.sdk.service.SalesOrgVoService;
import com.biz.crm.mdm.business.sales.org.sdk.vo.SalesOrgVo;
import com.biz.crm.tpm.business.day.sales.sdk.service.TpmDaySalesService;
import com.biz.crm.tpm.business.day.sales.sdk.vo.DaySalesImportVo;
import com.biz.crm.tpm.business.day.sales.sdk.vo.TpmDaySalesVo;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;

@Component
public class DaySalesImportsProcess
implements ImportProcess<DaySalesImportVo> {
    private static final Logger log = LoggerFactory.getLogger(DaySalesImportsProcess.class);
    @Autowired(required=false)
    private NebulaToolkitService nebulaToolkitService;
    @Autowired(required=false)
    private TpmDaySalesService tpmDaySalesService;
    @Autowired(required=false)
    private CustomerVoService customerVoService;
    @Autowired(required=false)
    private ProductVoService productVoService;
    @Autowired(required=false)
    private CustomerChannelVoService customerChannelVoService;
    @Autowired(required=false)
    private DictDataVoService dictDataVoService;
    @Autowired(required=false)
    private SalesOrgVoService salesOrgVoService;
    private static final String MDM_BUSINESS_FORMAT = "mdm_business_format";

    public boolean importBeforeValidationFlag() {
        return Boolean.TRUE;
    }

    public Map<Integer, String> tryVerify(LinkedHashMap<Integer, DaySalesImportVo> data, TaskGlobalParamsVo paramsVo, Map<String, Object> params) {
        HashMap<Integer, String> errMap = new HashMap<Integer, String>();
        for (Map.Entry<Integer, DaySalesImportVo> row : data.entrySet()) {
            int rowNum = row.getKey();
            DaySalesImportVo vo = row.getValue();
            this.validateIsTrue(StringUtils.isNotEmpty((CharSequence)vo.getCustomer()), "\u5ba2\u6237\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a\uff01");
            this.validateIsTrue(StringUtils.isNotEmpty((CharSequence)vo.getGoodsCode()), "\u4ea7\u54c1\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a\uff01");
            this.validateIsTrue(vo.getTradeDate() != null, "\u4ea4\u6613\u65e5\u671f\u4e0d\u80fd\u4e3a\u7a7a\uff01");
            this.validateIsTrue(vo.getAmount() != null, "\u91d1\u989d\u4e0d\u80fd\u4e3a\u7a7a\uff01");
            this.validateIsTrue(vo.getNum() != null, "\u6570\u91cf\u4e0d\u80fd\u4e3a\u7a7a\uff01");
            this.validateIsTrue(StringUtils.isNotEmpty((CharSequence)vo.getSalesInstitutionCode()), "\u9500\u552e\u7ec4\u7ec7\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a\uff01");
            this.validateIsTrue(StringUtils.isNotEmpty((CharSequence)vo.getChannelCode()), "\u6e20\u9053\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a\uff01");
            this.validateIsTrue(StringUtils.isNotEmpty((CharSequence)vo.getBusinessFormatCode()), "\u4e1a\u6001\u4e0d\u80fd\u4e3a\u7a7a\uff01");
            String errInfo = this.validateGetErrorInfo();
            if (errInfo == null) continue;
            errMap.put(rowNum, errInfo);
        }
        return errMap;
    }

    public Map<Integer, String> execute(LinkedHashMap<Integer, DaySalesImportVo> data, TaskGlobalParamsVo paramsVo, Map<String, Object> params) {
        try {
            Validate.notEmpty(data, (String)"\u5bfc\u5165\u6570\u636e\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
            HashMap<Integer, String> errMap = new HashMap<Integer, String>();
            List<TpmDaySalesVo> importList = this.validate(data, errMap);
            if (errMap.isEmpty()) {
                this.tpmDaySalesService.createBatch(importList);
            }
            return errMap;
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            e.printStackTrace();
            throw e;
        }
    }

    private List<TpmDaySalesVo> validate(LinkedHashMap<Integer, DaySalesImportVo> data, Map<Integer, String> errMap) {
        List orgVos;
        List productVoList;
        List customerVos;
        Map<Object, Object> customerVoMap = new HashMap();
        Map<Object, Object> productVoMap = new HashMap();
        Map<Object, Object> orgVoMap = new HashMap();
        Map<Object, Object> channelVoMap = new HashMap();
        HashSet<String> customerCodeSet = new HashSet<String>();
        HashSet<String> productCodeSet = new HashSet<String>();
        HashSet<String> channelCodeSet = new HashSet<String>();
        HashSet<String> orgCodeSet = new HashSet<String>();
        for (DaySalesImportVo dto : data.values()) {
            customerCodeSet.add(dto.getCustomer());
            productCodeSet.add(dto.getGoodsCode());
            channelCodeSet.add(dto.getChannelCode());
            orgCodeSet.add(dto.getSalesInstitutionCode());
        }
        Map dictDataMap = this.dictDataVoService.findByDictTypeCodeList(Arrays.asList(MDM_BUSINESS_FORMAT));
        List channelList = this.customerChannelVoService.findByCodes(new ArrayList(channelCodeSet));
        if (!CollectionUtils.isEmpty((Collection)channelList)) {
            channelVoMap = channelList.stream().collect(Collectors.toMap(e -> e.getCustomerChannelCode(), Function.identity()));
        }
        if (!CollectionUtils.isEmpty((Collection)(customerVos = this.customerVoService.findByCustomerMdgCodes(new ArrayList(customerCodeSet))))) {
            customerVoMap = customerVos.stream().collect(Collectors.groupingBy(e -> e.getErpCode()));
        }
        if (!CollectionUtils.isEmpty((Collection)(productVoList = this.productVoService.findDetailsByIdsOrProductCodes(null, new ArrayList(productCodeSet))))) {
            productVoMap = productVoList.stream().collect(Collectors.toMap(ProductVo::getProductCode, Function.identity()));
        }
        if (org.apache.commons.collections.CollectionUtils.isNotEmpty((Collection)(orgVos = this.salesOrgVoService.findByErpCodeList(new ArrayList(orgCodeSet))))) {
            orgVoMap = orgVos.stream().collect(Collectors.groupingBy(SalesOrgVo::getErpCode));
        }
        for (Map.Entry<Integer, DaySalesImportVo> row : data.entrySet()) {
            String errInfo;
            List list;
            if (productVoMap.containsKey(row.getValue().getGoodsCode())) {
                row.getValue().setGoodsName(((ProductVo)productVoMap.get(row.getValue().getGoodsCode())).getProductName());
            } else {
                this.validateIsTrue(false, "\u4ea7\u54c1\u7f16\u7801\u3010" + row.getValue().getGoodsCode() + "\u3011\u9519\u8bef\uff0c\u8bf7\u68c0\u67e5\uff01");
            }
            DictDataVo promotionType = ((List)dictDataMap.get(MDM_BUSINESS_FORMAT)).stream().filter(e -> e.getDictValue().equals(((DaySalesImportVo)row.getValue()).getBusinessFormatCode())).findFirst().orElse(null);
            if (promotionType != null) {
                row.getValue().setBusinessFormatCode(promotionType.getDictCode());
            } else {
                this.validateIsTrue(false, "\u4e1a\u6001\u3010" + row.getValue().getBusinessFormatCode() + "\u3011\u9519\u8bef\uff0c\u8bf7\u68c0\u67e5\uff01");
            }
            if (channelVoMap.containsKey(row.getValue().getChannelCode())) {
                row.getValue().setChannelName(((CustomerChannelVo)channelVoMap.get(row.getValue().getChannelCode())).getCustomerChannelName());
            } else {
                this.validateIsTrue(false, "\u6e20\u9053\u7f16\u7801\u3010" + row.getValue().getChannelCode() + "\u3011\u9519\u8bef\uff0c\u8bf7\u68c0\u67e5\uff01");
            }
            if (orgVoMap.containsKey(row.getValue().getSalesInstitutionCode())) {
                list = (List)orgVoMap.get(row.getValue().getSalesInstitutionCode());
                SalesOrgVo salesOrgVo = list.stream().filter(e -> ((DaySalesImportVo)row.getValue()).getChannelCode().equals(e.getChannelCode()) && ((DaySalesImportVo)row.getValue()).getBusinessFormatCode().equals(e.getBusinessFormatCode())).findFirst().orElse(null);
                if (salesOrgVo != null) {
                    row.getValue().setSalesInstitutionName(salesOrgVo.getSalesOrgName());
                    row.getValue().setSalesInstitutionCode(salesOrgVo.getSalesOrgCode());
                } else {
                    this.validateIsTrue(false, "\u9500\u552e\u673a\u6784\u7f16\u7801\u3010" + row.getValue().getSalesInstitutionCode() + "\u3011\u9519\u8bef\uff0c\u8bf7\u68c0\u67e5\uff01");
                }
            } else {
                this.validateIsTrue(false, "\u9500\u552e\u673a\u6784\u7f16\u7801\u3010" + row.getValue().getSalesInstitutionCode() + "\u3011\u9519\u8bef\uff0c\u8bf7\u68c0\u67e5\uff01");
            }
            if (customerVoMap.containsKey(row.getValue().getCustomer())) {
                list = (List)customerVoMap.get(row.getValue().getCustomer());
                CustomerVo customerVo = list.stream().filter(e -> ((DaySalesImportVo)row.getValue()).getChannelCode().equals(e.getCustomerChannelCode()) && ((DaySalesImportVo)row.getValue()).getSalesInstitutionCode().equals(e.getSalesInstitutionErpCode()) && ((DaySalesImportVo)row.getValue()).getBusinessFormatCode().equals(e.getBusinessFormatCode())).findFirst().orElse(null);
                if (customerVo == null) {
                    this.validateIsTrue(false, "\u5ba2\u6237\u7f16\u7801\u3010" + row.getValue().getCustomer() + "\u3011\u672a\u627e\u5230\u5bf9\u5e94\u5ba2\u6237\uff0c\u8bf7\u68c0\u67e5\uff01");
                } else {
                    row.getValue().setCustomerName(customerVo.getCustomerName());
                }
            } else {
                this.validateIsTrue(false, "\u5ba2\u6237\u7f16\u7801\u3010" + row.getValue().getCustomer() + "\u3011\u9519\u8bef\uff0c\u8bf7\u68c0\u67e5\uff01");
            }
            if ((errInfo = this.validateGetErrorInfo()) == null) continue;
            errMap.put(row.getKey(), errInfo);
        }
        if (!errMap.isEmpty()) {
            return new ArrayList<TpmDaySalesVo>();
        }
        ArrayList<TpmDaySalesVo> dtoList = new ArrayList<TpmDaySalesVo>(this.nebulaToolkitService.copyCollectionByWhiteList(data.values(), DaySalesImportVo.class, TpmDaySalesVo.class, LinkedHashSet.class, ArrayList.class, new String[0]));
        return dtoList;
    }

    public Class<DaySalesImportVo> findCrmExcelVoClass() {
        return DaySalesImportVo.class;
    }

    public String getTemplateCode() {
        return "TMP_DAY_SALES_IMPORTS";
    }

    public String getTemplateName() {
        return "TPM\u65e5\u9500\u552e\u6570\u636e\u5bfc\u5165";
    }

    public Integer getBatchCount() {
        return 10000;
    }
}

