/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.tpm.business.day.sales.local.service.internal;

import com.biz.crm.common.ie.sdk.excel.process.ImportProcess;
import com.biz.crm.common.ie.sdk.vo.TaskGlobalParamsVo;
import com.biz.crm.tpm.business.day.sales.sdk.service.TpmDaySalesSpliceService;
import com.biz.crm.tpm.business.day.sales.sdk.vo.DaySalesSpliceImportVo;
import com.biz.crm.tpm.business.day.sales.sdk.vo.TpmDaySalesSpliceVo;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class DaySalesSpliceImportsProcess
implements ImportProcess<DaySalesSpliceImportVo> {
    private static final Logger log = LoggerFactory.getLogger(DaySalesSpliceImportsProcess.class);
    @Autowired
    private NebulaToolkitService nebulaToolkitService;
    @Autowired
    private TpmDaySalesSpliceService tpmDaySalesSpliceService;

    public Integer getBatchCount() {
        return Integer.MAX_VALUE;
    }

    public boolean importBeforeValidationFlag() {
        return Boolean.TRUE;
    }

    public Map<Integer, String> tryVerify(LinkedHashMap<Integer, DaySalesSpliceImportVo> data, TaskGlobalParamsVo paramsVo, Map<String, Object> params) {
        Validate.notEmpty(data, (String)"\u5bfc\u5165\u6570\u636e\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        HashMap<Integer, String> errMap = new HashMap<Integer, String>();
        for (Map.Entry<Integer, DaySalesSpliceImportVo> row : data.entrySet()) {
            int rowNum = row.getKey();
            DaySalesSpliceImportVo vo = row.getValue();
            this.validateIsTrue(vo.getAmount() != null, "\u91d1\u989d\u4e0d\u80fd\u4e3a\u7a7a\uff01");
            this.validateIsTrue(StringUtils.isNotEmpty((CharSequence)vo.getCustomer()), "\u5ba2\u6237\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a\uff01");
            this.validateIsTrue(StringUtils.isNotEmpty((CharSequence)vo.getCustomerName()), "\u5ba2\u6237\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a\uff01");
            this.validateIsTrue(StringUtils.isNotEmpty((CharSequence)vo.getGoodsCode()), "\u8d27\u54c1\u7f16\u53f7\u4e0d\u80fd\u4e3a\u7a7a\uff01");
            this.validateIsTrue(StringUtils.isNotEmpty((CharSequence)vo.getGoodsName()), "\u8d27\u54c1\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a\uff01");
            this.validateIsTrue(vo.getNum() != null, "\u6570\u91cf\u4e0d\u80fd\u4e3a\u7a7a\uff01");
            this.validateIsTrue(vo.getTradeDate() != null, "\u4ea4\u6613\u65e5\u671f\u4e0d\u80fd\u4e3a\u7a7a\uff01");
            this.validateIsTrue(StringUtils.isNotEmpty((CharSequence)vo.getActivityFormName()), "\u6d3b\u52a8\u5f62\u5f0f\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a\uff01");
            this.validateIsTrue(StringUtils.isNotEmpty((CharSequence)vo.getChannel()), "\u6e20\u9053\u4e0d\u80fd\u4e3a\u7a7a\uff01");
            this.validateIsTrue(StringUtils.isNotEmpty((CharSequence)vo.getBusinessFormatName()), "\u4e1a\u6001\u4e0d\u80fd\u4e3a\u7a7a\uff01");
            this.validateIsTrue(StringUtils.isNotEmpty((CharSequence)vo.getChannelCode()), "\u6e20\u9053\u4e0d\u80fd\u4e3a\u7a7a\uff01");
            this.validateIsTrue(StringUtils.isNotEmpty((CharSequence)vo.getSalesInstitutionCode()), "\u9500\u552e\u673a\u6784\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a\uff01");
            String errInfo = this.validateGetErrorInfo();
            if (errInfo == null) continue;
            errMap.put(rowNum, errInfo);
        }
        return errMap;
    }

    public Map<Integer, String> execute(LinkedHashMap<Integer, DaySalesSpliceImportVo> data, TaskGlobalParamsVo paramsVo, Map<String, Object> params) {
        ArrayList<DaySalesSpliceImportVo> importList = new ArrayList<DaySalesSpliceImportVo>(data.values());
        Collection tpmDaySalesVos = this.nebulaToolkitService.copyCollectionByBlankList(importList, DaySalesSpliceImportVo.class, TpmDaySalesSpliceVo.class, HashSet.class, ArrayList.class, new String[0]);
        this.tpmDaySalesSpliceService.createBatch(tpmDaySalesVos);
        return null;
    }

    public Class<DaySalesSpliceImportVo> findCrmExcelVoClass() {
        return DaySalesSpliceImportVo.class;
    }

    public String getTemplateCode() {
        return "TMP_DAY_SALES_SPLICE_IMPORTS";
    }

    public String getTemplateName() {
        return "TPM\u65e5\u9500\u552e\u6570\u636e\u62c6\u5206\u660e\u7ec6\u5bfc\u5165";
    }
}

