/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.tpm.business.day.sales.local.service.internal;

import cn.hutool.core.collection.CollectionUtil;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.business.common.sdk.enums.DelFlagStatusEnum;
import com.biz.crm.business.common.sdk.enums.EnableStatusEnum;
import com.biz.crm.business.common.sdk.model.AbstractCrmUserIdentity;
import com.biz.crm.business.common.sdk.service.LoginUserService;
import com.biz.crm.mdm.business.customer.channel.sdk.service.CustomerChannelVoService;
import com.biz.crm.mdm.business.customer.channel.sdk.vo.CustomerChannelVo;
import com.biz.crm.mdm.business.customer.sdk.dto.CustomerDto;
import com.biz.crm.mdm.business.customer.sdk.service.CustomerVoService;
import com.biz.crm.mdm.business.customer.sdk.vo.CustomerVo;
import com.biz.crm.mdm.business.product.sdk.service.ProductVoService;
import com.biz.crm.mdm.business.product.sdk.vo.ProductVo;
import com.biz.crm.mdm.business.sales.org.sdk.service.SalesOrgVoService;
import com.biz.crm.mdm.business.sales.org.sdk.vo.SalesOrgVo;
import com.biz.crm.mn.common.base.service.RedisLockService;
import com.biz.crm.mn.common.base.util.DateUtil;
import com.biz.crm.tpm.business.day.sales.local.entity.TpmDaySales;
import com.biz.crm.tpm.business.day.sales.local.entity.TpmDaySalesSplice;
import com.biz.crm.tpm.business.day.sales.local.repository.TpmDaySalesRepository;
import com.biz.crm.tpm.business.day.sales.local.repository.TpmDaySalesSpliceRepository;
import com.biz.crm.tpm.business.day.sales.sdk.dto.TpmDaySalesSearchDto;
import com.biz.crm.tpm.business.day.sales.sdk.dto.TpmDaySalesSpliceDto;
import com.biz.crm.tpm.business.day.sales.sdk.dto.log.DaySalesLogEventDto;
import com.biz.crm.tpm.business.day.sales.sdk.event.log.DaySalesLogEventListener;
import com.biz.crm.tpm.business.day.sales.sdk.service.TpmDaySalesService;
import com.biz.crm.tpm.business.day.sales.sdk.vo.TpmDaySalesVo;
import com.biz.crm.tpm.business.third.system.sdk.dto.Ce1MnjtFullDto;
import com.biz.crm.tpm.business.third.system.sdk.service.Ce1MnjtSdkService;
import com.biz.crm.tpm.business.third.system.sdk.vo.Ce1MnjtFullVo2;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import com.bizunited.nebula.event.sdk.function.SerializableBiConsumer;
import com.bizunited.nebula.event.sdk.service.NebulaEventDto;
import com.bizunited.nebula.event.sdk.service.NebulaNetEventClient;
import com.bizunited.nebula.task.annotations.DynamicTaskService;
import com.google.common.collect.Lists;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import jodd.util.StringUtil;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.dao.DuplicateKeyException;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.scheduling.annotation.Async;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;

@Service(value="tpmDaySalesService")
public class TpmDaySalesServiceImpl
implements TpmDaySalesService {
    private static final Logger log = LoggerFactory.getLogger(TpmDaySalesServiceImpl.class);
    @Autowired(required=false)
    private TpmDaySalesRepository tpmDaySalesRepository;
    @Autowired(required=false)
    private TpmDaySalesSpliceRepository tpmDaySalesSpliceRepository;
    @Autowired(required=false)
    private NebulaToolkitService nebulaToolkitService;
    @Autowired(required=false)
    private NebulaNetEventClient nebulaNetEventClient;
    @Autowired(required=false)
    private CustomerVoService customerVoService;
    @Autowired(required=false)
    private Ce1MnjtSdkService ce1MnjtSdkService;
    @Autowired(required=false)
    private LoginUserService loginUserService;
    @Autowired(required=false)
    private SalesOrgVoService salesOrgVoService;
    @Autowired(required=false)
    private CustomerChannelVoService customerChannelVoService;
    @Autowired(required=false)
    private ProductVoService productVoService;
    @Autowired(required=false)
    private RedisLockService redisLockService;

    public Page<TpmDaySalesVo> findByConditions(Pageable pageable, TpmDaySalesSearchDto tpmDaySales) {
        ObjectUtils.defaultIfNull((Object)pageable, (Object)PageRequest.of((int)1, (int)50));
        if (Objects.isNull(tpmDaySales)) {
            tpmDaySales = new TpmDaySalesSearchDto();
        }
        return this.tpmDaySalesRepository.findByConditions(pageable, tpmDaySales);
    }

    public List<TpmDaySalesVo> findByConditionsNoPage(TpmDaySalesSearchDto tpmDaySales) {
        if (Objects.isNull(tpmDaySales)) {
            tpmDaySales = new TpmDaySalesSearchDto();
        }
        return this.tpmDaySalesRepository.findByConditionsNoPage(tpmDaySales);
    }

    public List<TpmDaySalesVo> findByConditionsNoPage2(TpmDaySalesSearchDto tpmDaySales) {
        if (Objects.isNull(tpmDaySales)) {
            tpmDaySales = new TpmDaySalesSearchDto();
        }
        return this.tpmDaySalesRepository.findByConditionsNoPage2(tpmDaySales);
    }

    public BigDecimal getDaySalesTotalAmount(TpmDaySalesSearchDto daySalesSearch) {
        return this.tpmDaySalesRepository.getDaySalesTotalAmount(daySalesSearch);
    }

    public List<TpmDaySalesVo> findByIdList(List<String> idList) {
        Validate.isTrue((!CollectionUtils.isEmpty(idList) ? 1 : 0) != 0, (String)"\u67e5\u8be2\u6570\u636e\u65f6\uff0c\u4e3b\u952e\u96c6\u5408\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        return Lists.newArrayList((Iterable)this.nebulaToolkitService.copyCollectionByWhiteList(this.tpmDaySalesRepository.findByIdList(idList), TpmDaySales.class, TpmDaySalesVo.class, HashSet.class, ArrayList.class, new String[0]));
    }

    @Transactional(rollbackFor={Exception.class})
    public void splice(TpmDaySalesSpliceDto dto) {
        this.spliceExecute(Arrays.asList(dto));
    }

    @Transactional(rollbackFor={Exception.class})
    public void spliceBatch(List<TpmDaySalesSpliceDto> dtoList) {
        this.spliceExecute(dtoList);
    }

    private void spliceExecute(List<TpmDaySalesSpliceDto> dtoList) {
        Set<String> ids = this.spliceValidate(dtoList);
        List daySalesList = this.tpmDaySalesRepository.listByIds(ids);
        Validate.isTrue((daySalesList.size() == ids.size() ? 1 : 0) != 0, (String)"\u672a\u627e\u5230\u6240\u8981\u62c6\u5206\u7684\u65e5\u9500\u552e\u6570\u636e\uff01", (Object[])new Object[0]);
        Map<String, List<TpmDaySalesSpliceDto>> map = dtoList.stream().collect(Collectors.groupingBy(TpmDaySalesSpliceDto::getParentId));
        ArrayList spliceList = new ArrayList();
        map.forEach((k, v) -> {
            TpmDaySales daySales = daySalesList.stream().filter(e -> e.getId().equals(k)).findFirst().orElse(null);
            Integer num = 0;
            BigDecimal amount = BigDecimal.ZERO;
            for (TpmDaySalesSpliceDto dto : v) {
                num = num + dto.getNumSplice();
                amount = amount.add(dto.getAmountSplice());
                Validate.isTrue((num <= daySales.getNumEnable() ? 1 : 0) != 0, (String)"\u62c6\u5206\u6570\u91cf\u5927\u4e8e\u53ef\u62c6\u5206\u6570\u91cf", (Object[])new Object[0]);
                Validate.isTrue((amount.compareTo(daySales.getAmountEnable()) <= 0 ? 1 : 0) != 0, (String)"\u62c6\u5206\u91d1\u989d\u5927\u4e8e\u53ef\u62c6\u5206\u91d1\u989d", (Object[])new Object[0]);
                TpmDaySalesSplice daySalesSplice = (TpmDaySalesSplice)((Object)((Object)this.nebulaToolkitService.copyObjectByWhiteList((Object)daySales, TpmDaySalesSplice.class, HashSet.class, ArrayList.class, new String[0])));
                daySalesSplice.setId(null);
                daySalesSplice.setNum(BigDecimal.valueOf(dto.getNumSplice().intValue()));
                daySalesSplice.setAmount(dto.getAmountSplice());
                daySalesSplice.setChannel(dto.getChannel());
                daySalesSplice.setActivityForm(dto.getActivityForm());
                daySalesSplice.setActivityFormName(dto.getActivityFormName());
                spliceList.add(daySalesSplice);
            }
            daySales.setNumEnable(daySales.getNumEnable() - num);
            daySales.setAmountEnable(daySales.getAmountEnable().subtract(amount));
            this.tpmDaySalesRepository.saveOrUpdate((Object)daySales);
        });
        try {
            this.tpmDaySalesSpliceRepository.saveBatch(spliceList);
        }
        catch (DuplicateKeyException e) {
            throw new RuntimeException("\u5b58\u5728\u91cd\u590d\u7684\u62c6\u5206\u660e\u7ec6\uff0c\u4e0d\u5141\u8bb8\u62c6\u5206");
        }
    }

    Set<String> spliceValidate(List<TpmDaySalesSpliceDto> dtoList) {
        HashSet<String> idSet = new HashSet<String>();
        HashSet uniqueSet = new HashSet();
        dtoList.forEach(e -> {
            Validate.notNull((Object)e, (String)"\u5bf9\u8c61\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
            Validate.notBlank((CharSequence)e.getParentId(), (String)"\u65e5\u9500\u552e\u4e3b\u952eid\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
            Validate.notBlank((CharSequence)e.getChannel(), (String)"\u6e20\u9053\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
            Validate.notBlank((CharSequence)e.getActivityForm(), (String)"\u6d3b\u52a8\u5f62\u5f0f\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
            Validate.notNull((Object)e.getAmountSplice(), (String)"\u62c6\u5206\u91d1\u989d\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
            Validate.notNull((Object)e.getNumSplice(), (String)"\u62c6\u5206\u6570\u91cf\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
            Validate.notNull((Object)e.getParentId(), (String)"\u65e5\u9500\u552e\u4e3b\u952eid\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
            Validate.isTrue((e.getNumSplice() > 0 || e.getAmountSplice().compareTo(BigDecimal.ZERO) > 0 ? 1 : 0) != 0, (String)"\u62c6\u5206\u91d1\u989d\u548c\u62c6\u5206\u6570\u91cf\u81f3\u5c11\u6709\u4e00\u4e2a\u5927\u4e8e0\u624d\u5141\u8bb8\u62c6\u5206", (Object[])new Object[0]);
            idSet.add(e.getParentId());
            uniqueSet.add(e.getParentId() + "_" + e.getChannel() + "_" + e.getActivityForm());
        });
        Validate.isTrue((uniqueSet.size() == dtoList.size() ? 1 : 0) != 0, (String)"\u76f8\u540c\u65e5\u9500\u552e\u6570\u636e\u4e0d\u53ef\u91cd\u590d\u62c6\u5206\uff01", (Object[])new Object[0]);
        return idSet;
    }

    @Transactional(rollbackFor={Exception.class})
    public void create(TpmDaySalesVo daySalesVo) {
        String id = this.createValidate(daySalesVo);
        this.store(daySalesVo, id);
    }

    @Transactional(rollbackFor={Exception.class})
    public void createBatch(Collection<TpmDaySalesVo> daySalesVos) {
        daySalesVos.forEach(e -> this.createImport((TpmDaySalesVo)e));
    }

    @Transactional(propagation=Propagation.NOT_SUPPORTED, rollbackFor={Exception.class})
    public void batchSave(List<TpmDaySalesVo> daySalesVos) {
        if (CollectionUtils.isEmpty(daySalesVos)) {
            return;
        }
        Collection tpmDaySales = this.nebulaToolkitService.copyCollectionByBlankList(daySalesVos, TpmDaySalesVo.class, TpmDaySales.class, LinkedHashSet.class, ArrayList.class, new String[0]);
        tpmDaySales.forEach(item -> item.setTenantCode(TenantUtils.getTenantCode()));
        this.tpmDaySalesRepository.saveBatch(tpmDaySales);
    }

    @Transactional(propagation=Propagation.NOT_SUPPORTED, rollbackFor={Exception.class})
    public void deleteByVerifyCodes(List<String> verifyCodes) {
        if (CollectionUtils.isEmpty(verifyCodes)) {
            return;
        }
        this.tpmDaySalesRepository.deleteByVerifyCode(verifyCodes);
    }

    public List<TpmDaySalesVo> getDataFromPromotionPlan(TpmDaySalesSearchDto dto) {
        Validate.isTrue((null != dto.getStartDate() && null != dto.getEndDate() ? 1 : 0) != 0, (String)"\u5f00\u59cb\u7ed3\u675f\u65f6\u95f4\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        return this.tpmDaySalesRepository.getDataFromPromotionPlan(dto);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Async
    public void getSalesData(String yearMonth, AbstractCrmUserIdentity userIdentity) {
        boolean lockSuccess = this.redisLockService.tryLock("tpm:sales_data:lock:", TimeUnit.HOURS, 4L);
        Assert.isTrue((boolean)lockSuccess, (String)"\u5176\u4ed6\u4eba\u6b63\u5728\u64cd\u4f5c\u6570\u636e,\u52a0\u9501\u5931\u8d25,\u8bf7\u7a0d\u540e\u91cd\u8bd5!");
        try {
            this.loginUserService.refreshAuthentication((Object)userIdentity);
            this.findSalesData(yearMonth);
        }
        finally {
            this.redisLockService.unlock("tpm:sales_data:lock:");
        }
    }

    @DynamicTaskService(cornExpression="0 0 1 * * ?", taskDesc="\u51cc\u66681\u70b9\u5e73\u53f0\u9500\u552e\u6570\u636e\u7ba1\u7406\u540c\u6b65\u65e5\u9500\u552e\u6570\u636e")
    @Transactional(propagation=Propagation.NOT_SUPPORTED, rollbackFor={Exception.class})
    public void synchronizationSalesData() {
        this.loginUserService.refreshAuthentication(null);
        boolean lockSuccess = this.redisLockService.tryLock("tpm:sales_data:lock:", TimeUnit.HOURS, 4L);
        Assert.isTrue((boolean)lockSuccess, (String)"\u5176\u4ed6\u4eba\u6b63\u5728\u64cd\u4f5c\u6570\u636e,\u52a0\u9501\u5931\u8d25,\u8bf7\u7a0d\u540e\u91cd\u8bd5!");
        try {
            this.findSalesData(DateUtil.date_yyyy_MM.format(new Date()));
        }
        finally {
            this.redisLockService.unlock("tpm:sales_data:lock:");
        }
    }

    @Transactional(rollbackFor={Exception.class})
    public void delete(List<String> ids) {
        Validate.isTrue((!CollectionUtils.isEmpty(ids) ? 1 : 0) != 0, (String)"\u8bf7\u9009\u62e9\u8981\u5220\u9664\u7684\u6570\u636e\uff01", (Object[])new Object[0]);
        this.tpmDaySalesRepository.removeByIds(ids);
    }

    private void findSalesData(String yearMonth) {
        Assert.hasLength((String)yearMonth, (String)"\u5e74\u6708\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a!");
        try {
            Date date = DateUtil.date_yyyy_MM.parse(yearMonth);
            Assert.isTrue((boolean)yearMonth.equals(DateUtil.date_yyyy_MM.format(date)), (String)"\u5e74\u6708\u683c\u5f0f\u9519\u8bef\u3010yyyy-MM\u3011");
        }
        catch (Exception e) {
            throw new IllegalArgumentException("\u5e74\u6708\u683c\u5f0f\u9519\u8bef\u3010yyyy-MM\u3011");
        }
        ArrayList<String> businessModelCodeList = new ArrayList<String>();
        CustomerDto customerDto = new CustomerDto();
        businessModelCodeList.add("self_operated_mode");
        businessModelCodeList.add("distribution_mode");
        customerDto.setBusinessModelCodeList(businessModelCodeList);
        List customerVos = this.customerVoService.getCustomerByConditions(customerDto);
        Validate.isTrue((!CollectionUtils.isEmpty((Collection)customerVos) ? 1 : 0) != 0, (String)"\u672a\u67e5\u8be2\u5230\u4e3b\u6570\u636e\u7684\u81ea\u8425\u5ba2\u6237\u4fe1\u606f", (Object[])new Object[0]);
        List codeList = customerVos.stream().map(CustomerVo::getErpCode).filter(StringUtils::isNotBlank).collect(Collectors.toList());
        Validate.isTrue((!CollectionUtils.isEmpty(codeList) ? 1 : 0) != 0, (String)"\u672a\u67e5\u8be2\u5230\u4e3b\u6570\u636e\u7684\u81ea\u8425\u5ba2\u6237MDG\u7f16\u7801", (Object[])new Object[0]);
        Map<String, String> customerMap = customerVos.stream().filter(vo -> !StringUtils.isEmpty((CharSequence)vo.getErpCode())).collect(Collectors.toMap(CustomerVo::getErpCode, CustomerVo::getCustomerName, (a, b) -> a));
        Ce1MnjtFullDto ce1MnjtFullDto = new Ce1MnjtFullDto();
        ce1MnjtFullDto.setYearMonth(yearMonth.replace("-", ""));
        ce1MnjtFullDto.setCodeList(codeList);
        PageRequest pageable = PageRequest.of((int)1, (int)800);
        Page pageResult = null;
        String tenantCode = TenantUtils.getTenantCode();
        String code = DelFlagStatusEnum.NORMAL.getCode();
        this.removeByYearMonth(yearMonth);
        do {
            pageResult = this.ce1MnjtSdkService.findSalesByConditions((Pageable)pageable, ce1MnjtFullDto);
            pageable = pageable.next();
            log.info("=====>    \u67e5\u8be2\u5230\u65e5\u9500\u552e\u6570\u636e \u5e74\u6708[{}]  \u9875[{}/{}][{}]\u6761    <=====", new Object[]{yearMonth, pageResult.getCurrent(), pageResult.getPages(), pageResult.getSize()});
            this.buildAndSaveData(pageResult.getRecords(), tenantCode, code, customerMap, yearMonth);
        } while (pageResult.hasNext());
    }

    @Transactional(rollbackFor={Exception.class}, propagation=Propagation.NOT_SUPPORTED)
    public void removeByYearMonth(String yearMonth) {
        if (StringUtil.isEmpty((CharSequence)yearMonth)) {
            return;
        }
        this.tpmDaySalesRepository.removeByYearMonth(yearMonth);
    }

    private void buildAndSaveData(List<Ce1MnjtFullVo2> records, String tenantCode, String code, Map<String, String> customerMap, String yearMonth) {
        List byProductCodes;
        List byCodes;
        List channelCodeList = records.stream().map(Ce1MnjtFullVo2::getDistributionChannelCode).filter(StringUtils::isNotBlank).collect(Collectors.toList());
        List companyCodeList = records.stream().map(Ce1MnjtFullVo2::getCompanyCode).filter(StringUtils::isNotBlank).collect(Collectors.toList());
        List productCodeList = records.stream().map(Ce1MnjtFullVo2::getProductCode).filter(StringUtils::isNotBlank).collect(Collectors.toList());
        HashMap<String, SalesOrgVo> salesInstitutionMap = new HashMap<String, SalesOrgVo>();
        HashMap<String, List<CustomerChannelVo>> customerChannelMap = new HashMap<String, List<CustomerChannelVo>>();
        HashMap<String, List<ProductVo>> productMap = new HashMap<String, List<ProductVo>>();
        List salesInstitutions = this.salesOrgVoService.findBySalesOrgCodesPost(companyCodeList);
        if (CollectionUtil.isNotEmpty((Collection)salesInstitutions)) {
            salesInstitutionMap.putAll(salesInstitutions.stream().collect(Collectors.toMap(SalesOrgVo::getSalesOrgCode, v -> v, (n, o) -> n)));
        }
        if (CollectionUtil.isNotEmpty((Collection)(byCodes = this.customerChannelVoService.findByCodes(channelCodeList)))) {
            customerChannelMap.putAll(byCodes.stream().collect(Collectors.groupingBy(CustomerChannelVo::getCustomerChannelCode)));
        }
        if (CollectionUtil.isNotEmpty((Collection)(byProductCodes = this.productVoService.findByCodes(productCodeList)))) {
            productMap.putAll(byProductCodes.stream().collect(Collectors.groupingBy(ProductVo::getProductCode)));
        }
        ArrayList<TpmDaySales> list = new ArrayList<TpmDaySales>();
        for (Ce1MnjtFullVo2 record : records) {
            String salesIncludingTaxNet;
            TpmDaySales tpmDaySales = new TpmDaySales();
            tpmDaySales.setId(record.getCId());
            tpmDaySales.setBusinessFormatCode(record.getProductTeamCode());
            String distributionChannelCode = record.getDistributionChannelCode();
            tpmDaySales.setChannelCode(distributionChannelCode);
            List customerChannelVos = (List)customerChannelMap.get(distributionChannelCode);
            if (!CollectionUtils.isEmpty((Collection)customerChannelVos)) {
                tpmDaySales.setChannelName(((CustomerChannelVo)customerChannelVos.get(0)).getCustomerChannelName());
            }
            String companyCode = record.getCompanyCode();
            tpmDaySales.setSalesInstitutionCode(companyCode);
            SalesOrgVo salesOrgVos = (SalesOrgVo)salesInstitutionMap.get(distributionChannelCode + tpmDaySales.getBusinessFormatCode() + companyCode);
            if (Objects.nonNull(salesOrgVos)) {
                tpmDaySales.setSalesInstitutionName(salesOrgVos.getSalesOrgName());
            }
            tpmDaySales.setCustomer(record.getCustomerCode());
            tpmDaySales.setCustomerName(customerMap.get(record.getCustomerCode()));
            String productCode = record.getProductCode();
            tpmDaySales.setGoodsCode(productCode);
            List productVos = (List)productMap.get(productCode);
            if (!CollectionUtils.isEmpty((Collection)productVos)) {
                tpmDaySales.setGoodsName(((ProductVo)productVos.get(0)).getProductName());
            }
            if (StringUtils.isNotBlank((CharSequence)(salesIncludingTaxNet = record.getSalesIncludingTaxNet()))) {
                tpmDaySales.setAmount(new BigDecimal(salesIncludingTaxNet));
            }
            tpmDaySales.setNum(record.getSalesVolumes());
            try {
                tpmDaySales.setTradeDate(DateUtil.parse((String)record.getPostDate(), (String)"yyyyMMdd"));
            }
            catch (Exception e) {
                throw new IllegalArgumentException("\u4ea4\u6613\u65e5\u671f\u89e3\u6790\u9519\u8bef");
            }
            tpmDaySales.setTenantCode(tenantCode);
            tpmDaySales.setDelFlag(code);
            tpmDaySales.setAmountEnable(BigDecimal.ZERO);
            tpmDaySales.setNumEnable(0);
            tpmDaySales.setYearMonthLy(yearMonth);
            list.add(tpmDaySales);
        }
        this.tpmDaySalesRepository.saveOrUpdateBatch(list);
    }

    private void createImport(TpmDaySalesVo daySalesVo) {
        String id = this.validateRepeatabilityOnCreate(daySalesVo);
        this.store(daySalesVo, id);
    }

    private void store(TpmDaySalesVo daySalesVo, String id) {
        TpmDaySales daySales = (TpmDaySales)((Object)this.nebulaToolkitService.copyObjectByWhiteList((Object)daySalesVo, TpmDaySales.class, HashSet.class, ArrayList.class, new String[0]));
        daySales.setId(id);
        daySales.setEnableStatus(EnableStatusEnum.ENABLE.getCode());
        daySales.setDelFlag(DelFlagStatusEnum.NORMAL.getCode());
        daySales.setTenantCode(TenantUtils.getTenantCode());
        daySales.setNumEnable(daySales.getNum().intValue());
        daySales.setAmountEnable(daySales.getAmount());
        this.tpmDaySalesRepository.saveOrUpdate((Object)daySales);
        DaySalesLogEventDto logEventDto = new DaySalesLogEventDto();
        logEventDto.setOriginal(null);
        logEventDto.setNewest(daySalesVo);
        SerializableBiConsumer & Serializable onCreate = DaySalesLogEventListener::onCreate;
        this.nebulaNetEventClient.publish((NebulaEventDto)logEventDto, DaySalesLogEventListener.class, (SerializableBiConsumer)onCreate);
    }

    private String createValidate(TpmDaySalesVo tpmDaySales) {
        Validate.notNull((Object)tpmDaySales, (String)"\u5bf9\u8c61\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notNull((Object)tpmDaySales.getAmount(), (String)"\u91d1\u989d\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)tpmDaySales.getCustomer(), (String)"\u5ba2\u6237\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)tpmDaySales.getCustomerName(), (String)"\u5ba2\u6237\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)tpmDaySales.getGoodsCode(), (String)"\u8d27\u54c1\u7f16\u53f7\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)tpmDaySales.getGoodsName(), (String)"\u8d27\u54c1\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notNull((Object)tpmDaySales.getNum(), (String)"\u6570\u91cf\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notNull((Object)tpmDaySales.getTradeDate(), (String)"\u4ea4\u6613\u65e5\u671f\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        return this.validateRepeatabilityOnCreate(tpmDaySales);
    }

    private String validateRepeatabilityOnCreate(TpmDaySalesVo tpmDaySales) {
        List<TpmDaySales> list = this.tpmDaySalesRepository.findOnCreate(tpmDaySales);
        return CollectionUtils.isEmpty(list) ? null : list.get(0).getId();
    }

    private void updateValidate(TpmDaySales tpmDaySales) {
        Validate.notNull((Object)((Object)tpmDaySales), (String)"\u4fee\u6539\u65f6\uff0c\u5bf9\u8c61\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)tpmDaySales.getId(), (String)"\u65b0\u589e\u6570\u636e\u65f6\uff0c\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)tpmDaySales.getTenantCode(), (String)"\u65b0\u589e\u6570\u636e\u65f6\uff0c\u79df\u6237\u7f16\u53f7\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notNull((Object)tpmDaySales.getAmount(), (String)"\u65b0\u589e\u6570\u636e\u65f6\uff0c\u91d1\u989d\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)tpmDaySales.getCustomer(), (String)"\u65b0\u589e\u6570\u636e\u65f6\uff0c\u5ba2\u6237\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)tpmDaySales.getGoodsCode(), (String)"\u65b0\u589e\u6570\u636e\u65f6\uff0c\u8d27\u54c1\u7f16\u53f7\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)tpmDaySales.getGoodsName(), (String)"\u65b0\u589e\u6570\u636e\u65f6\uff0c\u8d27\u54c1\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notNull((Object)tpmDaySales.getNum(), (String)"\u65b0\u589e\u6570\u636e\u65f6\uff0c\u6570\u91cf\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notNull((Object)tpmDaySales.getTradeDate(), (String)"\u65b0\u589e\u6570\u636e\u65f6\uff0c\u4ea4\u6613\u65e5\u671f\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
    }
}

