/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.tpm.business.day.sales.local.service.internal;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.business.common.sdk.enums.DelFlagStatusEnum;
import com.biz.crm.business.common.sdk.enums.EnableStatusEnum;
import com.biz.crm.mdm.business.customer.channel.sdk.service.CustomerChannelVoService;
import com.biz.crm.mdm.business.customer.channel.sdk.vo.CustomerChannelVo;
import com.biz.crm.mdm.business.dictionary.sdk.service.DictDataVoService;
import com.biz.crm.mdm.business.dictionary.sdk.vo.DictDataVo;
import com.biz.crm.mdm.business.sales.org.sdk.service.SalesOrgVoService;
import com.biz.crm.mdm.business.sales.org.sdk.vo.SalesOrgVo;
import com.biz.crm.tpm.business.day.sales.local.entity.TpmDaySalesSplice;
import com.biz.crm.tpm.business.day.sales.local.repository.TpmDaySalesSpliceRepository;
import com.biz.crm.tpm.business.day.sales.sdk.dto.TpmDaySalesSpliceDto;
import com.biz.crm.tpm.business.day.sales.sdk.dto.TpmDaySalesSpliceSearchDto;
import com.biz.crm.tpm.business.day.sales.sdk.service.TpmDaySalesSpliceService;
import com.biz.crm.tpm.business.day.sales.sdk.vo.TpmDaySalesSpliceVo;
import com.biz.crm.tpm.business.day.sales.sdk.vo.TpmDaySalesVo;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import com.google.common.collect.Maps;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.function.Function;
import java.util.stream.Collectors;
import jodd.util.StringUtil;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;

@Service(value="tpmDaySalesSpliceService")
public class TpmDaySalesSpliceServiceImpl
implements TpmDaySalesSpliceService {
    @Autowired(required=false)
    private TpmDaySalesSpliceRepository tpmDaySalesSpliceRepository;
    @Autowired(required=false)
    private NebulaToolkitService nebulaToolkitService;
    @Autowired
    private DictDataVoService dictDataVoService;
    @Autowired
    private SalesOrgVoService salesOrgVoService;
    @Autowired
    private CustomerChannelVoService customerChannelVoService;

    public Page<TpmDaySalesSpliceVo> findByConditions(Pageable pageable, TpmDaySalesSpliceSearchDto tpmDaySalesSplice) {
        ObjectUtils.defaultIfNull((Object)pageable, (Object)PageRequest.of((int)1, (int)50));
        if (Objects.isNull(tpmDaySalesSplice)) {
            tpmDaySalesSplice = new TpmDaySalesSpliceSearchDto();
        }
        return this.tpmDaySalesSpliceRepository.findByConditions(pageable, tpmDaySalesSplice);
    }

    @Transactional(rollbackFor={Exception.class})
    public void create(TpmDaySalesSpliceVo daySalesSpliceVo) {
        String id = this.createValidate(daySalesSpliceVo);
        TpmDaySalesSplice daySalesSplice = (TpmDaySalesSplice)((Object)this.nebulaToolkitService.copyObjectByWhiteList((Object)daySalesSpliceVo, TpmDaySalesSplice.class, HashSet.class, ArrayList.class, new String[0]));
        daySalesSplice.setId(id);
        daySalesSplice.setEnableStatus(EnableStatusEnum.ENABLE.getCode());
        daySalesSplice.setDelFlag(DelFlagStatusEnum.NORMAL.getCode());
        daySalesSplice.setTenantCode(TenantUtils.getTenantCode());
        this.tpmDaySalesSpliceRepository.saveOrUpdate((Object)daySalesSplice);
    }

    @Transactional(rollbackFor={Exception.class})
    public void createBatch(Collection<TpmDaySalesSpliceVo> daySalesSpliceVos) {
        List salesOrgCodes;
        List salesOrgVos;
        HashMap businessFormatMap = Maps.newHashMap();
        List businessFormatList = this.dictDataVoService.findByDictTypeCode("mdm_business_format");
        if (!CollectionUtils.isEmpty((Collection)businessFormatList)) {
            businessFormatMap.putAll(businessFormatList.stream().collect(Collectors.toMap(DictDataVo::getDictValue, DictDataVo::getDictCode, (o, n) -> o)));
        }
        HashMap salesOrgVoMap = CollectionUtils.isEmpty((Collection)(salesOrgVos = this.salesOrgVoService.findBySalesOrgCodes(salesOrgCodes = daySalesSpliceVos.stream().map(a -> {
            StringBuffer salesOrgCode = new StringBuffer();
            salesOrgCode.append(a.getChannelCode());
            salesOrgCode.append((String)businessFormatMap.get(a.getBusinessFormatName()));
            salesOrgCode.append(a.getSalesInstitutionCode());
            return salesOrgCode.toString();
        }).collect(Collectors.toList())))) ? Maps.newHashMap() : salesOrgVos.stream().collect(Collectors.toMap(SalesOrgVo::getSalesOrgCode, Function.identity()));
        List channelCodes = daySalesSpliceVos.stream().map(TpmDaySalesVo::getChannelCode).collect(Collectors.toList());
        List channelVos = this.customerChannelVoService.findByCodes(channelCodes);
        HashMap customerChannelVoMap = CollectionUtils.isEmpty((Collection)channelVos) ? Maps.newHashMap() : channelVos.stream().collect(Collectors.toMap(CustomerChannelVo::getCustomerChannelCode, Function.identity()));
        daySalesSpliceVos.forEach(e -> {
            if (businessFormatMap.containsKey(e.getBusinessFormatName())) {
                e.setBusinessFormatCode((String)businessFormatMap.get(e.getBusinessFormatName()));
            }
            StringBuffer salesOrgCode = new StringBuffer();
            salesOrgCode.append(e.getChannelCode());
            salesOrgCode.append(e.getBusinessFormatName());
            salesOrgCode.append(e.getSalesInstitutionCode());
            if (salesOrgVoMap.containsKey(salesOrgCode.toString())) {
                e.setBusinessFormatName(((SalesOrgVo)salesOrgVoMap.get(salesOrgCode.toString())).getSalesOrgName());
            }
            if (customerChannelVoMap.containsKey(e.getChannelCode())) {
                e.setChannelName(((CustomerChannelVo)customerChannelVoMap.get(e.getChannelCode())).getCustomerChannelName());
            }
            e.setActivityForm(e.getActivityFormName());
            this.create((TpmDaySalesSpliceVo)e);
        });
    }

    public BigDecimal getGmv(TpmDaySalesSpliceVo daySalesSpliceVo) {
        Validate.notNull((Object)daySalesSpliceVo, (String)"\u5bf9\u8c61\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)daySalesSpliceVo.getCustomer(), (String)"\u5ba2\u6237\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)daySalesSpliceVo.getChannel(), (String)"\u6e20\u9053\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)daySalesSpliceVo.getActivityForm(), (String)"\u6d3b\u52a8\u5f62\u5f0f\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        return this.tpmDaySalesSpliceRepository.getGmv(daySalesSpliceVo);
    }

    public Page<TpmDaySalesSpliceVo> findByYearAndMonth(Pageable pageable, TpmDaySalesSpliceDto dto) {
        return this.tpmDaySalesSpliceRepository.findByYearAndMonth(pageable, dto);
    }

    private String createValidate(TpmDaySalesSpliceVo tpmDaySalesSplice) {
        Validate.notNull((Object)tpmDaySalesSplice, (String)"\u5bf9\u8c61\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notNull((Object)tpmDaySalesSplice.getAmount(), (String)"\u91d1\u989d\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)tpmDaySalesSplice.getCustomer(), (String)"\u5ba2\u6237\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)tpmDaySalesSplice.getCustomerName(), (String)"\u5ba2\u6237\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)tpmDaySalesSplice.getGoodsCode(), (String)"\u8d27\u54c1\u7f16\u53f7\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)tpmDaySalesSplice.getGoodsName(), (String)"\u8d27\u54c1\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notNull((Object)tpmDaySalesSplice.getNum(), (String)"\u6570\u91cf\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notNull((Object)tpmDaySalesSplice.getTradeDate(), (String)"\u4ea4\u6613\u65e5\u671f\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)tpmDaySalesSplice.getActivityFormName(), (String)"\u6d3b\u52a8\u5f62\u5f0f\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)tpmDaySalesSplice.getChannel(), (String)"\u6e20\u9053\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)tpmDaySalesSplice.getBusinessFormatName(), (String)"\u4e1a\u6001\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)tpmDaySalesSplice.getChannelCode(), (String)"\u6e20\u9053\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)tpmDaySalesSplice.getSalesInstitutionCode(), (String)"\u9500\u552e\u673a\u6784\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        return this.validateRepeatabilityOnCreate(tpmDaySalesSplice);
    }

    private String validateRepeatabilityOnCreate(TpmDaySalesSpliceVo tpmDaySalesSplice) {
        List<TpmDaySalesSplice> list = this.tpmDaySalesSpliceRepository.findOnCreate(tpmDaySalesSplice);
        return CollectionUtils.isEmpty(list) ? null : list.get(0).getId();
    }

    @Transactional(rollbackFor={Exception.class})
    public void delete(List<String> ids) {
        Validate.isTrue((!CollectionUtils.isEmpty(ids) ? 1 : 0) != 0, (String)"\u8bf7\u9009\u62e9\u8981\u5220\u9664\u7684\u6570\u636e\uff01", (Object[])new Object[0]);
        this.tpmDaySalesSpliceRepository.removeByIds(ids);
    }

    public List<TpmDaySalesSpliceVo> getByCustomerAndProduct(String yearMonthLy, String customer, String goodsCode) {
        if (StringUtil.isEmpty((CharSequence)yearMonthLy) || StringUtil.isEmpty((CharSequence)customer) || StringUtil.isEmpty((CharSequence)goodsCode)) {
            return Collections.emptyList();
        }
        return this.tpmDaySalesSpliceRepository.getByCustomerAndProduct(yearMonthLy, customer, goodsCode);
    }
}

