package com.biz.crm.tpm.business.deduction.detail.mapping.local.entity;

import com.baomidou.mybatisplus.annotation.TableName;
import com.biz.crm.business.common.local.entity.TenantFlagOpEntity;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Index;
import javax.persistence.Table;

/**
 * @Description:
 * @Author qiancheng
 * @Date 2023/9/28
 */
@Data
@TableName("tpm_deduction_detail_mapping_customer")
@Entity(name = "tpm_deduction_detail_mapping_customer")
@EqualsAndHashCode(callSuper = true)
@ApiModel(value = "TpmDeductionDetailMappingCustomer", description = "TPM-商超扣费明细映射客户表")
@org.hibernate.annotations.Table(appliesTo = "tpm_deduction_detail_mapping_customer", comment = "TPM-商超扣费明细映射客户表")
@Table(name = "tpm_deduction_detail_mapping_customer", indexes = {@Index(name = "tpm_deduction_detail_mapping_customer_index1", columnList = "tenant_code, code", unique = false)})
public class TpmDeductionDetailMappingCustomer extends TenantFlagOpEntity {

    /**
     * 商超扣费明细映射表编码
     */
    @ApiModelProperty(name = "商超扣费明细映射表编码", notes = "商超扣费明细映射表编码")
    @Column(name = "code", nullable = true, length = 32, columnDefinition = "VARCHAR(32) COMMENT '商超扣费明细映射表编码'")
    private String code;

    /**
     * 客户编码
     */
    @ApiModelProperty(name = "客户编码", notes = "客户编码")
    @Column(name = "customer_code",  length = 32, columnDefinition = "VARCHAR(32) COMMENT '客户编码'")
    private String customerCode;

    /**
     * 客户erp编码
     */
    @ApiModelProperty(name = "客户erp编码", notes = "客户erp编码")
    @Column(name = "erp_code",  length = 32, columnDefinition = "VARCHAR(32) COMMENT '客户erp编码'")
    private String erpCode;

    /**
     * 客户名称
     */
    @ApiModelProperty(name = "客户名称", notes = "客户名称")
    @Column(name = "customer_name",  length = 128, columnDefinition = "VARCHAR(128) COMMENT '客户名称'")
    private String customerName;
}
