package com.biz.crm.tpm.business.deduction.detail.mapping.local.entity;

import com.baomidou.mybatisplus.annotation.TableName;
import com.biz.crm.business.common.local.entity.TenantFlagOpEntity;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Index;
import javax.persistence.Table;

/**
 * @author ：dengwei
 * @date ：Created in 2022/12/1 21:11
 * @description：商超扣费明细项关联活动信息
 */
@Data
@TableName("tpm_deduction_detail_mapping_relation_activity_config")
@Entity(name = "tpm_deduction_detail_mapping_relation_activity_config")
@EqualsAndHashCode(callSuper = true)
@ApiModel(value = "TpmDeductionDetailMappingText", description = "TPM-商超扣费明细项关联活动信息")
@org.hibernate.annotations.Table(appliesTo = "tpm_deduction_detail_mapping_relation_activity_config", comment = "TPM-商超扣费明细项关联活动信息")
@Table(name = "tpm_deduction_detail_mapping_relation_activity_config", indexes = {@Index(name = "tpm_deduction_detail_mapping_relation_activity_config_index1", columnList = "tenant_code, code, activity_type_code, activity_form_code", unique = true)})
public class TpmDeductionDetailMappingRelationActivityConfig extends TenantFlagOpEntity {

    /**
     * 商超扣费明细映射表编码
     */
    @ApiModelProperty(name = "商超扣费明细映射表编码", notes = "商超扣费明细映射表编码")
    @Column(name = "code", nullable = true, length = 32, columnDefinition = "VARCHAR(32) COMMENT '商超扣费明细映射表编码'")
    private String code;

    /**
     * 活动分类编码
     */
    @ApiModelProperty(name = "activityTypeCode", value = "活动分类编码", notes = "活动分类编码")
    @Column(name = "activity_type_code", length = 32, columnDefinition = "VARCHAR(32) COMMENT '活动分类编码'")
    private String activityTypeCode;

    /**
     * 活动分类名称
     */
    @ApiModelProperty(name = "activityTypeName", value = "活动分类名称", notes = "活动分类名称")
    @Column(name = "activity_type_name", length = 255, columnDefinition = "VARCHAR(255) COMMENT '活动分类名称'")
    private String activityTypeName;

    /**
     * 活动形式编码
     */
    @ApiModelProperty(name = "activityFormCode", value = "活动形式编码", notes = "活动形式编码")
    @Column(name = "activity_form_code", length = 32, columnDefinition = "VARCHAR(32) COMMENT '活动形式编码'")
    private String activityFormCode;

    /**
     * 活动形式名称
     */
    @ApiModelProperty(name = "activityFormName", value = "活动形式名称", notes = "活动形式名称")
    @Column(name = "activity_form_name", length = 255, columnDefinition = "VARCHAR(255) COMMENT '活动形式名称'")
    private String activityFormName;

}
