package com.biz.crm.tpm.business.deduction.detail.mapping.local.entity;

import com.baomidou.mybatisplus.annotation.TableName;
import com.biz.crm.business.common.local.entity.TenantFlagOpEntity;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Index;
import javax.persistence.Table;

/**
 * @author ：dengwei
 * @date ：Created in 2022/12/1 21:07
 * @description：商超扣费明细项
 */
@Data
@TableName("tpm_deduction_detail_mapping_text")
@Entity(name = "tpm_deduction_detail_mapping_text")
@EqualsAndHashCode(callSuper = true)
@ApiModel(value = "TpmDeductionDetailMappingText", description = "TPM-商超扣费明细项")
@org.hibernate.annotations.Table(appliesTo = "tpm_deduction_detail_mapping_text", comment = "TPM-商超扣费明细项")
@Table(name = "tpm_deduction_detail_mapping_text", indexes = {@Index(name = "tpm_deduction_detail_mapping_text_index1", columnList = "tenant_code, code, id", unique = true)})
public class TpmDeductionDetailMappingText extends TenantFlagOpEntity {

    /**
     * 商超扣费明细映射表编码
     */
    @ApiModelProperty(name = "商超扣费明细映射表编码", notes = "商超扣费明细映射表编码")
    @Column(name = "code", nullable = true, length = 32, columnDefinition = "VARCHAR(32) COMMENT '商超扣费明细映射表编码'")
    private String code;

    /**
     * 扣费明细项
     */
    @ApiModelProperty(name = "扣费明细项", notes = "扣费明细项")
    @Column(name = "text", columnDefinition = "VARCHAR(255) COMMENT '扣费明细项'")
    private String text;

}
