package com.biz.crm.tpm.business.deduction.detail.mapping.local.mapper;


import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.biz.crm.tpm.business.deduction.detail.mapping.local.entity.TpmDeductionDetailMapping;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.tpm.business.deduction.detail.mapping.sdk.dto.TpmDeductionDetailMappingDto;
import com.biz.crm.tpm.business.deduction.detail.mapping.sdk.vo.TpmDeductionDetailMappingVo;
import org.apache.ibatis.annotations.Param;

import java.util.List;

/**
 * TPM-商超扣费明细映射表(TpmDeductionDetailMapping)表mybatis访问层
 *
 * @author duyiran
 * @since 2022-11-07 19:04:50
 */
public interface TpmDeductionDetailMappingMapper extends BaseMapper<TpmDeductionDetailMapping> {

    /**
     * 分页查询所有数据
     *
     * @param page 分页对象
     * @param dto  dto实体
     * @return 所有数据
     */
    Page<TpmDeductionDetailMappingVo> findByConditions(@Param("page") Page<TpmDeductionDetailMappingVo> page, @Param("dto") TpmDeductionDetailMappingDto dto);


    /**
     * 根据编码查询数据
     *
     * @param codeList codeList
     * @return
     */
    List<TpmDeductionDetailMappingVo> findByCodes(@Param("codeList") List<String> codeList, @Param("tenantCode") String tenantCode);

    /**
     * 根据dto查询
     * @param dto
     * @param tenantCode
     * @return
     */
    List<TpmDeductionDetailMapping> findByDto(@Param("dto") TpmDeductionDetailMappingDto dto, @Param("tenantCode") String tenantCode);
}

