package com.biz.crm.tpm.business.deduction.detail.mapping.local.repository;

import com.baomidou.mybatisplus.extension.conditions.query.LambdaQueryChainWrapper;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.business.common.sdk.enums.DelFlagStatusEnum;
import com.biz.crm.tpm.business.deduction.detail.mapping.local.entity.TpmDeductionDetailMapping;
import com.biz.crm.tpm.business.deduction.detail.mapping.local.entity.TpmDeductionDetailMappingRelationActivityConfig;
import com.biz.crm.tpm.business.deduction.detail.mapping.local.mapper.TpmDeductionDetailMappingRelationActivityConfigMapper;
import com.biz.crm.tpm.business.deduction.detail.mapping.sdk.dto.TpmDeductionDetailMappingDto;
import com.biz.crm.tpm.business.deduction.detail.mapping.sdk.vo.TpmDeductionDetailMappingRelationActivityConfigVo;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import com.google.common.collect.Lists;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;

/**
 * @author ：dengwei
 * @date ：Created in 2022/12/1 21:21
 * @description：商超扣费明细关联活动
 */
@Component
public class TpmDeductionDetailMappingRelationActivityConfigRepository extends ServiceImpl<TpmDeductionDetailMappingRelationActivityConfigMapper, TpmDeductionDetailMappingRelationActivityConfig> {

    @Autowired(required = false)
    private NebulaToolkitService nebulaToolkitService;

    /**
     * 根据编码查询数据
     *
     * @param codeList   codeList
     * @param tenantCode 租户编号
     * @return 全部数据
     */
    public List<TpmDeductionDetailMappingRelationActivityConfigVo> findByCodes(List<String> codeList, String tenantCode) {
        List<TpmDeductionDetailMappingRelationActivityConfig> activityConfigList = this.lambdaQuery()
                .eq(TpmDeductionDetailMappingRelationActivityConfig::getDelFlag, DelFlagStatusEnum.NORMAL.getCode())
                .eq(TpmDeductionDetailMappingRelationActivityConfig::getTenantCode, tenantCode)
                .in(TpmDeductionDetailMappingRelationActivityConfig::getCode, codeList)
                .list();
        Collection<TpmDeductionDetailMappingRelationActivityConfigVo> vos = this.nebulaToolkitService.copyCollectionByWhiteList(activityConfigList, TpmDeductionDetailMappingRelationActivityConfig.class, TpmDeductionDetailMappingRelationActivityConfigVo.class, LinkedHashSet.class, ArrayList.class);
        return Lists.newArrayList(vos);
    }
}
