/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.tpm.business.deduction.detail.mapping.local.service.internal;

import cn.hutool.core.util.StrUtil;
import com.alibaba.fastjson.JSON;
import com.biz.crm.common.ie.sdk.excel.process.ImportProcess;
import com.biz.crm.common.ie.sdk.vo.TaskGlobalParamsVo;
import com.biz.crm.mdm.business.customer.retailer.sdk.service.CustomerRetailerVoService;
import com.biz.crm.mdm.business.customer.retailer.sdk.vo.CustomerRetailerVo;
import com.biz.crm.mdm.business.customer.sdk.service.CustomerVoService;
import com.biz.crm.mdm.business.customer.sdk.vo.CustomerVo;
import com.biz.crm.mdm.business.sales.org.sdk.service.SalesOrgVoService;
import com.biz.crm.mdm.business.sales.org.sdk.vo.SalesOrgVo;
import com.biz.crm.mn.common.base.eunm.BusinessFormatEnum;
import com.biz.crm.mn.common.base.eunm.BusinessUnitEnum;
import com.biz.crm.tpm.business.activity.form.sdk.service.ActivityFormService;
import com.biz.crm.tpm.business.activity.form.sdk.vo.ActivityFormVo;
import com.biz.crm.tpm.business.deduction.detail.mapping.sdk.dto.TpmDeductionDetailMappingCustomerDto;
import com.biz.crm.tpm.business.deduction.detail.mapping.sdk.dto.TpmDeductionDetailMappingDto;
import com.biz.crm.tpm.business.deduction.detail.mapping.sdk.dto.TpmDeductionDetailMappingRelationActivityConfigDto;
import com.biz.crm.tpm.business.deduction.detail.mapping.sdk.dto.TpmDeductionDetailMappingTextDto;
import com.biz.crm.tpm.business.deduction.detail.mapping.sdk.service.TpmDeductionDetailMappingService;
import com.biz.crm.tpm.business.deduction.detail.mapping.sdk.vo.TpmDeductionDetailMappingImportsVo;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;

@Component
public class TpmDeductionDetailMappingImportsProcess
implements ImportProcess<TpmDeductionDetailMappingImportsVo> {
    private static final Logger log = LoggerFactory.getLogger(TpmDeductionDetailMappingImportsProcess.class);
    @Autowired(required=false)
    TpmDeductionDetailMappingService tpmDeductionDetailMappingService;
    @Autowired(required=false)
    private NebulaToolkitService nebulaToolkitService;
    @Resource
    private ActivityFormService activityFormService;
    @Autowired(required=false)
    private SalesOrgVoService salesOrgVoService;
    @Autowired(required=false)
    private CustomerVoService customerVoService;
    @Autowired(required=false)
    private CustomerRetailerVoService customerRetailerVoService;
    private static final String DEFAULT_CHANNEL_CODE = "A1";

    @Transactional
    public Map<Integer, String> execute(LinkedHashMap<Integer, TpmDeductionDetailMappingImportsVo> data, TaskGlobalParamsVo paramsVo, Map<String, Object> params) {
        log.info("\u5546\u8d85\u6263\u8d39\u6620\u5c04\u5bfc\u5165\u5f00\u59cb\u6267\u884c\uff0c\u53c2\u6570\u3010{}\u3011", (Object)JSON.toJSONString(data));
        try {
            Validate.notEmpty(data, (String)"\u5bfc\u5165\u6570\u636e\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
            this.baseValidate(data);
            this.validateRepeatAndSave(data);
        }
        catch (Exception e) {
            log.error("\u5546\u8d85\u6263\u8d39\u6620\u5c04\u5bfc\u5165\u5f02\u5e38,{}", (Throwable)e);
            if (StrUtil.isEmpty((CharSequence)e.getMessage())) {
                throw new IllegalArgumentException("\u7a7a\u6307\u9488\u5f02\u5e38", e);
            }
            throw new IllegalArgumentException(e.getMessage(), e);
        }
        return null;
    }

    private void baseValidate(LinkedHashMap<Integer, TpmDeductionDetailMappingImportsVo> data) {
        log.info("\u5546\u8d85\u6263\u8d39\u6620\u5c04\u5bfc\u5165,\u6821\u9a8c\u6570\u636e");
        data.forEach((index, importsVo) -> {
            Validate.notBlank((CharSequence)importsVo.getName(), (String)"\u6620\u5c04\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
            Validate.isTrue((importsVo.getName().length() <= 255 ? 1 : 0) != 0, (String)"\u6263\u8d39\u6620\u5c04\u540d\u79f0\u8d85\u957f\uff0c\u6700\u957f\u652f\u6301255", (Object[])new Object[0]);
            Validate.notBlank((CharSequence)importsVo.getBusinessUnitCode(), (String)"\u4e1a\u52a1\u5355\u5143\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
            Validate.notBlank((CharSequence)importsVo.getBusinessFormatCode(), (String)"\u4e1a\u6001\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
            Validate.notBlank((CharSequence)importsVo.getResaleCommercialCode(), (String)"\u96f6\u552e\u5546\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
            Validate.notBlank((CharSequence)importsVo.getDeductionDetailItems(), (String)"\u6263\u8d39\u660e\u7ec6\u9879\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
            Validate.notBlank((CharSequence)importsVo.getRelationActivityFormCodes(), (String)"\u5173\u8054\u6d3b\u52a8\u5f62\u5f0f\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        });
    }

    private void validateRepeatAndSave(LinkedHashMap<Integer, TpmDeductionDetailMappingImportsVo> data) {
        log.info("\u5546\u8d85\u6263\u8d39\u6620\u5c04\u5bfc\u5165\u5f00\u59cb\u8f6c\u6362\u6570\u636e");
        ArrayList<TpmDeductionDetailMappingImportsVo> importsVos = new ArrayList<TpmDeductionDetailMappingImportsVo>(data.values());
        if (CollectionUtils.isEmpty(importsVos)) {
            return;
        }
        HashSet salesInstitutionCodes = new HashSet();
        HashSet customerCodes = new HashSet();
        HashSet activityFormCodes = new HashSet();
        HashSet resaleCommercialCodes = new HashSet();
        importsVos.forEach(i -> {
            int a;
            String[] split;
            BusinessFormatEnum businessFormatEnum = BusinessFormatEnum.descToEnum((String)i.getBusinessFormatCode().trim());
            Validate.notNull((Object)businessFormatEnum, (String)("\u672a\u77e5\u7684\u4e1a\u6001\uff01\u3010" + i.getBusinessFormatCode() + "\u3011"), (Object[])new Object[0]);
            i.setBusinessFormatCode(businessFormatEnum.getCode());
            BusinessUnitEnum businessUnitEnum = BusinessUnitEnum.descToEnum((String)i.getBusinessUnitCode().trim());
            Validate.notNull((Object)businessUnitEnum, (String)("\u672a\u77e5\u7684\u4e1a\u52a1\u5355\u5143\uff01\u3010" + i.getBusinessFormatCode() + "\u3011"), (Object[])new Object[0]);
            i.setBusinessUnitCode(businessUnitEnum.getCode());
            String firstChannelCode = DEFAULT_CHANNEL_CODE;
            if (BusinessUnitEnum.SON_COMPANY.getCode().equals(i.getBusinessUnitCode()) && StringUtils.isNotBlank((CharSequence)i.getChannelCode())) {
                firstChannelCode = i.getChannelCode();
            }
            if (BusinessUnitEnum.VERTICAL.getCode().equals(i.getBusinessUnitCode()) && StringUtils.isNotBlank((CharSequence)i.getFirstChannelCode())) {
                firstChannelCode = i.getFirstChannelCode();
            }
            if (StringUtils.isNotBlank((CharSequence)i.getSalesInstitutionErpCode())) {
                String salesInstitutionCode = firstChannelCode + i.getBusinessFormatCode() + i.getSalesInstitutionErpCode();
                salesInstitutionCodes.add(salesInstitutionCode);
            }
            if (StringUtils.isNotBlank((CharSequence)i.getErpCode())) {
                Validate.notBlank((CharSequence)i.getSalesInstitutionErpCode(), (String)"\u586b\u5199\u4e86\u5ba2\u6237\u4fe1\u606f\uff0c\u5fc5\u987b\u586b\u5199\u9500\u552e\u673a\u6784\u4fe1\u606f\uff01", (Object[])new Object[0]);
                split = i.getErpCode().split(",");
                for (a = 0; a < split.length; ++a) {
                    String customerCode = split[a] + i.getSalesInstitutionErpCode() + firstChannelCode + i.getBusinessFormatCode();
                    customerCodes.add(customerCode);
                }
            }
            if (StringUtils.isNotBlank((CharSequence)i.getRelationActivityFormCodes())) {
                split = i.getRelationActivityFormCodes().split(",");
                for (a = 0; a < split.length; ++a) {
                    activityFormCodes.add(split[a]);
                }
            }
            if (StringUtils.isNotBlank((CharSequence)i.getResaleCommercialCode())) {
                resaleCommercialCodes.add(i.getResaleCommercialCode());
            }
        });
        Map<Object, Object> salesOrgVoMap = new HashMap();
        if (!CollectionUtils.isEmpty(salesInstitutionCodes)) {
            List salesOrgVoList = this.salesOrgVoService.findBySalesOrgCodesPost(new ArrayList(salesInstitutionCodes));
            Validate.notEmpty((Collection)salesOrgVoList, (String)"\u6839\u636e\u586b\u5199\u7684\u6240\u6709\u9500\u552e\u673a\u6784\u7f16\u7801\uff0c\u672a\u67e5\u8be2\u5230\u4efb\u4f55\u9500\u552e\u673a\u6784\uff01", (Object[])new Object[0]);
            if (!CollectionUtils.isEmpty((Collection)salesOrgVoList)) {
                salesOrgVoMap = salesOrgVoList.stream().collect(Collectors.toMap(SalesOrgVo::getSalesOrgCode, Function.identity(), (v1, v2) -> v2));
            }
        }
        Map<Object, Object> customerVoMap = new HashMap();
        if (!CollectionUtils.isEmpty(customerCodes)) {
            List customerVoList = this.customerVoService.findBaseByCustomerCodes(new ArrayList(customerCodes));
            Validate.notEmpty((Collection)customerVoList, (String)"\u6839\u636e\u586b\u5199\u7684\u6240\u6709\u5ba2\u6237\u7f16\u7801\uff0c\u672a\u67e5\u8be2\u5230\u4efb\u4f55\u5ba2\u6237\u4fe1\u606f\uff01", (Object[])new Object[0]);
            if (!CollectionUtils.isEmpty((Collection)customerVoList)) {
                customerVoMap = customerVoList.stream().collect(Collectors.toMap(CustomerVo::getCustomerCode, Function.identity(), (v1, v2) -> v2));
            }
        }
        Map<Object, Object> activityFormVoMap = new HashMap();
        if (!CollectionUtils.isEmpty(activityFormCodes)) {
            List activityFormVoList = this.activityFormService.findFormAndRelatedTypeCodes(new ArrayList(activityFormCodes), TenantUtils.getTenantCode());
            Validate.notEmpty((Collection)activityFormVoList, (String)"\u6839\u636e\u586b\u5199\u7684\u6240\u6709\u6d3b\u52a8\u5f62\u5f0f\u7f16\u7801\uff0c\u672a\u67e5\u8be2\u5230\u4efb\u4f55\u6d3b\u52a8\u5f62\u5f0f\uff01", (Object[])new Object[0]);
            if (!CollectionUtils.isEmpty((Collection)activityFormVoList)) {
                activityFormVoMap = activityFormVoList.stream().collect(Collectors.toMap(ActivityFormVo::getActivityFormCode, Function.identity(), (v1, v2) -> v2));
            }
        }
        Map<Object, Object> retailerVoMap = new HashMap();
        if (!CollectionUtils.isEmpty(resaleCommercialCodes)) {
            List retailerVoList = this.customerRetailerVoService.findByCodes(new ArrayList(resaleCommercialCodes));
            Validate.notEmpty((Collection)retailerVoList, (String)"\u6839\u636e\u586b\u5199\u7684\u6240\u6709\u96f6\u552e\u5546\u7f16\u7801\uff0c\u672a\u67e5\u8be2\u5230\u96f6\u552e\u5546\u4fe1\u606f\uff01", (Object[])new Object[0]);
            if (!CollectionUtils.isEmpty((Collection)retailerVoList)) {
                retailerVoMap = retailerVoList.stream().collect(Collectors.toMap(CustomerRetailerVo::getCustomerRetailerCode, Function.identity(), (v1, v2) -> v2));
            }
        }
        ArrayList<TpmDeductionDetailMappingDto> mappingDtoList = new ArrayList<TpmDeductionDetailMappingDto>(importsVos.size());
        for (TpmDeductionDetailMappingImportsVo importsVo : importsVos) {
            String[] split;
            TpmDeductionDetailMappingDto mappingDto = new TpmDeductionDetailMappingDto();
            ArrayList<TpmDeductionDetailMappingCustomerDto> customerDtoList = new ArrayList<TpmDeductionDetailMappingCustomerDto>();
            ArrayList<TpmDeductionDetailMappingTextDto> textDtoList = new ArrayList<TpmDeductionDetailMappingTextDto>();
            ArrayList<TpmDeductionDetailMappingRelationActivityConfigDto> activityConfigDtoList = new ArrayList<TpmDeductionDetailMappingRelationActivityConfigDto>();
            mappingDto.setName(importsVo.getName());
            mappingDto.setChannelCode(importsVo.getChannelCode());
            mappingDto.setFirstChannelCode(importsVo.getFirstChannelCode());
            mappingDto.setSecondChannelCode(importsVo.getSecondChannelCode());
            mappingDto.setResaleCommercialCode(importsVo.getResaleCommercialCode());
            mappingDto.setResaleCommercialName(importsVo.getResaleCommercialName());
            mappingDto.setBusinessFormatCode(importsVo.getBusinessFormatCode());
            mappingDto.setBusinessUnitCode(importsVo.getBusinessUnitCode());
            String firstChannelCode = DEFAULT_CHANNEL_CODE;
            if (BusinessUnitEnum.SON_COMPANY.getCode().equals(importsVo.getBusinessUnitCode()) && StringUtils.isNotBlank((CharSequence)importsVo.getChannelCode())) {
                firstChannelCode = importsVo.getChannelCode();
            }
            if (BusinessUnitEnum.VERTICAL.getCode().equals(importsVo.getBusinessUnitCode()) && StringUtils.isNotBlank((CharSequence)importsVo.getFirstChannelCode())) {
                firstChannelCode = importsVo.getFirstChannelCode();
            }
            if (!CollectionUtils.isEmpty(salesOrgVoMap) && StringUtils.isNotBlank((CharSequence)importsVo.getSalesInstitutionErpCode())) {
                String salesInstitutionCode = firstChannelCode + importsVo.getBusinessFormatCode() + importsVo.getSalesInstitutionErpCode();
                SalesOrgVo salesOrgVo = (SalesOrgVo)salesOrgVoMap.get(salesInstitutionCode);
                Validate.notNull((Object)salesOrgVo, (String)("\u672a\u67e5\u8be2\u5230\u9500\u552e\u673a\u6784\uff01\u6e20\u9053\u3010" + firstChannelCode + "\u3011,\u4e1a\u6001\u3010" + importsVo.getBusinessFormatCode() + "\u3011,\u9500\u552e\u673a\u6784\u7f16\u7801\u3010" + importsVo.getSalesInstitutionErpCode() + "\u3011"), (Object[])new Object[0]);
                mappingDto.setSalesInstitutionCode(salesOrgVo.getSalesOrgCode());
                mappingDto.setSalesInstitutionErpCode(salesOrgVo.getErpCode());
                mappingDto.setSalesInstitutionName(salesOrgVo.getSalesOrgName());
            }
            if (!CollectionUtils.isEmpty(customerVoMap) && StringUtils.isNotBlank((CharSequence)importsVo.getErpCode())) {
                split = importsVo.getErpCode().split(",");
                for (int a = 0; a < split.length; ++a) {
                    String customerCode = split[a] + importsVo.getSalesInstitutionErpCode() + firstChannelCode + importsVo.getBusinessFormatCode();
                    CustomerVo customerVo = (CustomerVo)customerVoMap.get(customerCode);
                    Validate.notNull((Object)customerVo, (String)("\u672a\u67e5\u8be2\u5230\u5ba2\u6237\uff01\u6e20\u9053\u3010" + firstChannelCode + "\u3011,\u4e1a\u6001\u3010" + importsVo.getBusinessFormatCode() + "\u3011,\u5ba2\u6237\u7f16\u7801\u3010" + split[a] + "\u3011"), (Object[])new Object[0]);
                    TpmDeductionDetailMappingCustomerDto customerDto = new TpmDeductionDetailMappingCustomerDto();
                    customerDto.setCustomerCode(customerVo.getCustomerCode());
                    customerDto.setErpCode(customerVo.getErpCode());
                    customerDto.setCustomerName(customerVo.getCustomerName());
                    customerDtoList.add(customerDto);
                }
            }
            if (StringUtils.isNotBlank((CharSequence)importsVo.getDeductionDetailItems())) {
                split = importsVo.getDeductionDetailItems().split(",");
                for (int a = 0; a < split.length; ++a) {
                    Validate.isTrue((split[a].length() <= 255 ? 1 : 0) != 0, (String)("\u6263\u8d39\u660e\u7ec6\u9879\u540d\u79f0\u3010" + split[a] + "\u3011\u8d85\u957f\uff0c\u6700\u957f\u652f\u6301255"), (Object[])new Object[0]);
                    TpmDeductionDetailMappingTextDto textDto = new TpmDeductionDetailMappingTextDto();
                    textDto.setText(split[a]);
                    textDtoList.add(textDto);
                }
            }
            if (!CollectionUtils.isEmpty(activityFormVoMap) && StringUtils.isNotBlank((CharSequence)importsVo.getRelationActivityFormCodes())) {
                split = importsVo.getRelationActivityFormCodes().split(",");
                for (int a = 0; a < split.length; ++a) {
                    ActivityFormVo activityFormVo = (ActivityFormVo)activityFormVoMap.get(split[a]);
                    Validate.notNull((Object)activityFormVo, (String)("\u672a\u67e5\u8be2\u5230\u6d3b\u52a8\u5f62\u5f0f\uff01" + split[a]), (Object[])new Object[0]);
                    TpmDeductionDetailMappingRelationActivityConfigDto configDto = new TpmDeductionDetailMappingRelationActivityConfigDto();
                    configDto.setActivityFormCode(activityFormVo.getActivityFormCode());
                    configDto.setActivityFormName(activityFormVo.getActivityFormName());
                    configDto.setActivityTypeCode(activityFormVo.getActivityTypeCode());
                    configDto.setActivityTypeName(activityFormVo.getActivityTypeName());
                    activityConfigDtoList.add(configDto);
                }
            }
            if (!CollectionUtils.isEmpty(retailerVoMap) && StringUtils.isNotBlank((CharSequence)importsVo.getResaleCommercialCode())) {
                CustomerRetailerVo customerRetailerVo = (CustomerRetailerVo)retailerVoMap.get(importsVo.getResaleCommercialCode());
                Validate.notNull((Object)customerRetailerVo, (String)("\u672a\u77e5\u7684\u96f6\u552e\u5546\uff01\u3010" + importsVo.getResaleCommercialCode() + "\u3011"), (Object[])new Object[0]);
                mappingDto.setResaleCommercialCode(customerRetailerVo.getCustomerRetailerCode());
                mappingDto.setResaleCommercialName(customerRetailerVo.getCustomerRetailerName());
            }
            mappingDto.setCustomerList(customerDtoList);
            mappingDto.setDeductionDetailMappingTextList(textDtoList);
            mappingDto.setDeductionDetailMappingRelationActivityConfigList(activityConfigDtoList);
            mappingDtoList.add(mappingDto);
        }
        log.info("\u5f00\u59cb\u4fdd\u5b58");
        this.tpmDeductionDetailMappingService.importSave(mappingDtoList);
    }

    public Class<TpmDeductionDetailMappingImportsVo> findCrmExcelVoClass() {
        return TpmDeductionDetailMappingImportsVo.class;
    }

    public String getTemplateCode() {
        return "TPM_DEDUCTION_DETAIL_MAPPING_IMPORT";
    }

    public String getTemplateName() {
        return "TPM-\u5546\u8d85\u6263\u8d39\u660e\u7ec6\u6620\u5c04";
    }
}

