/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.tpm.business.deduction.detail.mapping.local.service.internal;

import com.alibaba.fastjson.JSON;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.conditions.query.LambdaQueryChainWrapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.business.common.local.entity.TenantFlagOpEntity;
import com.biz.crm.business.common.local.entity.UuidEntity;
import com.biz.crm.business.common.local.entity.UuidFlagOpEntity;
import com.biz.crm.business.common.sdk.enums.DelFlagStatusEnum;
import com.biz.crm.business.common.sdk.service.GenerateCodeService;
import com.biz.crm.mn.common.base.eunm.BusinessUnitEnum;
import com.biz.crm.mn.common.base.service.RedisLockService;
import com.biz.crm.tpm.business.deduction.detail.mapping.local.entity.TpmDeductionDetailMapping;
import com.biz.crm.tpm.business.deduction.detail.mapping.local.entity.TpmDeductionDetailMappingCustomer;
import com.biz.crm.tpm.business.deduction.detail.mapping.local.entity.TpmDeductionDetailMappingRelationActivityConfig;
import com.biz.crm.tpm.business.deduction.detail.mapping.local.entity.TpmDeductionDetailMappingText;
import com.biz.crm.tpm.business.deduction.detail.mapping.local.repository.TpmDeductionDetailMappingCustomerRepository;
import com.biz.crm.tpm.business.deduction.detail.mapping.local.repository.TpmDeductionDetailMappingRelationActivityConfigRepository;
import com.biz.crm.tpm.business.deduction.detail.mapping.local.repository.TpmDeductionDetailMappingRepository;
import com.biz.crm.tpm.business.deduction.detail.mapping.local.repository.TpmDeductionDetailMappingTextRepository;
import com.biz.crm.tpm.business.deduction.detail.mapping.sdk.dto.TpmDeductionDetailMappingCustomerDto;
import com.biz.crm.tpm.business.deduction.detail.mapping.sdk.dto.TpmDeductionDetailMappingDto;
import com.biz.crm.tpm.business.deduction.detail.mapping.sdk.dto.TpmDeductionDetailMappingEventDto;
import com.biz.crm.tpm.business.deduction.detail.mapping.sdk.dto.TpmDeductionDetailMappingRelationActivityConfigDto;
import com.biz.crm.tpm.business.deduction.detail.mapping.sdk.dto.TpmDeductionDetailMappingTextDto;
import com.biz.crm.tpm.business.deduction.detail.mapping.sdk.dto.log.TpmDeductionDetailMappingLogEventDto;
import com.biz.crm.tpm.business.deduction.detail.mapping.sdk.event.log.TpmDeductionDetailMappingEvent;
import com.biz.crm.tpm.business.deduction.detail.mapping.sdk.event.log.TpmDeductionDetailMappingLogEventListener;
import com.biz.crm.tpm.business.deduction.detail.mapping.sdk.service.TpmDeductionDetailMappingService;
import com.biz.crm.tpm.business.deduction.detail.mapping.sdk.vo.TpmDeductionDetailMappingCustomerVo;
import com.biz.crm.tpm.business.deduction.detail.mapping.sdk.vo.TpmDeductionDetailMappingRelationActivityConfigVo;
import com.biz.crm.tpm.business.deduction.detail.mapping.sdk.vo.TpmDeductionDetailMappingTextVo;
import com.biz.crm.tpm.business.deduction.detail.mapping.sdk.vo.TpmDeductionDetailMappingVo;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import com.bizunited.nebula.event.sdk.function.SerializableBiConsumer;
import com.bizunited.nebula.event.sdk.service.NebulaEventDto;
import com.bizunited.nebula.event.sdk.service.NebulaNetEventClient;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service(value="tpmDeductionDetailMappingService")
public class TpmDeductionDetailMappingServiceImpl
implements TpmDeductionDetailMappingService {
    private static final Logger log = LoggerFactory.getLogger(TpmDeductionDetailMappingServiceImpl.class);
    @Autowired(required=false)
    private TpmDeductionDetailMappingRepository tpmDeductionDetailMappingRepository;
    @Autowired(required=false)
    private NebulaToolkitService nebulaToolkitService;
    @Autowired(required=false)
    private NebulaNetEventClient nebulaNetEventClient;
    @Autowired(required=false)
    private GenerateCodeService generateCodeService;
    @Autowired(required=false)
    private TpmDeductionDetailMappingRelationActivityConfigRepository deductionDetailMappingRelationActivityConfigRepository;
    @Autowired(required=false)
    private TpmDeductionDetailMappingTextRepository deductionDetailMappingTextRepository;
    @Autowired(required=false)
    private RedisLockService redisLockService;
    @Autowired(required=false)
    private TpmDeductionDetailMappingCustomerRepository tpmDeductionDetailMappingCustomerRepository;

    public Page<TpmDeductionDetailMappingVo> findByConditions(Pageable pageable, TpmDeductionDetailMappingDto dto) {
        pageable = (Pageable)ObjectUtils.defaultIfNull((Object)pageable, (Object)PageRequest.of((int)1, (int)50));
        if (Objects.isNull(dto)) {
            dto = new TpmDeductionDetailMappingDto();
        }
        String tenantCode = TenantUtils.getTenantCode();
        dto.setTenantCode(tenantCode);
        return this.tpmDeductionDetailMappingRepository.findByConditions(pageable, dto);
    }

    public List<TpmDeductionDetailMappingVo> findByCodes(List<String> codeList) {
        if (CollectionUtils.isEmpty(codeList)) {
            return Lists.newArrayList();
        }
        List<String> distinctCodeList = codeList.stream().distinct().collect(Collectors.toList());
        String tenantCode = TenantUtils.getTenantCode();
        List<TpmDeductionDetailMappingCustomerVo> customerVoList = this.tpmDeductionDetailMappingCustomerRepository.findByCodes(distinctCodeList, tenantCode);
        Map<String, List<TpmDeductionDetailMappingCustomerVo>> customerMap = customerVoList.stream().collect(Collectors.groupingBy(TpmDeductionDetailMappingCustomerVo::getCode));
        List<TpmDeductionDetailMappingVo> detailMappingVoList = this.tpmDeductionDetailMappingRepository.findByCodes(distinctCodeList, tenantCode);
        List<TpmDeductionDetailMappingRelationActivityConfigVo> activityConfigVoList = this.deductionDetailMappingRelationActivityConfigRepository.findByCodes(distinctCodeList, tenantCode);
        List<TpmDeductionDetailMappingTextVo> textVoList = this.deductionDetailMappingTextRepository.findByCodes(distinctCodeList, tenantCode);
        Map<String, List<TpmDeductionDetailMappingRelationActivityConfigVo>> codeToActivityConfigVoList = activityConfigVoList.stream().collect(Collectors.groupingBy(TpmDeductionDetailMappingRelationActivityConfigVo::getCode));
        Map<String, List<TpmDeductionDetailMappingTextVo>> codeToTextVoList = textVoList.stream().collect(Collectors.groupingBy(TpmDeductionDetailMappingTextVo::getCode));
        detailMappingVoList.forEach(e -> {
            e.setDeductionDetailMappingRelationActivityConfigList((List)codeToActivityConfigVoList.getOrDefault(e.getCode(), Lists.newArrayList()));
            e.setDeductionDetailMappingTextList((List)codeToTextVoList.getOrDefault(e.getCode(), Lists.newArrayList()));
            e.setCustomerList((List)customerMap.getOrDefault(e.getCode(), Lists.newArrayList()));
        });
        return detailMappingVoList;
    }

    @Transactional(rollbackFor={Exception.class})
    public TpmDeductionDetailMappingVo create(TpmDeductionDetailMappingDto dto) {
        this.createValidate(dto);
        if (!BusinessUnitEnum.SON_COMPANY.getCode().equals(dto.getBusinessUnitCode())) {
            this.repeatValidate(Lists.newArrayList((Object[])new TpmDeductionDetailMappingDto[]{dto}));
        }
        String tenantCode = TenantUtils.getTenantCode();
        dto.setTenantCode(tenantCode);
        dto.setDelFlag(DelFlagStatusEnum.NORMAL.getCode());
        String code = (String)this.generateCodeService.generateCode("KFPP", 1, Integer.valueOf(5), 2L, TimeUnit.DAYS).get(0);
        dto.setCode(code);
        TpmDeductionDetailMapping entity = (TpmDeductionDetailMapping)((Object)this.nebulaToolkitService.copyObjectByWhiteList((Object)dto, TpmDeductionDetailMapping.class, LinkedHashSet.class, ArrayList.class, new String[0]));
        dto.setId(entity.getId());
        this.tpmDeductionDetailMappingRepository.saveOrUpdate((Object)entity);
        ArrayList<TpmDeductionDetailMappingRelationActivityConfig> configList = new ArrayList<TpmDeductionDetailMappingRelationActivityConfig>();
        Set formCodes = dto.getDeductionDetailMappingRelationActivityConfigList().stream().map(TpmDeductionDetailMappingRelationActivityConfigDto::getActivityFormCode).collect(Collectors.toSet());
        Validate.isTrue((formCodes.size() == dto.getDeductionDetailMappingRelationActivityConfigList().size() ? 1 : 0) != 0, (String)"\u6d3b\u52a8\u5f62\u5f0f\u91cd\u590d\uff01", (Object[])new Object[0]);
        for (Object tpmDeductionDetailMappingRelationActivityConfigDto : dto.getDeductionDetailMappingRelationActivityConfigList()) {
            TpmDeductionDetailMappingRelationActivityConfig config = new TpmDeductionDetailMappingRelationActivityConfig();
            config.setCode(code);
            config.setTenantCode(tenantCode);
            config.setActivityTypeCode(tpmDeductionDetailMappingRelationActivityConfigDto.getActivityTypeCode());
            config.setActivityTypeName(tpmDeductionDetailMappingRelationActivityConfigDto.getActivityTypeName());
            config.setActivityFormCode(tpmDeductionDetailMappingRelationActivityConfigDto.getActivityFormCode());
            config.setActivityFormName(tpmDeductionDetailMappingRelationActivityConfigDto.getActivityFormName());
            configList.add(config);
        }
        this.deductionDetailMappingRelationActivityConfigRepository.saveBatch(configList);
        ArrayList<TpmDeductionDetailMappingText> textList = new ArrayList<TpmDeductionDetailMappingText>();
        for (Object textDto : dto.getDeductionDetailMappingTextList()) {
            TpmDeductionDetailMappingText text = new TpmDeductionDetailMappingText();
            text.setCode(code);
            text.setText(textDto.getText());
            text.setTenantCode(tenantCode);
            textList.add(text);
        }
        this.deductionDetailMappingTextRepository.saveBatch(textList);
        ArrayList<TpmDeductionDetailMappingCustomer> customerList = new ArrayList<TpmDeductionDetailMappingCustomer>();
        if (CollectionUtils.isNotEmpty((Collection)dto.getCustomerList())) {
            for (TpmDeductionDetailMappingCustomerDto customerDto : dto.getCustomerList()) {
                TpmDeductionDetailMappingCustomer customer = new TpmDeductionDetailMappingCustomer();
                customer.setCode(code);
                customer.setCustomerCode(customerDto.getCustomerCode());
                customer.setCustomerName(customerDto.getCustomerName());
                customer.setErpCode(customerDto.getErpCode());
                customer.setTenantCode(TenantUtils.getTenantCode());
                customer.setDelFlag(DelFlagStatusEnum.NORMAL.getCode());
                customerList.add(customer);
            }
        }
        if (CollectionUtils.isNotEmpty(customerList)) {
            this.tpmDeductionDetailMappingCustomerRepository.saveBatch(customerList);
        }
        TpmDeductionDetailMappingLogEventDto logEventDto = new TpmDeductionDetailMappingLogEventDto();
        logEventDto.setOriginal(null);
        logEventDto.setNewest(dto);
        SerializableBiConsumer & Serializable onCreate = TpmDeductionDetailMappingLogEventListener::onCreate;
        this.nebulaNetEventClient.publish((NebulaEventDto)logEventDto, TpmDeductionDetailMappingLogEventListener.class, (SerializableBiConsumer)onCreate);
        return null;
    }

    @Transactional(rollbackFor={Exception.class})
    public TpmDeductionDetailMappingVo update(TpmDeductionDetailMappingDto dto) {
        this.updateValidate(dto);
        TpmDeductionDetailMapping oldEntity = (TpmDeductionDetailMapping)((Object)this.tpmDeductionDetailMappingRepository.getById((Serializable)((Object)dto.getId())));
        if (ObjectUtils.isEmpty((Object)((Object)oldEntity))) {
            throw new RuntimeException("\u6570\u636e\u4e0d\u5b58\u5728\uff0c\u8bf7\u5237\u65b0\u540e\u91cd\u8bd5\uff01");
        }
        if (!BusinessUnitEnum.SON_COMPANY.getCode().equals(dto.getBusinessUnitCode())) {
            this.repeatValidate(Lists.newArrayList((Object[])new TpmDeductionDetailMappingDto[]{dto}));
        }
        String tenantCode = TenantUtils.getTenantCode();
        TpmDeductionDetailMapping entity = (TpmDeductionDetailMapping)((Object)this.nebulaToolkitService.copyObjectByWhiteList((Object)dto, TpmDeductionDetailMapping.class, LinkedHashSet.class, ArrayList.class, new String[0]));
        if (StringUtils.isBlank((CharSequence)entity.getSalesInstitutionCode())) {
            entity.setSalesInstitutionCode("");
            entity.setSalesInstitutionErpCode("");
            entity.setSalesInstitutionName("");
        }
        if (StringUtils.isBlank((CharSequence)entity.getResaleCommercialCode())) {
            entity.setResaleCommercialCode("");
            entity.setResaleCommercialName("");
        }
        this.tpmDeductionDetailMappingRepository.saveOrUpdate((Object)entity);
        this.deductionDetailMappingRelationActivityConfigRepository.remove((Wrapper)((LambdaUpdateWrapper)Wrappers.lambdaUpdate(TpmDeductionDetailMappingRelationActivityConfig.class).eq(TpmDeductionDetailMappingRelationActivityConfig::getCode, (Object)oldEntity.getCode())).eq(TenantFlagOpEntity::getTenantCode, (Object)tenantCode));
        this.deductionDetailMappingTextRepository.remove((Wrapper)((LambdaUpdateWrapper)Wrappers.lambdaUpdate(TpmDeductionDetailMappingText.class).eq(TpmDeductionDetailMappingText::getCode, (Object)oldEntity.getCode())).eq(TenantFlagOpEntity::getTenantCode, (Object)tenantCode));
        ArrayList<TpmDeductionDetailMappingRelationActivityConfig> configList = new ArrayList<TpmDeductionDetailMappingRelationActivityConfig>();
        for (Object tpmDeductionDetailMappingRelationActivityConfigDto : dto.getDeductionDetailMappingRelationActivityConfigList()) {
            TpmDeductionDetailMappingRelationActivityConfig config = new TpmDeductionDetailMappingRelationActivityConfig();
            config.setCode(oldEntity.getCode());
            config.setTenantCode(tenantCode);
            config.setActivityTypeCode(tpmDeductionDetailMappingRelationActivityConfigDto.getActivityTypeCode());
            config.setActivityTypeName(tpmDeductionDetailMappingRelationActivityConfigDto.getActivityTypeName());
            config.setActivityFormCode(tpmDeductionDetailMappingRelationActivityConfigDto.getActivityFormCode());
            config.setActivityFormName(tpmDeductionDetailMappingRelationActivityConfigDto.getActivityFormName());
            configList.add(config);
        }
        this.deductionDetailMappingRelationActivityConfigRepository.saveBatch(configList);
        ArrayList<TpmDeductionDetailMappingText> textList = new ArrayList<TpmDeductionDetailMappingText>();
        for (Object textDto : dto.getDeductionDetailMappingTextList()) {
            TpmDeductionDetailMappingText text = new TpmDeductionDetailMappingText();
            text.setCode(oldEntity.getCode());
            text.setText(textDto.getText());
            text.setTenantCode(tenantCode);
            textList.add(text);
        }
        this.deductionDetailMappingTextRepository.saveBatch(textList);
        this.tpmDeductionDetailMappingCustomerRepository.remove((Wrapper)((LambdaUpdateWrapper)Wrappers.lambdaUpdate(TpmDeductionDetailMappingCustomer.class).eq(TpmDeductionDetailMappingCustomer::getCode, (Object)oldEntity.getCode())).eq(TenantFlagOpEntity::getTenantCode, (Object)tenantCode));
        ArrayList<TpmDeductionDetailMappingCustomer> customerList = new ArrayList<TpmDeductionDetailMappingCustomer>();
        if (CollectionUtils.isNotEmpty((Collection)dto.getCustomerList())) {
            for (TpmDeductionDetailMappingCustomerDto customerDto : dto.getCustomerList()) {
                TpmDeductionDetailMappingCustomer customer = new TpmDeductionDetailMappingCustomer();
                customer.setCode(oldEntity.getCode());
                customer.setCustomerCode(customerDto.getCustomerCode());
                customer.setCustomerName(customerDto.getCustomerName());
                customer.setErpCode(customerDto.getErpCode());
                customer.setTenantCode(TenantUtils.getTenantCode());
                customer.setDelFlag(DelFlagStatusEnum.NORMAL.getCode());
                customerList.add(customer);
            }
        }
        if (CollectionUtils.isNotEmpty(customerList)) {
            this.tpmDeductionDetailMappingCustomerRepository.saveBatch(customerList);
        }
        SerializableBiConsumer & Serializable update = TpmDeductionDetailMappingEvent::onUpdate;
        TpmDeductionDetailMappingEventDto eventDto = new TpmDeductionDetailMappingEventDto();
        eventDto.setCode(entity.getCode());
        eventDto.setSalesInstitutionCode(entity.getSalesInstitutionCode());
        eventDto.setSalesInstitutionErpCode(entity.getSalesInstitutionErpCode());
        eventDto.setSalesInstitutionName(entity.getSalesInstitutionName());
        eventDto.setResaleCommercialCode(entity.getResaleCommercialCode());
        eventDto.setResaleCommercialName(entity.getResaleCommercialName());
        this.nebulaNetEventClient.publish((NebulaEventDto)eventDto, TpmDeductionDetailMappingEvent.class, (SerializableBiConsumer)update);
        TpmDeductionDetailMappingLogEventDto logEventDto = new TpmDeductionDetailMappingLogEventDto();
        TpmDeductionDetailMappingDto old = (TpmDeductionDetailMappingDto)this.nebulaToolkitService.copyObjectByWhiteList((Object)oldEntity, TpmDeductionDetailMappingDto.class, LinkedHashSet.class, ArrayList.class, new String[0]);
        logEventDto.setOriginal(old);
        logEventDto.setNewest(dto);
        SerializableBiConsumer & Serializable onUpdate = TpmDeductionDetailMappingLogEventListener::onUpdate;
        this.nebulaNetEventClient.publish((NebulaEventDto)logEventDto, TpmDeductionDetailMappingLogEventListener.class, (SerializableBiConsumer)onUpdate);
        return (TpmDeductionDetailMappingVo)this.nebulaToolkitService.copyObjectByWhiteList((Object)dto, TpmDeductionDetailMappingVo.class, LinkedHashSet.class, ArrayList.class, new String[0]);
    }

    @Transactional(rollbackFor={Exception.class})
    public void delete(List<String> idList) {
        Validate.isTrue((!CollectionUtils.isEmpty(idList) ? 1 : 0) != 0, (String)"\u5220\u9664\u6570\u636e\u65f6\uff0c\u4e3b\u952e\u96c6\u5408\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        String tenantCode = TenantUtils.getTenantCode();
        List<TpmDeductionDetailMapping> entities = this.tpmDeductionDetailMappingRepository.listByIds(idList).stream().filter(e -> tenantCode.equals(e.getTenantCode())).collect(Collectors.toList());
        if (!CollectionUtils.isEmpty(entities)) {
            entities.forEach(entity -> entity.setDelFlag(DelFlagStatusEnum.DELETE.getCode()));
            this.tpmDeductionDetailMappingRepository.updateBatchById(entities);
        }
    }

    public void importSave(List<TpmDeductionDetailMappingDto> importList) {
        if (CollectionUtils.isEmpty(importList)) {
            return;
        }
        log.info("\u6263\u8d39\u6620\u5c04\u5bfc\u5165\u4fdd\u5b58\u5f00\u59cb");
        ArrayList<TpmDeductionDetailMapping> entityList = new ArrayList<TpmDeductionDetailMapping>();
        ArrayList<TpmDeductionDetailMappingRelationActivityConfig> configList = new ArrayList<TpmDeductionDetailMappingRelationActivityConfig>();
        ArrayList<TpmDeductionDetailMappingText> textList = new ArrayList<TpmDeductionDetailMappingText>();
        ArrayList<TpmDeductionDetailMappingCustomer> customerList = new ArrayList<TpmDeductionDetailMappingCustomer>();
        String tenantCode = TenantUtils.getTenantCode();
        List codes = this.generateCodeService.generateCode("KFPP", importList.size(), Integer.valueOf(5), 2L, TimeUnit.DAYS);
        int i = 0;
        for (TpmDeductionDetailMappingDto dto : importList) {
            this.createValidate(dto);
            dto.setTenantCode(tenantCode);
            String code = (String)codes.get(i);
            Validate.notBlank((CharSequence)code, (String)"\u6263\u8d39\u6620\u5c04\u5bfc\u5165\u4fdd\u5b58\u65f6\uff0c\u751f\u6210\u6620\u5c04\u7f16\u7801\u5931\u8d25", (Object[])new Object[0]);
            dto.setCode(code);
            ++i;
            TpmDeductionDetailMapping entity = (TpmDeductionDetailMapping)((Object)this.nebulaToolkitService.copyObjectByWhiteList((Object)dto, TpmDeductionDetailMapping.class, HashSet.class, ArrayList.class, new String[0]));
            entityList.add(entity);
            Set formCodes = dto.getDeductionDetailMappingRelationActivityConfigList().stream().map(TpmDeductionDetailMappingRelationActivityConfigDto::getActivityFormCode).collect(Collectors.toSet());
            Validate.isTrue((formCodes.size() == dto.getDeductionDetailMappingRelationActivityConfigList().size() ? 1 : 0) != 0, (String)"\u6d3b\u52a8\u5f62\u5f0f\u91cd\u590d\uff01", (Object[])new Object[0]);
            for (TpmDeductionDetailMappingRelationActivityConfigDto tpmDeductionDetailMappingRelationActivityConfigDto : dto.getDeductionDetailMappingRelationActivityConfigList()) {
                TpmDeductionDetailMappingRelationActivityConfig config = new TpmDeductionDetailMappingRelationActivityConfig();
                config.setCode(code);
                config.setTenantCode(tenantCode);
                config.setDelFlag(DelFlagStatusEnum.NORMAL.getCode());
                config.setActivityTypeCode(tpmDeductionDetailMappingRelationActivityConfigDto.getActivityTypeCode());
                config.setActivityTypeName(tpmDeductionDetailMappingRelationActivityConfigDto.getActivityTypeName());
                config.setActivityFormCode(tpmDeductionDetailMappingRelationActivityConfigDto.getActivityFormCode());
                config.setActivityFormName(tpmDeductionDetailMappingRelationActivityConfigDto.getActivityFormName());
                configList.add(config);
            }
            for (TpmDeductionDetailMappingTextDto textDto : dto.getDeductionDetailMappingTextList()) {
                TpmDeductionDetailMappingText text = new TpmDeductionDetailMappingText();
                text.setCode(code);
                text.setText(textDto.getText());
                text.setTenantCode(tenantCode);
                text.setTenantCode(tenantCode);
                text.setDelFlag(DelFlagStatusEnum.NORMAL.getCode());
                textList.add(text);
            }
            if (!CollectionUtils.isNotEmpty((Collection)dto.getCustomerList())) continue;
            for (TpmDeductionDetailMappingCustomerDto customerDto : dto.getCustomerList()) {
                TpmDeductionDetailMappingCustomer customer = new TpmDeductionDetailMappingCustomer();
                customer.setCode(code);
                customer.setCustomerCode(customerDto.getCustomerCode());
                customer.setCustomerName(customerDto.getCustomerName());
                customer.setErpCode(customerDto.getErpCode());
                customer.setTenantCode(TenantUtils.getTenantCode());
                customer.setDelFlag(DelFlagStatusEnum.NORMAL.getCode());
                customerList.add(customer);
            }
        }
        this.importSaveData(entityList, configList, textList, customerList);
        log.info("\u6263\u8d39\u6620\u5c04\u5bfc\u5165\u4fdd\u5b58\u7ed3\u675f");
    }

    @Transactional(rollbackFor={Exception.class})
    public void importSaveData(List<TpmDeductionDetailMapping> entityList, List<TpmDeductionDetailMappingRelationActivityConfig> configList, List<TpmDeductionDetailMappingText> textList, List<TpmDeductionDetailMappingCustomer> customerList) {
        if (CollectionUtils.isNotEmpty(entityList)) {
            this.tpmDeductionDetailMappingRepository.saveBatch(entityList);
        }
        if (CollectionUtils.isNotEmpty(configList)) {
            this.deductionDetailMappingRelationActivityConfigRepository.saveBatch(configList);
        }
        if (CollectionUtils.isNotEmpty(textList)) {
            this.deductionDetailMappingTextRepository.saveBatch(textList);
        }
        if (CollectionUtils.isNotEmpty(customerList)) {
            this.tpmDeductionDetailMappingCustomerRepository.saveBatch(customerList);
        }
    }

    public TpmDeductionDetailMappingVo queryById(String id) {
        List customerList;
        List textList;
        if (StringUtils.isBlank((CharSequence)id)) {
            return null;
        }
        TpmDeductionDetailMapping entity = (TpmDeductionDetailMapping)((Object)this.tpmDeductionDetailMappingRepository.getById((Serializable)((Object)id)));
        Validate.notNull((Object)((Object)entity), (String)"\u6570\u636e\u4e0d\u5b58\u5728\uff0c\u8bf7\u5237\u65b0\u540e\u91cd\u8bd5\uff01", (Object[])new Object[0]);
        String tenantCode = TenantUtils.getTenantCode();
        List configList = ((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.deductionDetailMappingRelationActivityConfigRepository.lambdaQuery().eq(TpmDeductionDetailMappingRelationActivityConfig::getCode, (Object)entity.getCode())).eq(TenantFlagOpEntity::getTenantCode, (Object)tenantCode)).list();
        TpmDeductionDetailMappingVo tpmDeductionDetailMappingVo = (TpmDeductionDetailMappingVo)this.nebulaToolkitService.copyObjectByWhiteList((Object)entity, TpmDeductionDetailMappingVo.class, LinkedHashSet.class, ArrayList.class, new String[0]);
        if (CollectionUtils.isNotEmpty((Collection)configList)) {
            Collection tpmDeductionDetailMappingRelationActivityConfigVos = this.nebulaToolkitService.copyCollectionByBlankList((Iterable)configList, TpmDeductionDetailMappingRelationActivityConfig.class, TpmDeductionDetailMappingRelationActivityConfigVo.class, LinkedHashSet.class, ArrayList.class, new String[0]);
            tpmDeductionDetailMappingVo.setDeductionDetailMappingRelationActivityConfigList((List)tpmDeductionDetailMappingRelationActivityConfigVos);
        }
        if (CollectionUtils.isNotEmpty((Collection)(textList = ((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.deductionDetailMappingTextRepository.lambdaQuery().eq(TpmDeductionDetailMappingText::getCode, (Object)entity.getCode())).eq(TenantFlagOpEntity::getTenantCode, (Object)tenantCode)).list()))) {
            Collection tpmDeductionDetailMappingTextVos = this.nebulaToolkitService.copyCollectionByBlankList((Iterable)textList, TpmDeductionDetailMappingText.class, TpmDeductionDetailMappingTextVo.class, LinkedHashSet.class, ArrayList.class, new String[0]);
            tpmDeductionDetailMappingVo.setDeductionDetailMappingTextList((List)tpmDeductionDetailMappingTextVos);
        }
        if (CollectionUtils.isNotEmpty((Collection)(customerList = ((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.tpmDeductionDetailMappingCustomerRepository.lambdaQuery().eq(TpmDeductionDetailMappingCustomer::getCode, (Object)entity.getCode())).eq(TenantFlagOpEntity::getTenantCode, (Object)tenantCode)).list()))) {
            List customerVoList = (List)this.nebulaToolkitService.copyCollectionByWhiteList((Iterable)customerList, TpmDeductionDetailMappingCustomer.class, TpmDeductionDetailMappingCustomerVo.class, HashSet.class, ArrayList.class, new String[0]);
            tpmDeductionDetailMappingVo.setCustomerList(customerVoList);
        }
        return tpmDeductionDetailMappingVo;
    }

    public List<TpmDeductionDetailMappingDto> repeatValidate(List<TpmDeductionDetailMappingDto> dtoList) {
        if (CollectionUtils.isEmpty(dtoList)) {
            return Lists.newArrayList();
        }
        ArrayList<TpmDeductionDetailMappingDto> repeatList = new ArrayList<TpmDeductionDetailMappingDto>();
        for (TpmDeductionDetailMappingDto dto : dtoList) {
            Object customerDto2;
            List textList = dto.getDeductionDetailMappingTextList();
            List configList = dto.getDeductionDetailMappingRelationActivityConfigList();
            List mappingList = ((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.tpmDeductionDetailMappingRepository.lambdaQuery().eq(TenantFlagOpEntity::getTenantCode, (Object)TenantUtils.getTenantCode())).eq(StringUtils.isNotBlank((CharSequence)dto.getBusinessFormatCode()), TpmDeductionDetailMapping::getBusinessFormatCode, (Object)dto.getBusinessFormatCode())).eq(StringUtils.isNotBlank((CharSequence)dto.getBusinessUnitCode()), TpmDeductionDetailMapping::getBusinessUnitCode, (Object)dto.getBusinessUnitCode())).eq(StringUtils.isNotBlank((CharSequence)dto.getSalesInstitutionCode()), TpmDeductionDetailMapping::getSalesInstitutionCode, (Object)dto.getSalesInstitutionCode())).eq(StringUtils.isNotBlank((CharSequence)dto.getResaleCommercialCode()), TpmDeductionDetailMapping::getResaleCommercialCode, (Object)dto.getResaleCommercialCode())).eq(StringUtils.isNotBlank((CharSequence)dto.getFirstChannelCode()), TpmDeductionDetailMapping::getFirstChannelCode, (Object)dto.getFirstChannelCode())).eq(StringUtils.isNotBlank((CharSequence)dto.getSecondChannelCode()), TpmDeductionDetailMapping::getSecondChannelCode, (Object)dto.getSecondChannelCode())).eq(StringUtils.isNotBlank((CharSequence)dto.getChannelCode()), TpmDeductionDetailMapping::getChannelCode, (Object)dto.getChannelCode())).eq(StringUtils.isNotBlank((CharSequence)dto.getBuyWay()), TpmDeductionDetailMapping::getBuyWay, (Object)dto.getBuyWay())).eq(UuidFlagOpEntity::getDelFlag, (Object)DelFlagStatusEnum.NORMAL.getCode())).ne(StringUtils.isNotBlank((CharSequence)dto.getId()), UuidEntity::getId, (Object)dto.getId())).list();
            if (CollectionUtils.isEmpty((Collection)mappingList)) continue;
            List<String> codeList = mappingList.stream().map(o -> o.getCode()).collect(Collectors.toList());
            List customerList = dto.getCustomerList();
            if (CollectionUtils.isNotEmpty((Collection)customerList)) {
                List<Object> existsCustomerVoList = this.tpmDeductionDetailMappingCustomerRepository.findByCodes(codeList, TenantUtils.getTenantCode());
                existsCustomerVoList = existsCustomerVoList.stream().filter(s -> StringUtils.isNotBlank((CharSequence)s.getCustomerCode()) && StringUtils.isNotBlank((CharSequence)s.getCode())).collect(Collectors.toList());
                List existsCustomerCodes = existsCustomerVoList.stream().map(TpmDeductionDetailMappingCustomerVo::getCustomerCode).collect(Collectors.toList());
                for (Object customerDto2 : customerList) {
                    if (!existsCustomerCodes.contains(customerDto2.getCustomerCode())) continue;
                    List<Object> existsTextVos = this.deductionDetailMappingTextRepository.findByCodes(codeList, TenantUtils.getTenantCode());
                    existsTextVos = existsTextVos.stream().filter(h -> StringUtils.isNotBlank((CharSequence)h.getText()) && StringUtils.isNotBlank((CharSequence)h.getCode())).collect(Collectors.toList());
                    Map existsTextVoMap = existsTextVos.stream().collect(Collectors.toMap(TpmDeductionDetailMappingTextVo::getText, Function.identity(), (v1, v2) -> v2));
                    List textStringList = existsTextVos.stream().map(o -> o.getText()).collect(Collectors.toList());
                    for (TpmDeductionDetailMappingTextDto textDto : textList) {
                        if (!textStringList.contains(textDto.getText())) continue;
                        repeatList.add(dto);
                        TpmDeductionDetailMappingTextVo tpmDeductionDetailMappingTextVo = (TpmDeductionDetailMappingTextVo)existsTextVoMap.get(textDto.getText());
                        throw new IllegalArgumentException("\u5728\u6620\u5c04\u3010" + tpmDeductionDetailMappingTextVo.getCode() + "\u3011\u4e0b\uff0c\u5df2\u5b58\u5728\u2019\u6263\u8d39\u660e\u7ec6\u9879\u540d\u79f0\u2019\u914d\u7f6e\u3010" + textDto.getText() + "\u3011");
                    }
                    List<Object> configVos = this.deductionDetailMappingRelationActivityConfigRepository.findByCodes(codeList, TenantUtils.getTenantCode());
                    configVos = configVos.stream().filter(s -> StringUtils.isNotBlank((CharSequence)s.getActivityFormCode()) && StringUtils.isNotBlank((CharSequence)s.getCode())).collect(Collectors.toList());
                    Map configVoMap = configVos.stream().collect(Collectors.toMap(TpmDeductionDetailMappingRelationActivityConfigVo::getActivityFormCode, Function.identity(), (v1, v2) -> v2));
                    List formCodes = configVos.stream().map(o -> o.getActivityFormCode()).collect(Collectors.toList());
                    for (TpmDeductionDetailMappingRelationActivityConfigDto configDto : configList) {
                        if (!formCodes.contains(configDto.getActivityFormCode())) continue;
                        repeatList.add(dto);
                        TpmDeductionDetailMappingRelationActivityConfigVo con = (TpmDeductionDetailMappingRelationActivityConfigVo)configVoMap.get(configDto.getActivityFormCode());
                        throw new IllegalArgumentException("\u5728\u6620\u5c04\u3010" + con.getCode() + "\u3011\u4e0b\uff0c\u5df2\u5b58\u5728\u2018\u6d3b\u52a8\u5f62\u5f0f\u2019\u914d\u7f6e\u3010" + configDto.getActivityFormCode() + "\u3011\u914d\u7f6e");
                    }
                }
                continue;
            }
            List<Object> existsTextVos = this.deductionDetailMappingTextRepository.findByCodes(codeList, TenantUtils.getTenantCode());
            existsTextVos = existsTextVos.stream().filter(h -> StringUtils.isNotBlank((CharSequence)h.getText()) && StringUtils.isNotBlank((CharSequence)h.getCode())).collect(Collectors.toList());
            Map existsTextVoMap = existsTextVos.stream().collect(Collectors.toMap(TpmDeductionDetailMappingTextVo::getText, Function.identity(), (v1, v2) -> v2));
            List textStringList = existsTextVos.stream().map(o -> o.getText()).collect(Collectors.toList());
            customerDto2 = textList.iterator();
            while (customerDto2.hasNext()) {
                TpmDeductionDetailMappingTextDto textDto = (TpmDeductionDetailMappingTextDto)customerDto2.next();
                if (!textStringList.contains(textDto.getText())) continue;
                repeatList.add(dto);
                TpmDeductionDetailMappingTextVo tpmDeductionDetailMappingTextVo = (TpmDeductionDetailMappingTextVo)existsTextVoMap.get(textDto.getText());
                throw new IllegalArgumentException("\u5728\u6620\u5c04\u3010" + tpmDeductionDetailMappingTextVo.getCode() + "\u3011\u4e0b\uff0c\u5df2\u5b58\u5728\u2019\u6263\u8d39\u660e\u7ec6\u9879\u540d\u79f0\u2019\u914d\u7f6e\u3010" + textDto.getText() + "\u3011");
            }
            List<Object> configVos = this.deductionDetailMappingRelationActivityConfigRepository.findByCodes(codeList, TenantUtils.getTenantCode());
            configVos = configVos.stream().filter(s -> StringUtils.isNotBlank((CharSequence)s.getActivityFormCode()) && StringUtils.isNotBlank((CharSequence)s.getCode())).collect(Collectors.toList());
            Map configVoMap = configVos.stream().collect(Collectors.toMap(TpmDeductionDetailMappingRelationActivityConfigVo::getActivityFormCode, Function.identity(), (v1, v2) -> v2));
            List formCodes = configVos.stream().map(o -> o.getActivityFormCode()).collect(Collectors.toList());
            for (TpmDeductionDetailMappingRelationActivityConfigDto configDto : configList) {
                if (!formCodes.contains(configDto.getActivityFormCode())) continue;
                repeatList.add(dto);
                TpmDeductionDetailMappingRelationActivityConfigVo con = (TpmDeductionDetailMappingRelationActivityConfigVo)configVoMap.get(configDto.getActivityFormCode());
                throw new IllegalArgumentException("\u5728\u6620\u5c04\u3010" + con.getCode() + "\u3011\u4e0b\uff0c\u5df2\u5b58\u5728\u2018\u6d3b\u52a8\u5f62\u5f0f\u2019\u914d\u7f6e\u3010" + configDto.getActivityFormCode() + "\u3011\u914d\u7f6e");
            }
        }
        return repeatList;
    }

    public TpmDeductionDetailMappingVo findByCode(String applyMappingCode) {
        List textList;
        TpmDeductionDetailMapping entity = this.tpmDeductionDetailMappingRepository.findByCode(applyMappingCode);
        String tenantCode = TenantUtils.getTenantCode();
        List configList = ((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.deductionDetailMappingRelationActivityConfigRepository.lambdaQuery().eq(TpmDeductionDetailMappingRelationActivityConfig::getCode, (Object)entity.getCode())).eq(TenantFlagOpEntity::getTenantCode, (Object)tenantCode)).list();
        TpmDeductionDetailMappingVo tpmDeductionDetailMappingVo = (TpmDeductionDetailMappingVo)this.nebulaToolkitService.copyObjectByWhiteList((Object)entity, TpmDeductionDetailMappingVo.class, LinkedHashSet.class, ArrayList.class, new String[0]);
        if (CollectionUtils.isNotEmpty((Collection)configList)) {
            Collection tpmDeductionDetailMappingRelationActivityConfigVos = this.nebulaToolkitService.copyCollectionByBlankList((Iterable)configList, TpmDeductionDetailMappingRelationActivityConfig.class, TpmDeductionDetailMappingRelationActivityConfigVo.class, LinkedHashSet.class, ArrayList.class, new String[0]);
            tpmDeductionDetailMappingVo.setDeductionDetailMappingRelationActivityConfigList((List)tpmDeductionDetailMappingRelationActivityConfigVos);
        }
        if (CollectionUtils.isNotEmpty((Collection)(textList = ((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.deductionDetailMappingTextRepository.lambdaQuery().eq(TpmDeductionDetailMappingText::getCode, (Object)entity.getCode())).eq(TenantFlagOpEntity::getTenantCode, (Object)tenantCode)).list()))) {
            Collection tpmDeductionDetailMappingTextVos = this.nebulaToolkitService.copyCollectionByBlankList((Iterable)textList, TpmDeductionDetailMappingText.class, TpmDeductionDetailMappingTextVo.class, LinkedHashSet.class, ArrayList.class, new String[0]);
            tpmDeductionDetailMappingVo.setDeductionDetailMappingTextList((List)tpmDeductionDetailMappingTextVos);
        }
        return tpmDeductionDetailMappingVo;
    }

    public List<TpmDeductionDetailMappingVo> findByDto(TpmDeductionDetailMappingDto dto) {
        List<TpmDeductionDetailMapping> mappingList;
        if (Objects.isNull(dto)) {
            dto = new TpmDeductionDetailMappingDto();
        }
        if (CollectionUtils.isEmpty(mappingList = this.tpmDeductionDetailMappingRepository.findByDto(dto))) {
            return Lists.newArrayList();
        }
        return (List)this.nebulaToolkitService.copyCollectionByWhiteList(mappingList, TpmDeductionDetailMapping.class, TpmDeductionDetailMappingVo.class, HashSet.class, ArrayList.class, new String[0]);
    }

    private void createValidate(TpmDeductionDetailMappingDto dto) {
        Validate.notNull((Object)dto, (String)"\u65b0\u589e\u65f6\uff0c\u5bf9\u8c61\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        dto.setId(null);
        Validate.notBlank((CharSequence)dto.getName(), (String)"\u6263\u8d39\u6620\u5c04\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.isTrue((dto.getName().length() <= 255 ? 1 : 0) != 0, (String)"\u6263\u8d39\u6620\u5c04\u540d\u79f0\u8d85\u957f\uff0c\u6700\u957f\u652f\u6301255", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)dto.getBusinessFormatCode(), (String)"\u65b0\u589e\u6570\u636e\u65f6\uff0c\u4e1a\u6001\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)dto.getBusinessUnitCode(), (String)"\u65b0\u589e\u6570\u636e\u65f6\uff0c\u4e1a\u52a1\u5355\u5143\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        List deductionDetailMappingTextList = dto.getDeductionDetailMappingTextList();
        Validate.noNullElements((Iterable)deductionDetailMappingTextList, (String)"\u65b0\u589e\u6570\u636e\u65f6\uff0c\u6263\u8d39\u660e\u7ec6\u9879\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        deductionDetailMappingTextList.forEach(e -> {
            Validate.notBlank((CharSequence)e.getText(), (String)"\u65b0\u589e\u6570\u636e\u65f6\uff0c\u6263\u8d39\u660e\u7ec6\u9879\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
            Validate.isTrue((e.getText().length() <= 255 ? 1 : 0) != 0, (String)"\u6263\u8d39\u660e\u7ec6\u9879\u540d\u79f0\u8d85\u957f\uff0c\u6700\u957f\u652f\u6301255", (Object[])new Object[0]);
        });
        List deductionDetailMappingRelationActivityConfigList = dto.getDeductionDetailMappingRelationActivityConfigList();
        Validate.noNullElements((Iterable)deductionDetailMappingRelationActivityConfigList, (String)"\u65b0\u589e\u6570\u636e\u65f6\uff0c\u5173\u8054\u6d3b\u52a8\u914d\u7f6e\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        HashSet activityFormCode = Sets.newHashSet();
        deductionDetailMappingRelationActivityConfigList.forEach(e -> {
            Validate.notBlank((CharSequence)e.getActivityFormCode(), (String)"\u65b0\u589e\u6570\u636e\u65f6\uff0c\u6d3b\u52a8\u5f62\u5f0f\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
            Validate.notBlank((CharSequence)e.getActivityTypeCode(), (String)"\u65b0\u589e\u6570\u636e\u65f6\uff0c\u6d3b\u52a8\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
            Validate.isTrue((!activityFormCode.contains(e.getActivityFormCode()) ? 1 : 0) != 0, (String)"\u5173\u8054\u6d3b\u52a8\u5f62\u5f0f\u4e0d\u80fd\u91cd\u590d\u9009\u62e9", (Object[])new Object[0]);
            activityFormCode.add(e.getActivityFormCode());
        });
    }

    private void updateValidate(TpmDeductionDetailMappingDto dto) {
        Validate.notNull((Object)dto, (String)"\u4fee\u6539\u65f6\uff0c\u5bf9\u8c61\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)dto.getId(), (String)"\u4fee\u6539\u6570\u636e\u65f6\uff0cID\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)dto.getBusinessFormatCode(), (String)"\u4fee\u6539\u6570\u636e\u65f6\uff0c\u4e1a\u6001\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)dto.getBusinessUnitCode(), (String)"\u4fee\u6539\u6570\u636e\u65f6\uff0c\u4e1a\u52a1\u5355\u5143\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)dto.getCode(), (String)"\u4fee\u6539\u6570\u636e\u65f6\uff0c\u8fd0\u8d39\u4ef7\u683c\u7ef4\u62a4\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        List deductionDetailMappingTextList = dto.getDeductionDetailMappingTextList();
        Validate.noNullElements((Iterable)deductionDetailMappingTextList, (String)"\u4fee\u6539\u6570\u636e\u65f6\uff0c\u6263\u8d39\u660e\u7ec6\u9879\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        deductionDetailMappingTextList.forEach(e -> {
            String cfr_ignored_0 = (String)Validate.notBlank((CharSequence)e.getText(), (String)"\u4fee\u6539\u6570\u636e\u65f6\uff0c\u6263\u8d39\u660e\u7ec6\u9879\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        });
        List deductionDetailMappingRelationActivityConfigList = dto.getDeductionDetailMappingRelationActivityConfigList();
        Validate.noNullElements((Iterable)deductionDetailMappingRelationActivityConfigList, (String)"\u4fee\u6539\u6570\u636e\u65f6\uff0c\u5173\u8054\u6d3b\u52a8\u914d\u7f6e\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        deductionDetailMappingTextList.forEach(e -> {
            Validate.notBlank((CharSequence)e.getText(), (String)"\u65b0\u589e\u6570\u636e\u65f6\uff0c\u6263\u8d39\u660e\u7ec6\u9879\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
            Validate.isTrue((e.getText().length() <= 255 ? 1 : 0) != 0, (String)"\u6263\u8d39\u660e\u7ec6\u9879\u540d\u79f0\u8d85\u957f\uff0c\u6700\u957f\u652f\u6301255", (Object[])new Object[0]);
        });
        HashSet activityFormCode = Sets.newHashSet();
        log.info("\u5546\u8d85\u6263\u8d39\u6620\u5c04-\u5173\u8054\u6d3b\u52a8\u5f62\u5f0f,{}", (Object)JSON.toJSONString((Object)deductionDetailMappingRelationActivityConfigList));
        deductionDetailMappingRelationActivityConfigList.forEach(e -> {
            log.info("\u5546\u8d85\u6263\u8d39\u6620\u5c04-\u5173\u8054\u6d3b\u52a8\u5f62\u5f0fSET,{}", (Object)JSON.toJSONString((Object)activityFormCode));
            Validate.notBlank((CharSequence)e.getActivityFormCode(), (String)"\u4fee\u6539\u6570\u636e\u65f6\uff0c\u6d3b\u52a8\u5f62\u5f0f\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
            Validate.notBlank((CharSequence)e.getActivityTypeCode(), (String)"\u4fee\u6539\u6570\u636e\u65f6\uff0c\u6d3b\u52a8\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
            Validate.isTrue((!activityFormCode.contains(e.getActivityFormCode()) ? 1 : 0) != 0, (String)"\u5173\u8054\u6d3b\u52a8\u5f62\u5f0f\u4e0d\u80fd\u91cd\u590d\u9009\u62e9", (Object[])new Object[0]);
            activityFormCode.add(e.getActivityFormCode());
        });
    }
}

